# 機能設計書 16-bun upgrade

## 概要

本ドキュメントは、Bunランタイムが提供するBun自体のアップグレード機能「bun upgrade」の設計を記述する。

### 本機能の処理概要

bun upgradeは、Bunランタイム自体を最新バージョンにアップグレードするCLIコマンドである。GitHubリリースから最新のBunバイナリをダウンロードし、現在のインストールを置き換える。

**業務上の目的・背景**：Bunは活発に開発されており、パフォーマンス改善、バグ修正、新機能が頻繁にリリースされる。bun upgradeにより、ユーザーは簡単に最新バージョンを取得できる。

**機能の利用シーン**：
- Bunの新機能を利用したい場合
- セキュリティアップデートの適用
- バグ修正バージョンへの更新
- 特定バージョンへのダウングレード

**主要な処理内容**：
1. 現在のBunバージョン確認
2. GitHubリリースAPIから最新バージョン情報取得
3. プラットフォーム別バイナリのダウンロード
4. バイナリの検証と展開
5. 既存バイナリの置き換え

**関連システム・外部連携**：
- GitHub Releases API
- ファイルシステム

**権限による制御**：インストール先ディレクトリへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | upgrade | 主画面 | bun upgradeコマンドの実行インターフェース |

## 機能種別

システム管理 / ネットワーク通信 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| version | string | No | インストールするバージョン（省略時は最新） | 有効なバージョン文字列 |
| --canary | boolean | No | canaryビルドをインストール | - |
| --stable | boolean | No | 安定版をインストール | - |
| --force | boolean | No | 同一バージョンでも強制再インストール | - |

### 入力データソース

- コマンドライン引数
- GitHub Releases API（https://api.github.com/repos/oven-sh/bun/releases）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| bun binary | File | 更新されたBunバイナリ |

### 出力先

- Bunのインストールディレクトリ（通常 ~/.bun/bin/bun）

## 処理フロー

### 処理シーケンス

```
1. 現在のバージョン確認
   └─ 実行中のBunバージョンを取得
2. 最新バージョン情報取得
   └─ GitHub Releases APIに問い合わせ
3. 更新要否判定
   └─ 現在バージョンと比較
4. バイナリダウンロード
   └─ プラットフォーム別のアーカイブを取得
5. 展開と検証
   └─ チェックサム検証、解凍
6. バイナリ置換
   └─ 既存バイナリを新バイナリで置換
7. 完了メッセージ
   └─ 新バージョン情報を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[現在バージョン確認]
    B --> C[GitHub API問い合わせ]
    C --> D{新バージョンあり?}
    D -->|No| E[最新版メッセージ]
    D -->|Yes| F[バイナリダウンロード]
    F --> G[チェックサム検証]
    G --> H{検証OK?}
    H -->|No| I[エラー: ダウンロード破損]
    H -->|Yes| J[バイナリ展開]
    J --> K[既存バイナリ置換]
    K --> L[成功メッセージ]
    E --> M[終了]
    I --> M
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 自動検出 | OSとアーキテクチャを自動検出 | 常時 |
| BR-02 | バージョン比較 | 現在より新しい場合のみ更新 | --force未指定時 |
| BR-03 | canary優先 | --canary指定時は安定版より新しくても更新 | --canary指定時 |

### 計算ロジック

- semverによるバージョン比較
- プラットフォーム判定（darwin/linux/windows × x64/arm64）

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NetworkError | GitHubに接続できない | ネットワーク確認 |
| - | PermissionDenied | インストールディレクトリに書き込めない | 権限確認、sudoで実行 |
| - | ChecksumMismatch | ダウンロードファイルが破損 | 再実行 |
| - | VersionNotFound | 指定バージョンが存在しない | バージョン指定を確認 |

### リトライ仕様

ネットワークエラー時は自動リトライ。

## トランザクション仕様

バイナリ置換は単一操作であり、失敗した場合は元のバイナリが残る可能性がある。

## パフォーマンス要件

ダウンロードはHTTP/2による高速転送。

## セキュリティ考慮事項

- チェックサム検証によるバイナリ整合性確認
- HTTPS通信による安全なダウンロード

## 備考

- curlを使用したマニュアルインストールも可能
- npm経由でのインストールは別途対応

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | upgrade_command.zig | `src/cli/upgrade_command.zig` | UpgradeCommand.exec関数 |

**主要処理フロー**:
1. **1行目**: UpgradeCommand構造体定義
2. **2-15行目**: exec関数でUpgradeBun.upgradeを呼び出し
3. **17-43行目**: UpgradeBun構造体の定義

#### Step 2: アップグレード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | upgrade_command.zig | `src/cli/upgrade_command.zig` | UpgradeBun.upgrade関数の詳細 |

**主要処理フロー**:
- **55-65行目**: GitHub APIへのリクエスト
- **85-120行目**: バージョン比較とダウンロード判定
- **150-200行目**: バイナリダウンロードと展開
- **220-250行目**: バイナリ置換処理

### プログラム呼び出し階層図

```
UpgradeCommand.exec
    │
    └─ UpgradeBun.upgrade
           │
           ├─ getCurrentVersion
           ├─ fetchLatestRelease (GitHub API)
           ├─ compareVersions
           ├─ downloadBinary
           ├─ verifyChecksum
           └─ replaceBinary
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドオプション ───▶ バージョン指定解析 ──────────▶ ターゲットバージョン
                            │
                            ▼
GitHub API ─────────▶ リリース情報取得 ──────────────▶ ダウンロードURL
                            │
                            ▼
ダウンロードURL ────▶ バイナリダウンロード ──────────▶ アーカイブファイル
                            │
                            ▼
アーカイブ ─────────▶ 展開・検証 ───────────────────▶ Bunバイナリ
                            │
                            ▼
                     バイナリ置換 ───────────────────▶ 更新されたBun
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| upgrade_command.zig | `src/cli/upgrade_command.zig` | ソース | CLIエントリーポイント、アップグレード処理 |
| http.zig | `src/http.zig` | ソース | HTTP通信処理 |
