# 機能設計書 17-bun init

## 概要

本ドキュメントは、Bunランタイムが提供するプロジェクト初期化機能「bun init」の設計を記述する。

### 本機能の処理概要

bun initは、新しいBunプロジェクトを対話的に初期化するCLIコマンドである。package.json、tsconfig.json、gitignore等の基本ファイルを生成し、プロジェクトの骨格を作成する。

**業務上の目的・背景**：新しいプロジェクトを開始する際、必要な設定ファイルを手動で作成するのは煩雑である。bun initは、npm initと同等の機能を提供しながら、TypeScript対応やBun固有の設定を含む最適なプロジェクト構造を自動生成する。

**機能の利用シーン**：
- 新規プロジェクトの開始
- 既存ディレクトリへのプロジェクト設定追加
- Blankテンプレートからのプロジェクト作成
- Reactプロジェクトのセットアップ
- TypeScriptライブラリプロジェクトの作成

**主要な処理内容**：
1. 対話的なプロジェクト情報入力
2. テンプレート選択（Blank/React/Library）
3. package.jsonの生成
4. tsconfig.jsonの生成
5. .gitignoreの生成
6. エントリーポイントファイルの生成
7. README.mdの生成
8. 依存関係のインストール

**関連システム・外部連携**：
- ファイルシステム
- bun install（依存関係インストール）

**権限による制御**：特に権限による制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | init | 主画面 | bun initコマンドの実行インターフェース |

## 機能種別

プロジェクト初期化 / ファイル生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| directory | string | No | 初期化するディレクトリ | 有効なパス |
| --minimal / -m | boolean | No | 最小限のファイルのみ生成 | - |
| --yes / -y | boolean | No | 対話なしでデフォルト値使用 | - |
| --react / -r | boolean | No | Reactテンプレートを使用 | - |
| --react=tailwind | string | No | React + Tailwindテンプレート | - |
| --react=shadcn | string | No | React + shadcn/uiテンプレート | - |

### 入力データソース

- コマンドライン引数
- 標準入力（対話的入力）
- 既存のpackage.json（存在する場合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| package.json | File | プロジェクト設定ファイル |
| tsconfig.json | File | TypeScript設定ファイル |
| .gitignore | File | Git除外設定 |
| index.ts | File | エントリーポイント |
| README.md | File | プロジェクト説明（--minimal時は生成されない） |
| CLAUDE.md | File | AI支援ルールファイル（Claude Code検出時） |

### 出力先

- 現在のディレクトリまたは指定されたディレクトリ

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ オプションとディレクトリ指定を解析
2. ディレクトリ準備
   └─ 指定ディレクトリがなければ作成
3. 既存package.json確認
   └─ 存在する場合は読み込み
4. テンプレート選択
   └─ 対話的にテンプレート種類を選択
5. プロジェクト情報入力
   └─ パッケージ名、エントリーポイント等
6. ファイル生成
   └─ 各種設定ファイルを生成
7. 依存関係インストール
   └─ bun installを実行
8. 完了メッセージ
   └─ 次のステップを表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C{ディレクトリ指定?}
    C -->|Yes| D[ディレクトリ作成]
    C -->|No| E[現在ディレクトリ使用]
    D --> F[既存package.json確認]
    E --> F
    F --> G{--yes指定?}
    G -->|Yes| H[デフォルト値使用]
    G -->|No| I[対話的入力]
    H --> J[テンプレート選択]
    I --> J
    J --> K[ファイル生成]
    K --> L{依存関係あり?}
    L -->|Yes| M[bun install実行]
    L -->|No| N[完了メッセージ]
    M --> N
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 既存維持 | 既存のtsconfig.json/jsconfig.jsonは上書きしない | ファイル存在時 |
| BR-02 | パッケージ名正規化 | ディレクトリ名から小文字・ハイフン形式に変換 | 常時 |
| BR-03 | TypeScript優先 | .ts拡張子をデフォルトに | 常時 |
| BR-04 | エントリー推論 | 既存のindex.*ファイルを検出して使用 | ファイル存在時 |

### 計算ロジック

- パッケージ名正規化: 大文字を小文字に、スペースをハイフンに変換

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DirectoryError | ディレクトリ作成に失敗 | 権限を確認 |
| - | FileWriteError | ファイル書き込みに失敗 | 権限を確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

ファイル生成はアトミックではない。途中で失敗した場合、一部のファイルのみ生成された状態になる可能性がある。

## パフォーマンス要件

対話的なコマンドのため、レスポンスの速さが重要。

## セキュリティ考慮事項

特になし。

## 備考

- Cursorエディタ検出時は.cursor/rulesにルールファイルを生成
- Claude Code検出時はCLAUDE.mdを生成

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | init_command.zig | `src/cli/init_command.zig` | InitCommand.exec関数 |

**主要処理フロー**:
1. **1-40行目**: InitCommand構造体とprompt関数（対話入力）
2. **44-177行目**: processRadioButton関数（選択UI）
3. **181-223行目**: radio関数（ラジオボタン選択のラッパー）
4. **225-311行目**: Assets構造体（テンプレートファイル）
5. **349-867行目**: exec関数（メイン処理）

#### Step 2: テンプレート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | init_command.zig | `src/cli/init_command.zig` | Template列挙型、テンプレート生成処理 |

**主要処理フロー**:
- **917-994行目**: Template列挙型とテンプレート種別定義
- **1000-1103行目**: Agent Rule生成（CLAUDE.md、Cursor rules）
- **1105-1245行目**: Reactテンプレートのファイル定義

#### Step 3: ファイル生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | init_command.zig | `src/cli/init_command.zig` | Assets.create、Assets.createNew関数 |

**主要処理フロー**:
- **232-253行目**: create関数（既知アセット作成）
- **244-252行目**: createNew関数（新規ファイル作成）

### プログラム呼び出し階層図

```
InitCommand.exec
    │
    ├─ prompt (対話入力)
    │      └─ 標準入力読み取り
    │
    ├─ radio (テンプレート選択)
    │      └─ processRadioButton
    │
    ├─ Template判定
    │      ├─ .blank → 基本ファイル生成
    │      ├─ .react_* → Reactテンプレート生成
    │      └─ .typescript_library → ライブラリ設定
    │
    ├─ Assets.create / Assets.createNew
    │      └─ ファイル書き込み
    │
    ├─ createAgentRule
    │      └─ CLAUDE.md / Cursor rules生成
    │
    └─ bun install (子プロセス)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数 ────────────▶ オプション解析 ──────────────▶ 設定値
                            │
                            ▼
標準入力 ───────────▶ 対話入力 ─────────────────────▶ プロジェクト情報
                            │
                            ▼
テンプレート ───────▶ Assets組み立て ──────────────▶ ファイル群
                            │
                            ▼
                     ファイル書き込み ─────────────▶ package.json等
                            │
                            ▼
                     bun install ──────────────────▶ node_modules/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| init_command.zig | `src/cli/init_command.zig` | ソース | CLIエントリーポイント、テンプレート処理 |
| gitignore.default | `src/cli/init/gitignore.default` | テンプレート | .gitignoreテンプレート |
| tsconfig.default.json | `src/cli/init/tsconfig.default.json` | テンプレート | tsconfig.jsonテンプレート |
| README.default.md | `src/cli/init/README.default.md` | テンプレート | README.mdテンプレート |
| rule.md | `src/init/rule.md` | テンプレート | CLAUDE.md / Cursor rulesテンプレート |
| react-app/ | `src/init/react-app/` | ディレクトリ | Reactテンプレートファイル群 |
| react-tailwind/ | `src/init/react-tailwind/` | ディレクトリ | React + Tailwindテンプレート |
| react-shadcn/ | `src/init/react-shadcn/` | ディレクトリ | React + shadcn/uiテンプレート |
