# 機能設計書 18-bun create

## 概要

本ドキュメントは、Bunランタイムが提供するテンプレートプロジェクト作成機能「bun create」の設計を記述する。

### 本機能の処理概要

bun createは、テンプレートリポジトリから新しいプロジェクトを作成するCLIコマンドである。GitHubリポジトリ、公式テンプレート、またはローカルフォルダをソースとして、プロジェクトを scaffolding する。

**業務上の目的・背景**：新しいプロジェクトを開始する際、ボイラープレートコードの準備は時間がかかる。bun createは、create-react-appやcreate-viteと同様に、テンプレートから即座にプロジェクトを生成できる。

**機能の利用シーン**：
- Next.js、React等のフレームワークプロジェクト作成
- 企業内テンプレートからのプロジェクト生成
- GitHubリポジトリをテンプレートとして使用
- ローカルテンプレートからのプロジェクト複製

**主要な処理内容**：
1. テンプレート指定の解析（GitHub URL、公式テンプレート名、ローカルパス）
2. テンプレートのダウンロードまたはコピー
3. tarballの展開（GitHub/公式テンプレートの場合）
4. package.jsonの変換・調整
5. 依存関係のインストール
6. Gitリポジトリの初期化

**関連システム・外部連携**：
- GitHub API（リポジトリtarball取得）
- Bun公式テンプレートサーバー
- ファイルシステム

**権限による制御**：特に権限による制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | create | 主画面 | bun createコマンドの実行インターフェース |

## 機能種別

プロジェクト生成 / ネットワーク通信 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | string | Yes | テンプレート名またはURL | 有効なテンプレート指定 |
| destination | string | No | 作成先ディレクトリ | 有効なパス |
| --force | boolean | No | 既存ファイルを上書き | - |
| --no-install | boolean | No | 依存関係インストールをスキップ | - |
| --no-git | boolean | No | Git初期化をスキップ | - |
| --verbose | boolean | No | 詳細ログを出力 | - |
| --open | boolean | No | 完了後ブラウザで開く | - |

### 入力データソース

- コマンドライン引数
- GitHubリポジトリ（user/repo形式）
- 公式テンプレート一覧
- ローカルディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| project_directory | Directory | 作成されたプロジェクトディレクトリ |
| node_modules | Directory | インストールされた依存関係 |
| .git | Directory | Gitリポジトリ（--no-git未指定時） |

### 出力先

- 指定されたディレクトリまたはテンプレート名から推定されたディレクトリ

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ テンプレート指定と出力先を解析
2. テンプレート種別判定
   └─ GitHub/公式/ローカルを判定
3. テンプレート取得
   └─ ダウンロードまたはローカルコピー
4. tarball展開（リモートの場合）
   └─ gzip解凍、tarアーカイブ展開
5. 競合ファイル確認
   └─ 既存ファイルとの競合チェック
6. ファイル配置
   └─ テンプレートファイルを展開
7. package.json調整
   └─ 必要に応じて変換
8. 依存関係インストール
   └─ bun install実行
9. Git初期化
   └─ git init実行
10. 完了メッセージ
    └─ 次のステップを表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C{テンプレート種別?}
    C -->|GitHub| D[GitHubからtarball取得]
    C -->|公式| E[公式サーバーからtarball取得]
    C -->|ローカル| F[ローカルディレクトリコピー]
    D --> G[tarball展開]
    E --> G
    F --> H[ファイル配置]
    G --> H
    H --> I{競合あり?}
    I -->|Yes, --forceなし| J[エラー: 競合ファイル]
    I -->|Yes, --forceあり| K[上書き]
    I -->|No| K
    K --> L{--no-install?}
    L -->|No| M[bun install実行]
    L -->|Yes| N{--no-git?}
    M --> N
    N -->|No| O[git init]
    N -->|Yes| P[完了メッセージ]
    O --> P
    J --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | GitHub URL判定 | owner/repoまたはhttps://github.com/...を認識 | URL形式時 |
| BR-02 | create-プレフィックス | テンプレート名にcreate-プレフィックスがない場合は追加 | 単純名時 |
| BR-03 | 競合回避 | README.md, .gitignore等は競合対象から除外 | 常時 |
| BR-04 | node_modulesスキップ | テンプレートのnode_modulesはコピーしない | 常時 |

### 計算ロジック

- テンプレート名解析: @スコープ、/区切り、@バージョン指定の解析
- ディレクトリ名推定: テンプレート名からプロジェクト名を推定

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TemplateNotFound | テンプレートが存在しない | テンプレート名を確認 |
| - | HTTPForbidden | GitHub API制限に達した | GITHUB_ACCESS_TOKEN設定 |
| - | ConflictError | 既存ファイルと競合 | --force使用または別ディレクトリ |
| - | NetworkError | ダウンロードに失敗 | ネットワーク確認 |

### リトライ仕様

ネットワークエラー時は自動リトライ。GitHub 403エラー時は待機後リトライ。

## トランザクション仕様

ファイル展開はアトミックではない。途中で失敗した場合、部分的に展開された状態になる可能性がある。

## パフォーマンス要件

tarball展開の高速処理。

## セキュリティ考慮事項

- GITHUB_ACCESS_TOKEN環境変数による認証
- テンプレートのpostinstallスクリプトは信頼確認が必要

## 備考

- `bunx create-xxx` としても同等の動作が可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | create_command.zig | `src/cli/create_command.zig` | CreateCommand.exec関数 |

**主要処理フロー**:
1. **1-10行目**: 初期化関数とstore初期化
2. **12-27行目**: スキップ対象ディレクトリ・ファイル定義
3. **142-191行目**: CreateOptions構造体（CLIオプション）
4. **194-867行目**: CreateCommand.exec関数（メイン処理）

#### Step 2: テンプレート取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | create_command.zig | `src/cli/create_command.zig` | Example構造体、fetch関数 |

**主要処理フロー**:
- tarball取得とgunzip展開
- tar展開とファイル配置

#### Step 3: ファイル展開を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_command.zig | `src/cli/create_command.zig` | Archiver使用部分 |

### プログラム呼び出し階層図

```
CreateCommand.exec
    │
    ├─ CreateOptions.parse
    │      └─ CLIオプション解析
    │
    ├─ テンプレート種別判定
    │      ├─ jslike_file → runOnEntryPoint
    │      ├─ github_repository → fetchFromGitHub
    │      ├─ official → Example.fetch
    │      └─ local_folder → ローカルコピー
    │
    ├─ Zlib.ZlibReaderArrayList
    │      └─ gzip展開
    │
    ├─ Archiver.extractToDisk
    │      └─ tarアーカイブ展開
    │
    ├─ package.json変換
    │      └─ プロジェクト名等の調整
    │
    └─ bun install (子プロセス)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テンプレート指定 ───────▶ 種別判定 ────────────────────▶ ダウンロード先URL
                            │
                            ▼
GitHub/公式 ────────────▶ tarball取得 ──────────────────▶ 圧縮アーカイブ
                            │
                            ▼
                     gzip展開 ─────────────────────────▶ tarアーカイブ
                            │
                            ▼
                     tar展開 ──────────────────────────▶ ファイル群
                            │
                            ▼
                     ファイル配置 ─────────────────────▶ プロジェクトディレクトリ
                            │
                            ▼
                     bun install ──────────────────────▶ node_modules/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| create_command.zig | `src/cli/create_command.zig` | ソース | CLIエントリーポイント、テンプレート処理 |
| archiver.zig | `src/archiver.zig` | ソース | tarアーカイブ展開 |
| zlib.zig | `src/zlib.zig` | ソース | gzip展開 |
| http.zig | `src/http.zig` | ソース | HTTP通信 |
