# 機能設計書 25-bun outdated

## 概要

本ドキュメントは、Bunパッケージマネージャーの `bun outdated` コマンドの機能設計を記述する。このコマンドは、プロジェクトの依存パッケージで更新可能なバージョンがあるかを確認する。

### 本機能の処理概要

`bun outdated` は、lockfileにインストールされているパッケージのバージョンとnpmレジストリ上の最新バージョンを比較し、更新可能なパッケージを一覧表示する機能を提供する。

**業務上の目的・背景**：ソフトウェア開発において、依存パッケージを最新に保つことはセキュリティと機能面で重要である。しかし、大量の依存パッケージがある場合、手動でバージョンを確認するのは困難である。この機能により、更新が必要なパッケージを効率的に特定できる。

**機能の利用シーン**：
- 定期的な依存関係の棚卸し
- セキュリティ更新の確認
- メジャーバージョンアップグレードの計画
- CI/CDパイプラインでの依存関係監視

**主要な処理内容**：
1. lockfileの読み込みと依存パッケージの抽出
2. npmレジストリへのバージョン情報照会
3. 現在のバージョン、希望バージョン、最新バージョンの比較
4. 更新可能なパッケージの表形式表示

**関連システム・外部連携**：
- npmレジストリ（registry.npmjs.org等）
- プライベートnpmレジストリ

**権限による制御**：レジストリへのread権限が必要。プライベートパッケージの場合は認証が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | outdated | 主画面 | 古いパッケージの一覧表示 |

## 機能種別

データ連携（外部API通信）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| package | string | No | 特定パッケージのみをチェック（複数指定可） | - |
| --update | boolean | No | 更新を実行（bun update相当） | - |
| --json | boolean | No | JSON形式で出力 | - |

### 入力データソース

- bun.lockb / bun.lock（lockfile）
- package.json（バージョン範囲指定）
- npmレジストリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Package | string | パッケージ名 |
| Current | string | 現在インストールされているバージョン |
| Wanted | string | package.jsonの範囲内で最新のバージョン |
| Latest | string | レジストリ上の最新バージョン |
| Workspace | string | 該当するワークスペース名 |
| Type | string | 依存関係の種類（dependencies/devDependencies等） |

### 出力先

- 標準出力（コンソール）- テーブル形式またはJSON形式

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ パッケージ指定、--update、--jsonフラグを解析
2. lockfileの読み込み
   └─ Lockfile.loadFromCwdで読み込み
3. 依存パッケージの抽出
   └─ ワークスペースパッケージも含めて抽出
4. レジストリへの問い合わせ
   └─ 各パッケージの最新バージョン情報を取得
5. バージョン比較
   ├─ Current: lockfile上のバージョン
   ├─ Wanted: package.json範囲内の最新
   └─ Latest: レジストリ上の最新
6. 結果の整形と出力
   ├─ テーブル形式（デフォルト）
   └─ JSON形式（--json指定時）
7. --update時はbun updateを実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[lockfile読み込み]
    C --> D{lockfile存在?}
    D -->|No| E[エラー: lockfile必須]
    D -->|Yes| F[依存パッケージ抽出]
    F --> G{パッケージ指定あり?}
    G -->|Yes| H[指定パッケージのみフィルタ]
    G -->|No| I[全パッケージを対象]
    H --> J[レジストリ問い合わせ]
    I --> J
    J --> K[バージョン比較]
    K --> L{更新可能あり?}
    L -->|No| M[最新メッセージ]
    L -->|Yes| N{--json?}
    N -->|Yes| O[JSON出力]
    N -->|No| P[テーブル出力]
    O --> Q{--update?}
    P --> Q
    Q -->|Yes| R[bun update実行]
    Q -->|No| S[終了]
    R --> S
    M --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | lockfile必須 | lockfileが存在する必要がある | 常時 |
| BR-25-02 | Wanted計算 | package.jsonのsemver範囲内で最新を選択 | 常時 |
| BR-25-03 | Latest計算 | dist-tag "latest"のバージョンを使用 | 常時 |
| BR-25-04 | ワークスペース対応 | モノレポのワークスペースを含めて表示 | ワークスペース環境 |

### 計算ロジック

**Wantedバージョンの計算**:
```
wanted = package.jsonの指定範囲を満たす最新バージョン
例: "^1.0.0" -> 1.x.x系の最新
    "~1.0.0" -> 1.0.x系の最新
    ">=1.0.0" -> 1.0.0以上の最新
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | LockfileNotFound | lockfileが見つからない | bun installを実行 |
| - | RegistryError | レジストリへの接続失敗 | ネットワークを確認 |
| - | PackageNotFound | 指定パッケージが見つからない | パッケージ名を確認 |

### リトライ仕様

レジストリへの問い合わせは内部的にリトライが実装されている可能性がある。

## トランザクション仕様

トランザクション管理なし。読み取り専用の処理。

## パフォーマンス要件

- 依存パッケージ数とネットワーク速度に依存
- レジストリへの並列問い合わせで効率化

## セキュリティ考慮事項

- プライベートレジストリへの認証情報の安全な管理
- HTTPSによる通信暗号化

## 備考

- npm outdatedと互換性のある出力形式
- ワークスペース環境では各ワークスペースの依存関係を個別に表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | outdated_command.zig | `src/cli/outdated_command.zig` | OutdatedInfo構造体でパッケージ情報を管理 |

**読解のコツ**: 構造体のフィールドから出力される情報の種類を把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | outdated_command.zig | `src/cli/outdated_command.zig` | exec関数がエントリーポイント |

**主要処理フロー**:
1. **PackageManager.init**: パッケージマネージャーの初期化
2. **lockfile.loadFromCwd**: lockfileの読み込み
3. **依存パッケージの走査**: ワークスペースを含むパッケージを抽出
4. **レジストリ問い合わせ**: 各パッケージの最新バージョンを取得
5. **バージョン比較**: Current/Wanted/Latestの計算
6. **結果出力**: テーブルまたはJSON形式

#### Step 3: バージョン比較を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | semver.zig | `src/Semver.zig` | Semverバージョン比較ロジック |

**読解のコツ**: Query.satisfiesでバージョン範囲のマッチングを行う。

### プログラム呼び出し階層図

```
OutdatedCommand.exec
    │
    ├─ PackageManager.init
    │
    ├─ Lockfile.loadFromCwd
    │
    ├─ 依存パッケージ抽出
    │      └─ ワークスペース走査
    │
    ├─ レジストリ問い合わせ
    │      └─ Npm.Registry.getPackageMetadata
    │
    ├─ バージョン比較
    │      └─ Semver.Query.satisfies
    │
    └─ 結果出力
           ├─ テーブル形式
           └─ JSON形式
```

### データフロー図

```
[入力]               [処理]                    [出力]

lockfile ──────▶ パッケージ抽出 ───▶ パッケージリスト
                       │
package.json ──▶ バージョン範囲取得
                       │
                       ▼
npmレジストリ ◀── HTTP問い合わせ ───▶ 最新バージョン情報
                       │
                       ▼
              バージョン比較 ───▶ Current/Wanted/Latest
                       │
                       ▼
              結果整形 ─────▶ テーブル/JSON出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| outdated_command.zig | `src/cli/outdated_command.zig` | ソース | outdatedコマンドのメイン実装 |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージマネージャー初期化 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile読み込み |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリ通信 |
| Semver.zig | `src/Semver.zig` | ソース | セマンティックバージョン処理 |
