# 機能設計書 26-bun audit

## 概要

本ドキュメントは、Bunパッケージマネージャーの `bun audit` コマンドの機能設計を記述する。このコマンドは、プロジェクトの依存パッケージにセキュリティ脆弱性がないかをチェックする。

### 本機能の処理概要

`bun audit` は、インストールされているパッケージを脆弱性データベースと照合し、既知のセキュリティ問題を検出して報告する機能を提供する。

**業務上の目的・背景**：オープンソースパッケージには定期的にセキュリティ脆弱性が発見される。依存関係が深くなるほど、脆弱性の影響範囲を把握することが困難になる。この機能により、プロジェクト全体のセキュリティ状態を効率的に評価できる。

**機能の利用シーン**：
- 定期的なセキュリティ監査
- CI/CDパイプラインでのセキュリティチェック
- 新規依存パッケージ追加時の影響評価
- コンプライアンス要件への対応

**主要な処理内容**：
1. lockfileの読み込みとパッケージリストの抽出
2. 脆弱性データベースへの問い合わせ
3. パッケージとバージョンのマッチング
4. 脆弱性情報の集計と表示
5. 重要度別（critical/high/moderate/low）の分類

**関連システム・外部連携**：
- npm脆弱性データベース（registry.npmjs.org/-/security/audits）
- GitHub Advisory Database

**権限による制御**：脆弱性データベースへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | audit | 主画面 | セキュリティ脆弱性チェックの実行 |

## 機能種別

データ連携（外部API通信）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --json | boolean | No | JSON形式で出力 | - |
| --fix | boolean | No | 可能な場合は自動修正 | - |
| --production | boolean | No | 本番依存関係のみチェック | - |
| --level | string | No | 報告する最小重要度（low/moderate/high/critical） | - |

### 入力データソース

- bun.lockb / bun.lock（lockfile）
- 脆弱性データベース

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| vulnerabilities | object | 重要度別の脆弱性数 |
| advisories | array | 脆弱性の詳細情報 |
| metadata | object | スキャン結果のメタデータ |

### 出力先

- 標準出力（コンソール）- サマリーまたはJSON形式

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --json、--fix、--level等を解析
2. lockfileの読み込み
   └─ インストール済みパッケージリストを取得
3. 脆弱性データベースへの問い合わせ
   └─ パッケージ名とバージョンを送信
4. レスポンスの解析
   └─ 脆弱性情報をパース
5. 結果の集計
   ├─ 重要度別に分類
   └─ 影響を受けるパッケージを特定
6. 結果の出力
   ├─ サマリー形式（デフォルト）
   └─ JSON形式（--json指定時）
7. --fix時の自動修正
   └─ 可能な場合はバージョンを更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[lockfile読み込み]
    C --> D{lockfile存在?}
    D -->|No| E[エラー: lockfile必須]
    D -->|Yes| F[パッケージリスト抽出]
    F --> G[脆弱性DB問い合わせ]
    G --> H[レスポンス解析]
    H --> I[結果集計]
    I --> J{脆弱性あり?}
    J -->|No| K[セキュアメッセージ]
    J -->|Yes| L{--json?}
    L -->|Yes| M[JSON出力]
    L -->|No| N[サマリー出力]
    M --> O{--fix?}
    N --> O
    O -->|Yes| P[自動修正実行]
    O -->|No| Q[終了]
    P --> Q
    K --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | lockfile必須 | lockfileが存在する必要がある | 常時 |
| BR-26-02 | 重要度分類 | critical/high/moderate/lowの4段階 | 常時 |
| BR-26-03 | 本番フィルタ | --productionでdevDependenciesを除外 | オプション指定時 |
| BR-26-04 | レベルフィルタ | 指定レベル未満の脆弱性を非表示 | オプション指定時 |

### 計算ロジック

なし（脆弱性データベースからの情報を集計）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | LockfileNotFound | lockfileが見つからない | bun installを実行 |
| - | DatabaseError | 脆弱性DBへの接続失敗 | ネットワークを確認 |
| - | ParseError | レスポンス解析失敗 | 再試行 |

### リトライ仕様

脆弱性データベースへの問い合わせは内部的にリトライされる場合がある。

## トランザクション仕様

トランザクション管理なし。読み取り専用の処理。

## パフォーマンス要件

- パッケージ数とネットワーク速度に依存
- 一般的なプロジェクトで数秒から数十秒

## セキュリティ考慮事項

- 脆弱性情報は機密性が高い場合がある
- HTTPSによる通信暗号化
- 認証情報の安全な管理

## 備考

- npm audit互換の出力形式を目指す
- GitHub Advisory Databaseとの連携
- CI/CD終了コードで脆弱性の有無を示す

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | audit_command.zig | `src/cli/audit_command.zig` | 脆弱性情報の構造体定義 |

**読解のコツ**: 脆弱性の重要度enum定義に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | audit_command.zig | `src/cli/audit_command.zig` | exec関数がエントリーポイント |

**主要処理フロー**:
1. **PackageManager.init**: パッケージマネージャーの初期化
2. **lockfile.loadFromCwd**: lockfileの読み込み
3. **buildAuditRequest**: 監査リクエストの構築
4. **sendAuditRequest**: 脆弱性DBへの問い合わせ
5. **parseAuditResponse**: レスポンスの解析
6. **printAuditReport**: 結果の出力

### プログラム呼び出し階層図

```
AuditCommand.exec
    │
    ├─ PackageManager.init
    │
    ├─ Lockfile.loadFromCwd
    │
    ├─ buildAuditRequest
    │      └─ パッケージリストの構築
    │
    ├─ sendAuditRequest
    │      └─ HTTP POST to audit endpoint
    │
    ├─ parseAuditResponse
    │      └─ JSON解析
    │
    └─ printAuditReport
           ├─ サマリー形式
           └─ JSON形式
```

### データフロー図

```
[入力]               [処理]                    [出力]

lockfile ──────▶ パッケージ抽出 ───▶ パッケージリスト
                       │
                       ▼
脆弱性DB ◀───── HTTP問い合わせ ───▶ 脆弱性情報
                       │
                       ▼
              重要度分類 ───▶ critical/high/moderate/low
                       │
                       ▼
              レポート生成 ───▶ サマリー/JSON出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| audit_command.zig | `src/cli/audit_command.zig` | ソース | auditコマンドのメイン実装 |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージマネージャー初期化 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile読み込み |
| http.zig | `src/http.zig` | ソース | HTTP通信 |
