# 機能設計書 27-bun pm

## 概要

本ドキュメントは、Bunパッケージマネージャーの `bun pm` コマンドの機能設計を記述する。このコマンドは、パッケージ管理に関するユーティリティ機能を提供する。

### 本機能の処理概要

`bun pm` は、パッケージ管理に関連する複数のサブコマンドを提供する統合コマンドである。キャッシュ管理、依存関係の表示、バイナリパスの取得などの機能を提供する。

**業務上の目的・背景**：パッケージマネージャーの運用において、キャッシュのクリアやlockfileのハッシュ確認、信頼できる依存関係の管理など、日常的に必要なユーティリティ操作がある。これらを統合的に提供することで、開発者の生産性を向上させる。

**機能の利用シーン**：
- グローバルbinディレクトリのパス確認
- キャッシュディレクトリの確認・クリア
- lockfileのハッシュ確認（CI/CDでの整合性チェック）
- 依存関係ツリーの表示
- 信頼できる依存関係の管理

**主要な処理内容**（サブコマンド別）：
- `bun pm bin`: binディレクトリのパスを表示
- `bun pm ls`: 依存関係ツリーを表示
- `bun pm cache`: キャッシュディレクトリのパス表示・クリア
- `bun pm hash`: lockfileのハッシュを生成
- `bun pm hash-print`: lockfileに保存されたハッシュを表示
- `bun pm hash-string`: ハッシュ計算に使用する文字列を表示
- `bun pm migrate`: 他のパッケージマネージャーのlockfileを移行
- `bun pm trust`: 信頼できる依存関係を管理
- `bun pm untrusted`: 信頼されていない依存関係を表示
- `bun pm default-trusted`: デフォルトの信頼リストを表示
- `bun pm whoami`: 現在のnpmユーザー名を表示
- `bun pm view`: パッケージ情報を表示
- `bun pm version`: package.jsonのバージョンを更新
- `bun pm pkg`: package.jsonのデータを管理
- `bun pm scan`: セキュリティスキャンを実行
- `bun pm pack`: tarballを作成

**関連システム・外部連携**：
- npmレジストリ（whoami, view）
- ローカルファイルシステム（cache, bin, ls等）

**権限による制御**：サブコマンドにより異なる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | pm | 主画面 | パッケージ管理ユーティリティの実行 |

## 機能種別

統合コマンド（複数サブコマンドを提供）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| subcommand | string | Yes | サブコマンド名 | 有効なサブコマンド |
| -g | boolean | No | グローバルモード（bin等） | - |
| --all | boolean | No | 全件表示（ls, trust等） | - |

### 入力データソース

- bun.lockb / bun.lock（多くのサブコマンド）
- package.json（version, pkg等）
- bunfig.toml（設定）
- npmレジストリ（whoami, view）

## 出力仕様

### 出力データ

サブコマンドにより異なる。

| サブコマンド | 出力内容 |
|-------------|---------|
| bin | binディレクトリのパス |
| ls | 依存関係ツリー |
| cache | キャッシュディレクトリのパス |
| hash | lockfileのメタハッシュ |
| whoami | npmユーザー名 |

### 出力先

標準出力（コンソール）

## 処理フロー

### 処理シーケンス（共通）

```
1. コマンドライン引数の解析
   └─ サブコマンドとオプションを取得
2. サブコマンドの特定
   └─ getSubcommandでサブコマンド名を取得
3. グローバルモードの設定（必要な場合）
   └─ setupGlobalDirでグローバルディレクトリを設定
4. サブコマンド固有の処理
   └─ 各サブコマンドの実装を呼び出し
5. 結果の出力
   └─ 標準出力に表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[サブコマンド特定]
    C --> D{サブコマンド?}
    D -->|bin| E[binパス表示]
    D -->|ls| F[依存関係表示]
    D -->|cache| G[キャッシュ操作]
    D -->|hash| H[ハッシュ生成]
    D -->|whoami| I[ユーザー名取得]
    D -->|migrate| J[lockfile移行]
    D -->|trust| K[信頼管理]
    D -->|その他| L[その他処理]
    D -->|不明| M[ヘルプ表示]
    E --> N[終了]
    F --> N
    G --> N
    H --> N
    I --> N
    J --> N
    K --> N
    L --> N
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-01 | サブコマンド必須 | 有効なサブコマンドの指定が必要 | 常時 |
| BR-27-02 | lockfile依存 | 多くのサブコマンドはlockfileが必要 | ls, hash等 |
| BR-27-03 | グローバルbin | -gでグローバルbinパスを表示 | bin -g |

### 計算ロジック

サブコマンド固有。hashではlockfileのメタハッシュを計算。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | UnknownSubcommand | 不明なサブコマンド | ヘルプを参照 |
| - | LockfileNotFound | lockfileが見つからない（ls等） | bun installを実行 |
| - | AuthRequired | 認証が必要（whoami） | npm loginを実行 |

### リトライ仕様

サブコマンドにより異なる。ネットワーク操作は内部的にリトライされる場合がある。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

サブコマンドにより異なる。ローカル操作は即座に完了。

## セキュリティ考慮事項

- whoamiは認証情報を使用
- cache rmは復元不可能な削除操作

## 備考

- npm、pnpm、yarn等の類似コマンドとの互換性を意識
- `bun pm` 単体ではヘルプを表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package_manager_command.zig | `src/cli/package_manager_command.zig` | exec関数（138行目〜）がエントリーポイント |

**主要処理フロー**:
1. **139行目**: 引数を取得
2. **143-146行目**: PackageManager初期化（エラー時はpackage.json作成を促す）
3. **161-166行目**: サブコマンドの特定（getSubcommand）
4. **168-170行目**: グローバルモード設定
5. **172-456行目**: サブコマンド別の処理分岐

#### Step 2: サブコマンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | package_manager_command.zig | `src/cli/package_manager_command.zig` | 各サブコマンドの処理（172-456行目） |

**主要サブコマンド**:
- **172-174行目**: scan - ScanCommand.execWithManagerを呼び出し
- **175-177行目**: pack - PackCommand.execWithManagerを呼び出し
- **178-194行目**: whoami - Npm.whoamiを呼び出し
- **199-224行目**: bin - binパスを出力
- **225-235行目**: hash - lockfileハッシュを計算
- **251-308行目**: cache - キャッシュパス表示/削除
- **318-397行目**: ls - 依存関係ツリー表示
- **400-416行目**: migrate - lockfile移行
- **439-441行目**: why - PmWhyCommand.execを呼び出し

#### Step 3: 依存関係表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | package_manager_command.zig | `src/cli/package_manager_command.zig` | ls処理（318-397行目）とprintNodeModulesFolderStructure（460-587行目） |

### プログラム呼び出し階層図

```
PackageManagerCommand.exec
    │
    ├─ PackageManager.CommandLineArguments.parse
    │
    ├─ PackageManager.init
    │
    ├─ getSubcommand
    │
    └─ サブコマンド処理
           ├─ ScanCommand.execWithManager (scan)
           ├─ PackCommand.execWithManager (pack)
           ├─ Npm.whoami (whoami)
           ├─ PmViewCommand.view (view)
           ├─ lockfile.hasMetaHashChanged (hash)
           ├─ printNodeModulesFolderStructure (ls)
           ├─ migration.detectAndLoadOtherLockfile (migrate)
           ├─ PmVersionCommand.exec (version)
           ├─ PmWhyCommand.exec (why)
           ├─ PmPkgCommand.exec (pkg)
           ├─ TrustCommand.exec (trust)
           ├─ UntrustedCommand.exec (untrusted)
           └─ DefaultTrustedCommand.exec (default-trusted)
```

### データフロー図

```
[入力]               [処理]                    [出力]

引数 ───────▶ サブコマンド特定
                       │
                       ▼
          サブコマンド処理 ───▶ 結果
                       │
                       ▼
              結果出力 ─────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package_manager_command.zig | `src/cli/package_manager_command.zig` | ソース | pmコマンドのメイン実装 |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージマネージャー |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile操作 |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリ通信 |
| pm_why_command.zig | `src/cli/pm_why_command.zig` | ソース | whyサブコマンド |
| pm_view_command.zig | `src/cli/pm_view_command.zig` | ソース | viewサブコマンド |
| pm_version_command.zig | `src/cli/pm_version_command.zig` | ソース | versionサブコマンド |
| pm_pkg_command.zig | `src/cli/pm_pkg_command.zig` | ソース | pkgサブコマンド |
| pm_trusted_command.zig | `src/cli/pm_trusted_command.zig` | ソース | trust関連サブコマンド |
| pack_command.zig | `src/cli/pack_command.zig` | ソース | packサブコマンド |
| scan_command.zig | `src/cli/scan_command.zig` | ソース | scanサブコマンド |
