# 機能設計書 29-bun exec

## 概要

本ドキュメントは、Bunの `bun exec` コマンドの機能設計を記述する。このコマンドは、シェルスクリプトをBunのシェルインタプリタで直接実行する。

### 本機能の処理概要

`bun exec` は、コマンドライン引数で渡されたシェルスクリプト文字列をBunのクロスプラットフォームシェルインタプリタで実行する機能を提供する。

**業務上の目的・背景**：Node.jsやnpmではシェルコマンドの実行にchild_processやexecSyncを使用するが、これはプラットフォーム依存のシェル（bash, cmd.exe等）に依存する。Bunは独自のクロスプラットフォームシェルを内蔵しており、OSに依存しない一貫したシェル実行環境を提供する。

**機能の利用シーン**：
- package.jsonのscriptsでのシェルコマンド実行
- CLIツールからのシェルコマンド呼び出し
- クロスプラットフォームでの一貫したシェル動作

**主要な処理内容**：
1. コマンドライン引数からスクリプト文字列を取得
2. Bun.Transpilerで環境を初期化
3. MiniEventLoopでイベントループを初期化
4. shell.Interpreter でシェルスクリプトを解析・実行
5. 終了コードを返す

**関連システム・外部連携**：
- Bunの内蔵シェルインタプリタ
- 環境変数

**権限による制御**：実行するコマンドに応じた権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | exec | 主画面 | シェルスクリプトの実行 |

## 機能種別

スクリプト実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| script | string | Yes | 実行するシェルスクリプト | - |

### 入力データソース

- コマンドライン引数（positionals[1]）
- 環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stdout | stream | 標準出力 |
| stderr | stream | 標準エラー出力 |
| exit code | number | 終了コード |

### 出力先

- 標準出力（コンソール）
- 標準エラー出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の取得
   └─ positionals[1]からスクリプト文字列を取得
2. Transpilerの初期化
   └─ Bun.Transpiler.initで環境を設定
3. 環境変数の読み込み
   └─ runEnvLoaderで環境変数をロード
4. カレントディレクトリの取得
   └─ bun.sys.getcwdでcwdを取得
5. MiniEventLoopの初期化
   └─ MiniEventLoop.initGlobalでイベントループを準備
6. スクリプトパスの構築
   └─ [cwd]/[eval]形式でパスを構築
7. シェルインタプリタの実行
   └─ Interpreter.initAndRunFromSourceでスクリプトを実行
8. 終了コードの返却
   └─ Global.exitで終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[スクリプト取得]
    B --> C[Transpiler初期化]
    C --> D[環境変数ロード]
    D --> E[cwd取得]
    E --> F{cwd取得成功?}
    F -->|No| G[エラー出力・終了]
    F -->|Yes| H[MiniEventLoop初期化]
    H --> I[スクリプトパス構築]
    I --> J[Interpreter実行]
    J --> K{実行成功?}
    K -->|No| L[エラー出力・終了]
    K -->|Yes| M[終了コードで終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | スクリプト必須 | 実行するスクリプト文字列が必要 | 常時 |
| BR-29-02 | クロスプラットフォーム | OS依存しないシェル構文 | 常時 |
| BR-29-03 | 終了コード伝播 | シェルの終了コードをそのまま返す | 常時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CwdError | カレントディレクトリ取得失敗 | 環境を確認 |
| - | ScriptError | スクリプト実行失敗 | スクリプト構文を確認 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- 起動時間: 数ミリ秒
- 実行時間: スクリプト内容に依存

## セキュリティ考慮事項

- 任意のシェルコマンドが実行されるため、入力のサニタイズが重要
- 環境変数に機密情報が含まれる可能性

## 備考

- Bunの内蔵シェルはbash互換のサブセット
- パイプ、リダイレクト、変数展開などをサポート
- Windows/macOS/Linuxで一貫した動作

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | exec_command.zig | `src/cli/exec_command.zig` | ExecCommand.exec関数（2行目）がエントリーポイント |

**主要処理フロー**:
1. **3行目**: positionals[1]からスクリプトを取得
2. **5-10行目**: Bun.Transpiler.initで環境を初期化
3. **11行目**: runEnvLoaderで環境変数をロード
4. **12-19行目**: cwdの取得
5. **20行目**: MiniEventLoop.initGlobalでイベントループ初期化
6. **21-25行目**: スクリプトパスの構築
7. **27-30行目**: Interpreter.initAndRunFromSourceでシェル実行
8. **38行目**: Global.exitで終了

#### Step 2: シェルインタプリタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | shell/interpreter.zig | `src/shell/interpreter.zig` | initAndRunFromSource関数でシェルスクリプトを解析・実行 |

**読解のコツ**: シェルの文法解析とコマンド実行の分離に注目。

#### Step 3: Transpilerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Transpiler.zig | `src/Transpiler.zig` | init関数で環境設定を行う |

### プログラム呼び出し階層図

```
ExecCommand.exec
    │
    ├─ Bun.Transpiler.init
    │
    ├─ bundle.runEnvLoader
    │
    ├─ bun.sys.getcwd
    │
    ├─ MiniEventLoop.initGlobal
    │
    ├─ bun.path.join
    │
    └─ shell.Interpreter.initAndRunFromSource
           │
           └─ (シェルスクリプト実行)
```

### データフロー図

```
[入力]               [処理]                    [出力]

スクリプト文字列 ───▶ 引数取得
                       │
                       ▼
環境変数 ──────▶ 環境初期化 ───▶ Transpiler
                       │
                       ▼
              cwd取得 ─────▶ スクリプトパス
                       │
                       ▼
              Interpreter実行 ───▶ stdout/stderr
                       │
                       ▼
              終了コード ───▶ プロセス終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| exec_command.zig | `src/cli/exec_command.zig` | ソース | execコマンドのメイン実装 |
| Transpiler.zig | `src/Transpiler.zig` | ソース | 環境初期化 |
| interpreter.zig | `src/shell/interpreter.zig` | ソース | シェルインタプリタ |
| MiniEventLoop.zig | `src/bun.js/event_loop.zig` | ソース | イベントループ |
