# 機能設計書 3-トランスパイラ

## 概要

本ドキュメントは、BunランタイムにおけるTypeScript、JSX、TSXをネイティブでトランスパイルする機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、TypeScript、JSX、TSXコードをJavaScriptに変換するトランスパイラ処理を担当する。Zigで実装された高速なパーサーとプリンターにより、外部ツール（tsc、Babel等）を必要とせずにリアルタイムでトランスパイルを実行する。

**業務上の目的・背景**：TypeScriptやJSXは現代のJavaScript開発において標準的に使用されるが、従来はビルドステップが必要だった。Bunは実行時にネイティブでトランスパイルを行うことで、開発ワークフローを大幅に簡素化し、起動時間を短縮する。

**機能の利用シーン**：TypeScript/TSXファイルの実行、JSXファイルの実行、バンドル時のコード変換、REPLでのTypeScript評価など。

**主要な処理内容**：
1. ソースコードの字句解析（Lexer）
2. 構文解析とAST生成（Parser）
3. TypeScript型注釈の削除
4. JSX/TSXのJavaScript変換
5. ソースマップの生成（オプション）
6. 変換済みJavaScriptコードの出力

**関連システム・外部連携**：JavaScriptランタイム、モジュールローダー、バンドラー

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | run | 主画面 | TypeScript、JSX、TSXの実行時トランスパイル |

## 機能種別

計算処理 / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source_code | string | Yes | トランスパイル対象のソースコード | 空でないこと |
| loader | Loader | Yes | ファイルタイプ（ts, tsx, js, jsx等） | 有効なLoader値 |
| jsx_runtime | string | No | JSXランタイム（automatic/classic） | - |
| target | string | No | 出力ターゲット（browser/node/bun） | - |

### 入力データソース

- ソースファイル
- インラインコード（-e オプション）
- REPL入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output_code | string | トランスパイル済みJavaScriptコード |
| source_map | string | ソースマップ（オプション） |
| ast | Ast | 抽象構文木 |

### 出力先

- JavaScriptCoreエンジン（実行時）
- ファイルシステム（バンドル時）
- 標準出力（--printオプション時）

## 処理フロー

### 処理シーケンス

```
1. ソース取得
   └─ ファイルまたは文字列からソースコードを取得
2. 字句解析
   └─ Lexerでトークン列に分解
3. 構文解析
   └─ Parserでトークンを解析しASTを生成
4. 型情報削除
   └─ TypeScript型注釈、interface、type宣言を削除
5. JSX変換
   └─ JSX要素をcreateElement呼び出しに変換
6. コード生成
   └─ ASTからJavaScriptコードを生成
7. ソースマップ生成
   └─ オプションでソースマップを生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ソースコード取得]
    B --> C[字句解析 Lexer]
    C --> D[構文解析 Parser]
    D --> E{TypeScript?}
    E -->|Yes| F[型情報削除]
    E -->|No| G{JSX/TSX?}
    F --> G
    G -->|Yes| H[JSX変換]
    G -->|No| I[コード生成]
    H --> I
    I --> J{ソースマップ必要?}
    J -->|Yes| K[ソースマップ生成]
    J -->|No| L[出力]
    K --> L
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 型削除のみ | tscと異なり型チェックは行わず、型情報のみ削除 | TypeScript処理時 |
| BR-02 | JSX自動ランタイム | React 17+のautomatic JSXランタイムをデフォルトでサポート | JSX処理時 |
| BR-03 | 拡張子によるローダー判定 | .ts/.tsx/.js/.jsx/.mts/.cts/.mjs/.cjs等で自動判定 | ファイル読み込み時 |
| BR-04 | バイトコードキャッシュ | 同一ファイルの再トランスパイルをキャッシュで高速化 | 2回目以降の実行時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SyntaxError | 構文エラー | JavaScript/TypeScriptの構文が不正 | コードを修正 |
| UnexpectedToken | トークンエラー | 予期しないトークンを検出 | コードを修正 |
| JSXSyntaxError | JSXエラー | JSXの構文が不正 | JSXを修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- トランスパイル速度: 1000行あたり10ms以内
- メモリ使用: ソースコードサイズの5倍以内
- バイトコードキャッシュヒット時: 1ms以内

## セキュリティ考慮事項

- 悪意のあるコードのトランスパイル自体は防止しない（実行時の問題）
- ソースマップには元のソースコードが含まれる可能性

## 備考

BunのトランスパイラはZigで実装されており、esbuildと同等以上の速度を実現している。TypeScriptの型チェックは行わないため、型チェックが必要な場合はtscやTypeScript Language Serverを併用する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | transpiler.zig | `src/transpiler.zig` | ParseResult構造体で変換結果のデータ構造を理解 |
| 1-2 | js_ast.zig | `src/js_ast.zig` | Ast構造体でAST全体の構造を把握 |

**読解のコツ**: ParseResult.AlreadyBundled enumでバイトコードキャッシュの状態管理を確認。bytecode/bytecode_cjsでCommonJSとESMの区別がある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | transpiler.zig | `src/transpiler.zig` | PluginRunner構造体でプラグインシステムとの連携を理解 |

**主要処理フロー**:
1. **7-56行目**: ParseResult構造体でパース結果を保持
2. **58-185行目**: PluginRunnerでプラグインのonResolve処理

#### Step 3: パーサーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | js_parser.zig | `src/js_parser.zig` | メインパーサーの実装 |

**主要処理フロー**:
- **1-5行目**: 重要なコメント - パーサー変更時はRuntimeTranspilerCacheのバージョンを更新
- **6-22行目**: SkipTypeParameterResultでTypeScriptの型パラメータ処理
- **37-99行目**: JSXImport enumでJSX関連シンボルを管理

**読解のコツ**:
- js_parser.zigの104-116行目のコメントで省略記法を理解
- "P"はパーサー内部、"p.e"は式割り当て、"p.b"はバインディング割り当て、"p.s"は文割り当て

#### Step 4: プリンターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | js_printer.zig | `src/js_printer.zig` | ASTからJavaScriptコードを生成 |

### プログラム呼び出し階層図

```
ソースコード
    │
    ├─ transpiler.zig
    │      ├─ ParseResult構造体
    │      └─ PluginRunner（プラグイン処理）
    │
    ├─ js_lexer.zig
    │      └─ トークン生成
    │
    ├─ js_parser.zig
    │      ├─ 構文解析
    │      ├─ TypeScript型削除
    │      └─ JSX変換
    │
    └─ js_printer.zig
           └─ コード生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

TypeScript/JSX ───▶ js_lexer.zig ───▶ トークン列
                         │
                         ▼
                    js_parser.zig ───▶ AST
                         │
                         ▼
                    js_printer.zig ───▶ JavaScript
                         │
                         ▼
                    ParseResult ───▶ 実行/バンドル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| transpiler.zig | `src/transpiler.zig` | ソース | トランスパイラのメイン処理 |
| js_parser.zig | `src/js_parser.zig` | ソース | JavaScript/TypeScript/JSXパーサー |
| js_lexer.zig | `src/js_lexer.zig` | ソース | 字句解析器 |
| js_printer.zig | `src/js_printer.zig` | ソース | コード生成器 |
| js_ast.zig | `src/js_ast.zig` | ソース | AST定義 |
| options.zig | `src/options.zig` | ソース | トランスパイルオプション定義 |
| RuntimeTranspilerCache.zig | `src/bun.js/RuntimeTranspilerCache.zig` | ソース | バイトコードキャッシュ |
