# 機能設計書 30-JavaScriptバンドル

## 概要

本ドキュメントは、Bunの `bun build` コマンドによるJavaScript/TypeScriptバンドル機能の設計を記述する。この機能は、複数のソースファイルを単一または複数の最適化されたバンドルファイルに変換する。

### 本機能の処理概要

Bunのバンドラーは、JavaScript/TypeScriptファイルを解析し、依存関係を解決し、最適化を行って出力ファイルを生成する高速なビルドツールである。esbuildに影響を受けた設計で、Tree-shaking、コード分割、ミニファイなどの機能を提供する。

**業務上の目的・背景**：モダンなWebアプリケーション開発では、多数のJavaScript/TypeScriptファイルを単一または少数のファイルにまとめることで、HTTPリクエスト数を削減し、パフォーマンスを向上させる。Bunは高速なネイティブ実装により、従来のバンドラーよりも大幅に高速なビルドを実現する。

**機能の利用シーン**：
- Webアプリケーションの本番ビルド
- ライブラリのビルド（CommonJS/ESM出力）
- Node.js互換の単一実行ファイル生成
- 開発時のホットリロード

**主要な処理内容**：
1. エントリーポイントの解析
2. 依存関係グラフの構築
3. Tree-shakingによる不要コード除去
4. コード分割（code splitting）
5. ミニファイ（圧縮）
6. ソースマップ生成
7. 出力ファイルの生成

**関連システム・外部連携**：
- ファイルシステム
- Node.js互換モジュール解決

**権限による制御**：出力ディレクトリへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | build | 主画面 | JavaScriptバンドルの実行 |

## 機能種別

ビルドツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| entrypoints | string[] | Yes | エントリーポイントファイル | ファイル存在確認 |
| --outdir | string | No | 出力ディレクトリ | - |
| --outfile | string | No | 出力ファイル名（単一出力時） | - |
| --target | string | No | ターゲット環境（browser/bun/node） | 有効な値 |
| --format | string | No | 出力形式（esm/cjs/iife） | 有効な値 |
| --minify | boolean | No | ミニファイを有効化 | - |
| --sourcemap | string | No | ソースマップ（none/inline/external/linked） | 有効な値 |
| --splitting | boolean | No | コード分割を有効化 | - |
| --external | string[] | No | 外部パッケージとして扱う | - |
| --define | object | No | コンパイル時定数定義 | - |
| --loader | object | No | ファイル種別ごとのローダー設定 | - |

### 入力データソース

- エントリーポイントファイル
- node_modules（依存パッケージ）
- bunfig.toml（設定）
- tsconfig.json / jsconfig.json

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| バンドルファイル | file | 最適化されたJavaScript |
| ソースマップ | file | デバッグ用マッピング |
| メタファイル | file | ビルド情報（--metafile時） |

### 出力先

- 指定された出力ディレクトリ
- 標準出力（--no-bundle時）

## 処理フロー

### 処理シーケンス

```
1. 設定の読み込み
   ├─ コマンドライン引数
   ├─ bunfig.toml
   └─ tsconfig.json
2. エントリーポイントの解析
   └─ ファイル読み込みとパース
3. 依存関係解決
   ├─ import/require文の解析
   ├─ モジュール解決（node_modules等）
   └─ 循環依存の検出
4. 依存グラフの構築
   └─ 到達可能なファイルの特定
5. Tree-shaking
   └─ 使用されないエクスポートの除去
6. コード変換
   ├─ TypeScript → JavaScript
   ├─ JSX → JavaScript
   └─ 最新構文 → ターゲット構文
7. コード分割（--splitting時）
   └─ 共通コードのチャンク化
8. ミニファイ（--minify時）
   ├─ 空白除去
   ├─ 変数名短縮
   └─ デッドコード除去
9. 出力生成
   ├─ バンドルファイル
   ├─ ソースマップ
   └─ メタファイル
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[設定読み込み]
    B --> C[エントリーポイント解析]
    C --> D[依存関係解決]
    D --> E[依存グラフ構築]
    E --> F[Tree-shaking]
    F --> G[コード変換]
    G --> H{--splitting?}
    H -->|Yes| I[コード分割]
    H -->|No| J{--minify?}
    I --> J
    J -->|Yes| K[ミニファイ]
    J -->|No| L[出力生成]
    K --> L
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | エントリーポイント必須 | 少なくとも1つのエントリーポイントが必要 | 常時 |
| BR-30-02 | ターゲット互換 | ターゲットに応じた構文変換 | 常時 |
| BR-30-03 | 外部パッケージ | --externalはバンドルに含めない | オプション指定時 |
| BR-30-04 | ソースマップ | 本番環境では通常external | --sourcemap時 |

### 計算ロジック

**Tree-shaking**: 使用されないエクスポートをDCE（Dead Code Elimination）で除去。ESMのstatic importを前提。

**コード分割**: 複数エントリーポイント間で共通使用されるモジュールを別チャンクに分離。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | EntryNotFound | エントリーポイントが見つからない | ファイルパスを確認 |
| - | ParseError | 構文エラー | ソースコードを修正 |
| - | ResolveError | モジュール解決失敗 | パッケージをインストール |
| - | CircularDependency | 循環依存検出 | 依存関係を整理 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

トランザクション管理なし。出力は一時ファイルに書き込み後にリネーム。

## パフォーマンス要件

- 並列処理によるマルチコア活用
- インクリメンタルビルド対応
- メモリ効率の高いストリーミング処理

## セキュリティ考慮事項

- ソースマップに機密情報が含まれる可能性
- --defineでの環境変数注入時の注意

## 備考

- esbuild互換のAPI設計
- Bun.build() JavaScriptAPIも提供
- --watchモードでファイル監視対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bundle_v2.zig | `src/bundler/bundle_v2.zig` | BundleV2構造体（107行目〜）がバンドラーの中核 |

**読解のコツ**: BundleV2のフィールドからバンドラーの状態管理を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build_command.zig | `src/cli/build_command.zig` | CLIエントリーポイント |
| 2-2 | Transpiler.zig | `src/Transpiler.zig` | トランスパイラの初期化 |

**主要処理フロー**:
1. オプション解析
2. Transpiler初期化
3. BundleV2作成
4. waitForParseで依存関係解析完了待ち
5. findReachableFilesで到達可能ファイル特定
6. リンク処理
7. 出力生成

#### Step 3: 依存関係解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | resolver | `src/resolver/` | モジュール解決ロジック |

**読解のコツ**: Node.js互換のモジュール解決アルゴリズムに注目。

#### Step 4: 出力生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | linker.zig | `src/bundler/linker.zig` | リンク処理とチャンク生成 |

### プログラム呼び出し階層図

```
BuildCommand.exec
    │
    ├─ Transpiler.init
    │
    ├─ BundleV2.init
    │      ├─ graph初期化
    │      └─ linker初期化
    │
    ├─ waitForParse
    │      └─ 各ファイルのパース（並列）
    │
    ├─ findReachableFiles
    │      └─ 依存グラフ走査
    │
    ├─ link
    │      ├─ Tree-shaking
    │      ├─ コード分割
    │      └─ チャンク生成
    │
    └─ 出力生成
           ├─ バンドルファイル
           └─ ソースマップ
```

### データフロー図

```
[入力]               [処理]                    [出力]

エントリーポイント ───▶ パース ───▶ AST
     │                  │
     ▼                  ▼
import解析 ──────▶ 依存関係解決 ───▶ 依存グラフ
                       │
                       ▼
              Tree-shaking ───▶ 最適化AST
                       │
                       ▼
              コード生成 ───▶ JavaScript
                       │
                       ▼
              ミニファイ ───▶ 圧縮JavaScript
                       │
                       ▼
              ファイル出力 ───▶ バンドルファイル
                                 ソースマップ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bundle_v2.zig | `src/bundler/bundle_v2.zig` | ソース | バンドラーのメイン実装 |
| build_command.zig | `src/cli/build_command.zig` | ソース | CLIエントリーポイント |
| Transpiler.zig | `src/Transpiler.zig` | ソース | トランスパイラ |
| js_parser.zig | `src/js_parser.zig` | ソース | JavaScriptパーサー |
| js_printer.zig | `src/js_printer.zig` | ソース | JavaScript出力 |
| linker.zig | `src/bundler/linker.zig` | ソース | リンク処理 |
| resolver/ | `src/resolver/` | ディレクトリ | モジュール解決 |
| css/ | `src/css/` | ディレクトリ | CSSバンドル |
