# 機能設計書 33-CSSバンドル

## 概要

本ドキュメントは、BunバンドラーにおけるCSSバンドル機能の設計仕様を記載する。CSSバンドルは、複数のCSSファイルを解析・最適化し、単一または複数のCSSファイルにバンドルする機能である。

### 本機能の処理概要

CSSバンドルは、CSSファイルのパース、@importの解決、CSS Modulesのサポート、ベンダープレフィックスの自動追加、ミニファイなどを行い、最適化されたCSSを出力する機能である。

**業務上の目的・背景**：モダンなWebアプリケーションでは、コンポーネントベースの開発が主流となり、CSSも分割して管理されることが多い。しかし、本番環境では、HTTPリクエスト数の削減やキャッシュ効率の向上のために、CSSファイルを適切にバンドルすることが重要である。また、CSS Modulesによるスコープ付きスタイル、ベンダープレフィックスの自動追加により、開発効率と互換性を両立させる。

**機能の利用シーン**：本番環境向けビルド時、コンポーネントベースのCSS管理時、レガシーブラウザ対応が必要な場合に利用される。JavaScriptのバンドルと連携して、エントリーポイントに対応するCSSを自動的にバンドルする。

**主要な処理内容**：
1. CSSファイルのパース（css_parser.zig）
2. @import文の解決とファイル結合
3. CSS Modulesのスコープ処理
4. ベンダープレフィックスの自動追加（ターゲットブラウザに応じて）
5. CSSの最適化・ミニファイ
6. ソースマップ生成（オプション）

**関連システム・外部連携**：JavaScriptバンドラーと連携し、JSからインポートされたCSSを自動検出してバンドルする。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | build | 主画面 | バンドル処理実行時のCSSバンドル適用 |

## 機能種別

バンドル処理 / 最適化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| css_chunking | bool | No | CSSチャンキングの有効/無効 | デフォルト: false |
| minify_whitespace | bool | No | 空白のミニファイ | デフォルト: false |
| minify_syntax | bool | No | 構文の最適化 | デフォルト: false |
| target | Target | No | 出力ターゲット（ブラウザバージョン） | デフォルト: モダンブラウザ |

### 入力データソース

- CSSファイル（.css）
- JavaScript/TypeScriptからのCSSインポート
- bunfig.toml設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CSSバンドル | ファイル | 結合・最適化されたCSSファイル |
| CSSソースマップ | ファイル | デバッグ用ソースマップ（オプション） |
| CSS Modulesマッピング | JSON | クラス名マッピング情報（CSS Modules使用時） |

### 出力先

ファイルシステム（指定された出力ディレクトリ）

## 処理フロー

### 処理シーケンス

```
1. CSSファイル検出
   └─ JSからのインポートまたはエントリーポイントとして検出
2. CSSパース
   └─ css_parser.zigでCSSをASTに変換
3. @importの解決
   └─ インポート順序を計算し、ファイルを結合
4. CSS Modules処理
   └─ ローカルスコープのクラス名をハッシュ化
5. ベンダープレフィックス追加
   └─ ターゲットブラウザに応じてプレフィックスを追加
6. 最適化・ミニファイ
   └─ 不要なコードの削除、圧縮
7. 出力生成
   └─ CSSファイルとソースマップを出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始: CSSファイル入力] --> B[CSSパース]
    B --> C[@import解決]
    C --> D{CSS Modules?}
    D -->|Yes| E[クラス名スコープ化]
    D -->|No| F[ベンダープレフィックス追加]
    E --> F
    F --> G{ミニファイ有効?}
    G -->|Yes| H[最適化・圧縮]
    G -->|No| I[出力生成]
    H --> I
    I --> J[終了: CSSバンドル出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-001 | インポート順序 | CSSのインポート順序は、@import文の出現順と依存関係に基づいて決定 | @import使用時 |
| BR-33-002 | CSS Modules | .module.cssまたは設定で指定されたファイルはCSS Modulesとして処理 | 該当ファイル |
| BR-33-003 | ベンダープレフィックス | ターゲットブラウザに必要なプレフィックスのみ追加 | target設定時 |
| BR-33-004 | composes検証 | composes: ... fromで参照するクラスが存在することを検証 | CSS Modules使用時 |

### 計算ロジック

**CSSインポート順序計算**: findImportedFilesInCSSOrder()でCSSファイルのインポート順序を深さ優先で計算。同一ファイルが複数回インポートされる場合は、最初の出現位置で解決。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | エラー | CSSパースエラー | エラー位置と内容を出力 |
| - | エラー | @importファイル未検出 | インポートパスを確認 |
| - | エラー | composes参照クラス未定義 | 参照先ファイルとクラス名を確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし（ファイル処理のみ）

## パフォーマンス要件

- CSSパースは並列処理対応
- 大規模なCSSファイル（数千行）でも効率的に処理

## セキュリティ考慮事項

- url()内のパスは適切にエスケープ
- 外部URLへのインポートは設定で制御可能

## 備考

- CSS Modulesの`composes`ディレクティブをサポート
- `@tailwind`などのカスタムルールは専用処理あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CSSバンドルで使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | css_parser.zig | `src/css/css_parser.zig` | CSSパーサーのメイン構造、各種CSSルール型の定義 |
| 1-2 | rules.zig | `src/css/rules/rules.zig` | CSSルール（@import, @media等）の構造定義 |

**読解のコツ**: css_parser.zigは多数のモジュールをre-exportしている。VendorPrefix、CssRule、CssRuleListなどの基本型を把握する。

#### Step 2: CSSインポート解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | findImportedFilesInCSSOrder.zig | `src/bundler/linker_context/findImportedFilesInCSSOrder.zig` | CSSファイルのインポート順序計算 |
| 2-2 | findImportedCSSFilesInJSOrder.zig | `src/bundler/linker_context/findImportedCSSFilesInJSOrder.zig` | JSからインポートされたCSSの検出 |

**主要処理フロー**:
- JSファイルからCSSインポートを検出
- CSSの@import順序を解決してファイルリストを構築

#### Step 3: CSS Modules処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | css_modules.zig | `src/css/css_modules.zig` | CSS Modulesの処理、クラス名ハッシュ化 |

**主要処理フロー**:
- ローカルスコープのクラス名を検出
- ハッシュを付加してユニークなクラス名を生成
- composesディレクティブの処理

#### Step 4: CSSチャンク生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | generateCompileResultForCssChunk.zig | `src/bundler/linker_context/generateCompileResultForCssChunk.zig` | CSSチャンクのコード生成 |
| 4-2 | postProcessCSSChunk.zig | `src/bundler/linker_context/postProcessCSSChunk.zig` | CSSチャンクの後処理 |

**主要処理フロー**:
- CSSファイルを結合
- ベンダープレフィックス追加
- ミニファイ処理

### プログラム呼び出し階層図

```
BundleV2.bundle()
    │
    ├─ ParseTask (CSS)
    │      └─ css_parser.parse()
    │             └─ CSSファイルをASTに変換
    │
    └─ LinkerContext
           ├─ scanImportsAndExports()
           │      └─ scanCSSImports()
           │             └─ CSSインポートの解析
           │
           ├─ findImportedCSSFilesInJSOrder()
           │      └─ JSからのCSSインポート検出
           │
           ├─ findImportedFilesInCSSOrder()
           │      └─ CSSインポート順序計算
           │
           ├─ prepareCssAstsForChunk()
           │      └─ チャンク用CSSの準備
           │
           └─ generateCompileResultForCssChunk()
                  └─ CSSコード生成
```

### データフロー図

```
[入力]                        [処理]                              [出力]

CSSファイル ───────▶ css_parser.parse() ───▶ CSS AST
       │
       ▼
CSS AST ──────────▶ scanCSSImports() ───▶ インポート関係
       │
       ▼
インポート関係 ────▶ findImportedFilesInCSSOrder() ───▶ 順序付きリスト
       │
       ▼
CSS AST群 ─────────▶ prepareCssAstsForChunk() ───▶ チャンクAST
       │
       ▼
チャンクAST ───────▶ generateCompileResultForCssChunk() ───▶ CSSバンドル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| css_parser.zig | `src/css/css_parser.zig` | ソース | CSSパーサーのエントリーポイント |
| css_modules.zig | `src/css/css_modules.zig` | ソース | CSS Modules処理 |
| rules.zig | `src/css/rules/rules.zig` | ソース | CSSルール定義 |
| printer.zig | `src/css/printer.zig` | ソース | CSS出力生成 |
| prefixes.zig | `src/css/prefixes.zig` | ソース | ベンダープレフィックス処理 |
| findImportedFilesInCSSOrder.zig | `src/bundler/linker_context/findImportedFilesInCSSOrder.zig` | ソース | CSSインポート順序計算 |
| generateCompileResultForCssChunk.zig | `src/bundler/linker_context/generateCompileResultForCssChunk.zig` | ソース | CSSチャンク生成 |
| computeChunks.zig | `src/bundler/linker_context/computeChunks.zig` | ソース | CSSチャンク計算 |
