# 機能設計書 35-単一実行ファイル

## 概要

本ドキュメントは、Bunバンドラーにおける単一実行ファイル（Single Executable）機能の設計仕様を記載する。単一実行ファイル機能は、JavaScriptアプリケーションを自己完結型の実行ファイルにコンパイルし、Bunランタイムなしで実行可能なバイナリを生成する機能である。

### 本機能の処理概要

単一実行ファイル機能は、`bun build --compile`オプションにより、JavaScriptまたはTypeScriptアプリケーションをネイティブ実行ファイルにコンパイルする。生成されたバイナリにはBunランタイムとアプリケーションコードが埋め込まれ、配布先の環境にBunがインストールされていなくても実行可能となる。

**業務上の目的・背景**：従来、JavaScriptアプリケーションを配布するには、Node.jsやBunなどのランタイムを別途インストールする必要があった。単一実行ファイル機能により、ランタイムの依存関係を排除し、配布とデプロイを大幅に簡素化できる。CLIツール、バックエンドサービス、開発ツールなどの配布に特に有効である。

**機能の利用シーン**：CLIツールの配布、サーバーレス環境へのデプロイ、コンテナイメージのサイズ削減、エンドユーザーへの直接配布時に利用される。`bun build --compile`コマンドで実行する。

**主要な処理内容**：
1. JavaScriptアプリケーションのバンドル
2. 依存関係の解決とインライン化
3. Bunランタイムのベースイメージ取得
4. アプリケーションコードの埋め込み
5. クロスコンパイル対応（異なるOS/アーキテクチャ向け）
6. 最終実行ファイルの生成

**関連システム・外部連携**：バンドラー全機能と連携。クロスコンパイル時はリモートからベースイメージをダウンロード。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | build | 主画面 | --compileオプションによる実行ファイル生成 |

## 機能種別

コンパイル処理 / バンドル処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| compile | bool | Yes | コンパイルモードの有効化 | --compileフラグ |
| outfile | string | No | 出力ファイル名 | デフォルト: エントリーポイント名 |
| target | string | No | ターゲットプラットフォーム | bun-linux-x64, bun-darwin-arm64 等 |
| bytecode | bool | No | バイトコードキャッシュを埋め込む | デフォルト: false |

### 入力データソース

- JavaScript/TypeScriptソースファイル
- 依存パッケージ（node_modules）
- アセットファイル（画像、JSON等）
- CLI/APIオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行ファイル | バイナリ | 自己完結型の実行可能ファイル |

### 出力先

ファイルシステム（カレントディレクトリまたは指定パス）

## 処理フロー

### 処理シーケンス

```
1. バンドル処理
   └─ 通常のバンドル処理を実行（ツリーシェイキング含む）
2. アセット収集
   └─ import.meta.dir等で参照されるアセットを収集
3. ベースイメージ取得
   └─ ターゲットプラットフォーム用のBunランタイムを取得
4. モジュールグラフ構築
   └─ StandaloneModuleGraphでファイル構造を構築
5. 埋め込み処理
   └─ バンドルとアセットをバイナリに埋め込み
6. 実行ファイル生成
   └─ 最終的な実行ファイルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始: ソースファイル入力] --> B[バンドル処理]
    B --> C[アセット収集]
    C --> D{クロスコンパイル?}
    D -->|Yes| E[リモートからベースイメージ取得]
    D -->|No| F[ローカルのBunを使用]
    E --> G[モジュールグラフ構築]
    F --> G
    G --> H[バンドル埋め込み]
    H --> I[実行ファイル生成]
    I --> J[終了: 実行ファイル出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-001 | outdir禁止 | --compileと--outdirは併用不可 | compile=true時 |
| BR-35-002 | 禁止ファイル名 | 出力ファイル名に"bun"や"bunx"は使用不可 | compile=true時 |
| BR-35-003 | ファイル名自動決定 | outfile未指定時はエントリーポイント名を使用 | outfile未指定時 |
| BR-35-004 | クロスコンパイル | --targetで異なるOS/アーキテクチャ向けにコンパイル可能 | target指定時 |

### 計算ロジック

**公開パス計算**: compile時は、アセットのpublic_pathがStandaloneModuleGraph.targetBasePublicPath()で計算される。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | エラー | --compileと--outdir併用 | --outdirを削除 |
| - | エラー | 出力ファイル名がbunまたはbunx | 別の名前を指定 |
| - | エラー | --compileと--no-bundle併用 | --no-bundleを削除 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし（ファイル処理のみ）

## パフォーマンス要件

- 生成された実行ファイルは即座に起動可能
- バイトコードキャッシュオプションで起動時間をさらに短縮

## セキュリティ考慮事項

- 埋め込まれたコードはランタイム内で実行される
- 機密情報が含まれる場合は適切な保護が必要
- argv[0]が"bun"や"bunx"の場合、スタンドアロンチェックをスキップ

## 備考

- HTMLインポートと組み合わせると、Webサーバーアプリを単一ファイルで配布可能
- --bytecodeオプションでJavaScriptCoreバイトコードを事前生成し起動を高速化

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、単一実行ファイル生成で使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StandaloneModuleGraph | `src/standalone/StandaloneModuleGraph.zig` | モジュールグラフ構造、埋め込みデータ形式 |

**読解のコツ**: StandaloneModuleGraphは埋め込まれるファイル群とその構造を定義している。targetBasePublicPath()で公開パスの計算方法を確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build_command.zig | `src/cli/build_command.zig` | --compileオプションの処理 |

**主要処理フロー**:
- **22行目**: ctx.bundler_options.compileチェック
- **54行目**: compile時のオプション設定
- **100-140行目**: compileモードのバリデーション
- **107-110行目**: base_public_path計算

#### Step 3: バンドル埋め込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bundle_v2.zig | `src/bundler/bundle_v2.zig` | compileモードでのバンドル処理 |

**主要処理フロー**:
- compile有効時の特別な公開パス設定
- アセット命名パターンの調整

### プログラム呼び出し階層図

```
bun build --compile
    │
    ├─ BuildCommand.exec()
    │      ├─ compileオプション検証
    │      ├─ 禁止ファイル名チェック
    │      └─ base_public_path設定
    │
    ├─ Transpiler / BundleV2
    │      ├─ 通常のバンドル処理
    │      └─ アセット収集
    │
    └─ StandaloneModuleGraph
           ├─ モジュールグラフ構築
           ├─ ベースイメージ取得
           └─ 実行ファイル生成
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ソースファイル ───▶ バンドル処理 ───▶ バンドルコード
       │
       ▼
アセットファイル ──▶ アセット収集 ───▶ 埋め込みアセット
       │
       ▼
Bunランタイム ────▶ ベースイメージ取得 ───▶ ランタイムバイナリ
       │
       ▼
全データ ─────────▶ StandaloneModuleGraph ───▶ 単一実行ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build_command.zig | `src/cli/build_command.zig` | ソース | CLIからの--compile処理 |
| StandaloneModuleGraph.zig | `src/standalone/StandaloneModuleGraph.zig` | ソース | モジュールグラフ構築、埋め込み処理 |
| bundle_v2.zig | `src/bundler/bundle_v2.zig` | ソース | バンドル処理 |
| LinkerContext.zig | `src/bundler/LinkerContext.zig` | ソース | リンカー処理 |
