# 機能設計書 37-マクロ

## 概要

本ドキュメントは、Bunバンドラーにおけるマクロ（Macro）機能の設計仕様を記載する。マクロは、ビルド時にコードを実行してその結果をバンドルに埋め込むコンパイル時評価機能である。

### 本機能の処理概要

マクロ機能は、ビルド時にJavaScript関数を実行し、その戻り値をバンドルされたコードに直接埋め込む。これにより、実行時のコストをビルド時に移動させ、パフォーマンスを向上させることができる。

**業務上の目的・背景**：多くのアプリケーションでは、環境変数の読み込み、設定ファイルのパース、定数の計算など、実行時に毎回同じ結果を返す処理が存在する。マクロ機能により、これらの処理をビルド時に一度だけ実行し、結果をコードに埋め込むことで、実行時のオーバーヘッドを削減できる。また、条件付きコード除去やデッドコード削除の機会も増える。

**機能の利用シーン**：環境固有の設定値の埋め込み、ビルド時のデータ変換、条件付きコードの静的展開、パフォーマンス最適化時に利用される。特殊なインポート記法（`import { foo } from 'bar' with { type: 'macro' }`）でマクロを有効化する。

**主要な処理内容**：
1. マクロインポートの検出（with { type: 'macro' }）
2. マクロ関数の読み込みと実行
3. 戻り値のシリアライズ
4. シリアライズされた値のAST注入
5. 元のマクロ呼び出しの置換

**関連システム・外部連携**：JavaScriptCoreランタイムを使用してマクロを実行。

**権限による制御**：特になし。ビルド時にNode.js/Bunとして実行されるため、システムアクセスが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | build | 主画面 | バンドル処理時のマクロ評価 |

## 機能種別

コンパイル時評価 / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| with { type: 'macro' } | Import Attribute | Yes | マクロインポートの識別子 | インポート文の属性として指定 |

### 入力データソース

- JavaScriptマクロファイル
- インポート属性
- マクロ関数の戻り値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 評価済みコード | AST | マクロの戻り値がリテラルとして埋め込まれたコード |

### 出力先

バンドル出力ファイル

## 処理フロー

### 処理シーケンス

```
1. インポート解析
   └─ with { type: 'macro' } 属性を持つインポートを検出
2. マクロファイル読み込み
   └─ マクロとして指定されたモジュールを読み込み
3. マクロ呼び出し検出
   └─ マクロ関数の呼び出し箇所を特定
4. マクロ実行
   └─ JSCでマクロ関数を実行し戻り値を取得
5. 値のシリアライズ
   └─ 戻り値をJavaScriptリテラルに変換
6. AST置換
   └─ マクロ呼び出しをシリアライズされた値で置換
```

### フローチャート

```mermaid
flowchart TD
    A[開始: ソースファイル] --> B[インポート解析]
    B --> C{マクロインポート?}
    C -->|No| D[通常のインポート処理]
    C -->|Yes| E[マクロファイル読み込み]
    E --> F[マクロ呼び出し検出]
    F --> G[JSCでマクロ実行]
    G --> H{戻り値シリアライズ可能?}
    H -->|Yes| I[リテラルに変換]
    H -->|No| J[エラー: シリアライズ不可]
    I --> K[AST置換]
    D --> L[バンドル出力]
    K --> L
    J --> M[ビルド失敗]
    L --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-37-001 | シリアライズ可能 | マクロの戻り値はJSONシリアライズ可能な値のみ | 全マクロ |
| BR-37-002 | 同期実行 | マクロは同期的に実行される | 全マクロ |
| BR-37-003 | ビルド時実行 | マクロはビルド時にのみ実行され、実行時には呼び出されない | 全マクロ |
| BR-37-004 | Import属性 | with { type: 'macro' } でマクロを指定 | マクロインポート時 |

### 計算ロジック

**シリアライズ対応型**: プリミティブ（string, number, boolean, null）、配列、プレーンオブジェクトがシリアライズ可能。関数、シンボル、循環参照はサポートされない。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | エラー | マクロ実行時例外 | マクロコードを確認 |
| - | エラー | シリアライズ不可能な戻り値 | 戻り値をシリアライズ可能な型に変更 |
| - | エラー | マクロファイル未検出 | インポートパスを確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし（ビルド処理のみ）

## パフォーマンス要件

- マクロ実行はビルド時に行われるため、ビルド時間に影響
- 複雑なマクロはビルド時間を増加させる

## セキュリティ考慮事項

- マクロはビルド環境でフルアクセスで実行されるため、信頼できるコードのみ使用
- サードパーティのマクロは慎重に検証

## 備考

- Rustのproc_macroやC++のconstexprに似た概念
- 環境変数の埋め込み、設定ファイルの読み込みなどに活用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マクロ処理で使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bundle_v2.zig | `src/bundler/bundle_v2.zig` | macro_contextフィールドの初期化 |

**読解のコツ**: マクロはJavaScriptCoreを使用してビルド時に実行される。macro_contextがマクロ実行のコンテキストを管理。

#### Step 2: マクロ検出と実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ParseTask.zig | `src/bundler/ParseTask.zig` | マクロインポートの検出と処理 |

**主要処理フロー**:
- with { type: 'macro' } 属性の検出
- マクロモジュールの読み込み
- マクロ関数の実行

### プログラム呼び出し階層図

```
BundleV2.bundle()
    │
    ├─ ParseTask
    │      └─ インポート解析
    │             └─ マクロインポート検出
    │
    └─ MacroContext
           ├─ マクロファイル読み込み
           ├─ JSC実行環境準備
           ├─ マクロ関数実行
           ├─ 戻り値シリアライズ
           └─ AST置換
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ソースファイル ───▶ インポート解析 ───▶ マクロインポート検出
       │
       ▼
マクロモジュール ──▶ マクロ読み込み ───▶ マクロ関数
       │
       ▼
マクロ呼び出し ───▶ JSC実行 ───▶ 戻り値
       │
       ▼
戻り値 ──────────▶ シリアライズ ───▶ リテラルAST
       │
       ▼
リテラルAST ────▶ AST置換 ───▶ 評価済みコード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bundle_v2.zig | `src/bundler/bundle_v2.zig` | ソース | macro_contextの初期化 |
| ParseTask.zig | `src/bundler/ParseTask.zig` | ソース | マクロインポートの検出 |
| Transpiler.zig | `src/transpiler.zig` | ソース | トランスパイラ処理 |
