# 機能設計書 38-ローダー

## 概要

本ドキュメントは、Bunバンドラーにおけるローダー（Loader）機能の設計仕様を記載する。ローダーは、様々なファイルタイプを適切に処理し、バンドルに含める方法を決定する機能である。

### 本機能の処理概要

ローダー機能は、ファイルの拡張子やコンテンツに基づいて、そのファイルをどのように処理するかを決定する。JavaScript、TypeScript、JSON、CSS、テキスト、画像などの様々なファイルタイプに対応し、適切な変換やインライン化を行う。

**業務上の目的・背景**：モダンなWebアプリケーションは、JavaScript以外にも様々なファイルタイプを使用する。CSS、JSON、画像、テキストファイルなどをJavaScriptから直接インポートできるようにすることで、開発効率を向上させる。各ファイルタイプに適した処理（トランスパイル、Base64エンコード、テキストとしてのインポートなど）を提供する。

**機能の利用シーン**：様々なファイルタイプのインポート時、カスタムローダーの設定時、特定ファイルの処理方法指定時に利用される。CLI/API/bunfig.tomlでローダーを設定可能。

**主要な処理内容**：
1. ファイル拡張子からローダータイプの判定
2. JavaScript/TypeScriptのトランスパイル
3. JSONファイルのパースとインライン化
4. テキストファイルの文字列としてのインポート
5. バイナリファイルのBase64エンコードまたはファイルコピー
6. CSSファイルのバンドル処理

**関連システム・外部連携**：トランスパイラ、CSSパーサーと連携。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | build | 主画面 | バンドル処理時のローダー適用 |

## 機能種別

ファイル処理 / 変換処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| loader | map | No | 拡張子ごとのローダー設定 | 拡張子 -> ローダータイプ |
| default loader | Loader | No | 特定拡張子に対するデフォルトローダー | 拡張子に応じて自動設定 |

### 入力データソース

- ソースファイル（各種拡張子）
- bunfig.toml設定
- CLI/APIオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換済みコード | AST/文字列 | ローダーによって変換されたコード |
| アセットファイル | ファイル | file/copyローダーで処理されたファイル |

### 出力先

バンドル出力またはアセットディレクトリ

## 処理フロー

### 処理シーケンス

```
1. ファイル読み込み
   └─ インポートされたファイルを読み込み
2. ローダータイプ判定
   └─ 拡張子または設定からローダータイプを決定
3. ローダー処理
   └─ 各ローダータイプに応じた変換を実行
4. 結果の統合
   └─ 変換結果をバンドルに統合
```

### フローチャート

```mermaid
flowchart TD
    A[開始: ファイルインポート] --> B[拡張子取得]
    B --> C{ローダータイプ判定}
    C -->|js/ts/jsx/tsx| D[JavaScript処理]
    C -->|json| E[JSONパース]
    C -->|css| F[CSSバンドル処理]
    C -->|text| G[テキスト文字列化]
    C -->|file| H[ファイルコピー+URL]
    C -->|dataurl| I[Base64エンコード]
    C -->|binary| J[ArrayBufferとして読み込み]
    D --> K[結果統合]
    E --> K
    F --> K
    G --> K
    H --> K
    I --> K
    J --> K
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-001 | デフォルトローダー | .js/.ts/.jsx/.tsx/.mjs等は自動的にJavaScriptローダー | 該当拡張子 |
| BR-38-002 | JSONローダー | .jsonファイルはパースされてオブジェクトとしてインポート | .json拡張子 |
| BR-38-003 | CSSローダー | .cssファイルはCSSバンドラーで処理 | .css拡張子 |
| BR-38-004 | fileローダー | 画像等は出力ディレクトリにコピーしURLを返す | file指定時 |
| BR-38-005 | textローダー | ファイル内容を文字列としてインポート | text指定時 |

### ローダータイプ一覧

| ローダー | 説明 | 出力 |
|---------|------|------|
| js | JavaScript/TypeScriptとしてパース・トランスパイル | AST |
| jsx | JSXを含むJavaScript | AST |
| ts | TypeScript | AST |
| tsx | TSX | AST |
| json | JSONをパースしてオブジェクト化 | オブジェクトリテラル |
| toml | TOMLをパースしてオブジェクト化 | オブジェクトリテラル |
| css | CSSとしてバンドル | CSSファイル |
| text | 文字列としてインポート | 文字列リテラル |
| file | ファイルをコピーしURLを返す | URL文字列 |
| dataurl | Base64 Data URLとして埋め込み | Data URL文字列 |
| binary | ArrayBufferとして読み込み | ArrayBuffer |
| copy | 変換なしでファイルコピー | ファイル |

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | エラー | 不明な拡張子でローダー未設定 | ローダーを明示的に設定 |
| - | エラー | JSONパースエラー | JSON構文を確認 |
| - | エラー | ファイル読み込みエラー | ファイルパスを確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし（ファイル処理のみ）

## パフォーマンス要件

- ファイル読み込みと変換は効率的に処理
- 大きなファイルのBase64エンコードは適切に処理

## セキュリティ考慮事項

- dataurlローダーは大きなファイルをBase64エンコードするため、バンドルサイズに注意
- 外部URLの処理は行わない

## 備考

- bunfig.tomlでカスタムローダー設定が可能
- Bun.plugin() APIで動的にローダーを追加可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ローダーで使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | options.zig | `src/options.zig` | Loader enum定義、各ローダータイプ |

**読解のコツ**: Loader enumで定義されているローダータイプを確認。isJavaScriptLike()、isCSS()などのヘルパーメソッドも重要。

#### Step 2: ローダー判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ParseTask.zig | `src/bundler/ParseTask.zig` | ファイルのローダー判定と処理分岐 |

**主要処理フロー**:
- 拡張子からローダータイプを判定
- 各ローダータイプに応じた処理を呼び出し

#### Step 3: 各ローダーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scanImportsAndExports.zig | `src/bundler/linker_context/scanImportsAndExports.zig` | ローダーに応じたインポート処理 |

**主要処理フロー**:
- **314-351行目**: CSSファイルのURL処理
- ローダーに応じたインライン処理

### プログラム呼び出し階層図

```
BundleV2.bundle()
    │
    ├─ ParseTask
    │      ├─ ローダータイプ判定
    │      │
    │      ├─ JavaScript/TypeScript
    │      │      └─ js_parser.parse()
    │      │
    │      ├─ CSS
    │      │      └─ css_parser.parse()
    │      │
    │      ├─ JSON
    │      │      └─ json.parse()
    │      │
    │      └─ file/text/dataurl
    │             └─ 適切な変換処理
    │
    └─ LinkerContext
           └─ 結果の統合
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ファイル ─────────▶ 拡張子判定 ───▶ ローダータイプ
       │
       ▼
.js/.ts/.jsx/.tsx ──▶ js_parser ───▶ AST
.css ────────────────▶ css_parser ───▶ CSS AST
.json ───────────────▶ json.parse ───▶ オブジェクト
.txt (text) ─────────▶ 文字列化 ───▶ 文字列リテラル
画像 (file) ─────────▶ コピー ───▶ URL文字列
画像 (dataurl) ──────▶ Base64 ───▶ Data URL
       │
       ▼
変換結果 ────────────▶ バンドル統合 ───▶ 最終出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| options.zig | `src/options.zig` | ソース | Loader enum定義 |
| ParseTask.zig | `src/bundler/ParseTask.zig` | ソース | ローダー判定と処理分岐 |
| bundle_v2.zig | `src/bundler/bundle_v2.zig` | ソース | バンドル処理 |
| js_parser.zig | `src/js_parser.zig` | ソース | JavaScript/TypeScriptパース |
| css_parser.zig | `src/css/css_parser.zig` | ソース | CSSパース |
