# 機能設計書 4-ホットリロード

## 概要

本ドキュメントは、Bunランタイムにおけるファイル変更時の自動リロード機能（watchモード）の設計仕様を定義する。

### 本機能の処理概要

本機能は、ソースファイルの変更を検知して自動的にアプリケーションを再起動またはモジュールを再読み込みする機能を提供する。開発時の効率を向上させ、手動での再起動を不要にする。

**業務上の目的・背景**：開発中はコードの変更を頻繁に行うため、毎回手動で再起動するのは非効率である。ファイル変更を自動検知し、即座に変更を反映することで開発サイクルを高速化する。

**機能の利用シーン**：開発環境でのアプリケーション開発、APIサーバーの開発、フロントエンドアプリケーションの開発など。

**主要な処理内容**：
1. ファイルシステムウォッチャーの初期化
2. 対象ディレクトリ・ファイルの監視登録
3. ファイル変更イベントの検知
4. 変更ファイルの特定と依存関係の解析
5. プロセス再起動またはモジュールリロード
6. エラー時のリカバリー処理

**関連システム・外部連携**：OS固有のファイルシステム監視API（inotify/kqueue/Windows API）

**権限による制御**：ファイルシステムアクセス権限に基づく

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | run | 補助機能 | --watchや--hotオプションによるファイル変更検知と自動再起動 |

## 機能種別

システム監視 / 自動化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --watch | boolean | No | watchモードの有効化 | - |
| --hot | boolean | No | ホットリロードモードの有効化 | - |
| watch_paths | string[] | No | 追加の監視対象パス | 有効なパス |

### 入力データソース

- コマンドライン引数
- ファイルシステムイベント
- プロジェクト構成（package.json等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| change_event | WatchEvent | ファイル変更イベント情報 |
| reload_status | boolean | リロード成功/失敗 |

### 出力先

- プロセス制御（再起動）
- コンソール出力（変更通知）

## 処理フロー

### 処理シーケンス

```
1. ウォッチャー初期化
   └─ プラットフォーム固有のウォッチャーを初期化
2. 監視対象登録
   └─ カレントディレクトリとnode_modulesを監視対象に追加
3. イベントループ開始
   └─ ファイル変更イベントを待機
4. 変更検知
   └─ ファイル変更イベントを受信
5. デバウンス処理
   └─ 短時間の連続変更をまとめる
6. リロード実行
   └─ --watchの場合は再起動、--hotの場合はモジュールリロード
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ウォッチャー初期化]
    B --> C[監視対象登録]
    C --> D[イベント待機]
    D --> E{変更検知?}
    E -->|No| D
    E -->|Yes| F[デバウンス処理]
    F --> G{--hot?}
    G -->|Yes| H[モジュールリロード]
    G -->|No| I[プロセス再起動]
    H --> J{成功?}
    I --> J
    J -->|Yes| D
    J -->|No| K[エラー出力]
    K --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デバウンス間隔 | 100ms以内の連続変更は1回の変更として扱う | 変更検知時 |
| BR-02 | node_modules除外 | デフォルトでnode_modulesの変更は無視 | 監視対象判定時 |
| BR-03 | 監視対象上限 | 最大128ファイルを同時監視 | リソース制限 |
| BR-04 | プラットフォーム判定 | macOS:kqueue、Linux:inotify、Windows:ReadDirectoryChangesW | 初期化時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EMFILE | ファイル上限超過 | 監視対象が多すぎる | 監視対象を絞る |
| ENOENT | ファイル未検出 | 監視対象ファイルが削除された | 自動的に監視リストから除外 |

### リトライ仕様

- ウォッチャーエラー時は5秒後に自動再初期化

## トランザクション仕様

該当なし

## パフォーマンス要件

- 変更検知から再起動まで: 100ms以内
- メモリオーバーヘッド: 10MB以内
- CPU使用率: アイドル時1%以内

## セキュリティ考慮事項

- シンボリックリンク経由のディレクトリトラバーサル防止
- 悪意のあるファイル名パターンへの対策

## 備考

--hotオプションはHTTPサーバー等のステートフルなアプリケーションで、状態を保持したままコードを更新する際に使用する。--watchは単純なプロセス再起動を行う。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | watcher.zig | `src/watcher.zig` | Watcher構造体とWatchEvent構造体で監視システムのデータ構造を理解 |

**読解のコツ**: max_count定数（128）で同時監視数の上限、requires_file_descriptorsでプラットフォーム差異を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | watcher.zig | `src/watcher.zig` | init()関数とstart()関数でウォッチャーの初期化フローを理解 |

**主要処理フロー**:
1. **65-101行目**: init()でプラットフォーム固有ウォッチャーを初期化
2. **110-113行目**: start()でウォッチャースレッドを起動
3. **115-132行目**: deinit()でリソース解放

#### Step 3: プラットフォーム固有実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | INotifyWatcher.zig | `src/watcher/INotifyWatcher.zig` | Linux固有のinotify実装 |
| 3-2 | KEventWatcher.zig | `src/watcher/KEventWatcher.zig` | macOS固有のkqueue実装 |

**読解のコツ**:
- Platform型（143-148行目）でプラットフォーム切り替えを確認
- WatchEvent構造体（150行目以降）でイベント情報の構造を把握

### プログラム呼び出し階層図

```
bunコマンド --watch
    │
    ├─ watcher.zig::Watcher.init()
    │      └─ Platform.init() (プラットフォーム固有初期化)
    │
    ├─ watcher.zig::Watcher.start()
    │      └─ std.Thread.spawn() → threadMain()
    │
    └─ イベントループ
           ├─ onFileUpdate() (変更コールバック)
           └─ onError() (エラーコールバック)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ファイル変更 ───▶ OS API ───▶ Platform実装
                              │
                              ▼
                         WatchEvent
                              │
                              ▼
                    onFileUpdate() ───▶ プロセス再起動
                              │              or
                              └────▶ モジュールリロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| watcher.zig | `src/watcher.zig` | ソース | ウォッチャーのメイン実装 |
| INotifyWatcher.zig | `src/watcher/INotifyWatcher.zig` | ソース | Linux inotify実装 |
| KEventWatcher.zig | `src/watcher/KEventWatcher.zig` | ソース | macOS kqueue実装 |
| WindowsWatcher.zig | `src/watcher/WindowsWatcher.zig` | ソース | Windows実装 |
