# 機能設計書 43-ワークスペース

## 概要

本ドキュメントは、Bunパッケージマネージャーのワークスペース（monorepo）サポート機能に関する設計書である。複数パッケージを単一リポジトリで管理するmonorepo構成のサポートについて詳述する。

### 本機能の処理概要

ワークスペース機能は、package.jsonのworkspacesフィールドに定義された複数のサブパッケージを統合管理し、相互依存関係の解決、共通依存の巻き上げ（hoisting）、ローカルパッケージ間のリンクを自動化する機能である。

**業務上の目的・背景**：大規模なJavaScript/TypeScriptプロジェクトでは、複数の関連パッケージを単一リポジトリ（monorepo）で管理することが一般的である。ワークスペース機能により、パッケージ間の依存関係を効率的に管理し、開発・テスト・リリースの一貫性を確保できる。Lerna、Nx、Turborepo等のツールと連携可能。

**機能の利用シーン**：
- monorepoプロジェクトでの`bun install`実行
- ワークスペースパッケージ間の依存関係インストール
- `bun add -w`でのルートへの依存追加
- `bun --filter <pattern>`でのワークスペースフィルタリング

**主要な処理内容**：
1. package.jsonからworkspaces設定の読み取り
2. ワークスペースパッケージの検出（glob パターン対応）
3. ワークスペース間依存関係の解決（workspace:プロトコル）
4. 共通依存の巻き上げ（hoisting）による重複排除
5. ローカルパッケージへのシンボリックリンク作成
6. ワークスペースバージョンの管理

**関連システム・外部連携**：
- package.json（workspaces設定）
- bun.lockb（ロックファイル）
- pnpm-workspace.yaml互換
- Lerna、Nx、Turborepo等のmonorepoツール

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | install | 補助機能 | monorepoワークスペースのパッケージリンク |

## 機能種別

データ管理（依存関係管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| workspaces | array/object | Yes | ワークスペース設定 | globパターンまたはオブジェクト形式 |
| packages | array | No | ワークスペースパッケージのパス | workspaces.packages内 |
| nohoist | array | No | 巻き上げ除外パターン | workspaces.nohoist内 |

### 入力データソース

- ルートpackage.json（workspacesフィールド）
- 各ワークスペースのpackage.json
- pnpm-workspace.yaml（pnpm互換時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| workspace_paths | map | ワークスペース名とパスのマッピング |
| workspace_versions | map | ワークスペース名とバージョンのマッピング |
| symlinks | array | 作成されたシンボリックリンク |
| hoisted_deps | array | 巻き上げられた依存関係 |

### 出力先

- ルートnode_modules（hoisted依存）
- 各ワークスペースのnode_modules（シンボリックリンク）
- bun.lockb（ワークスペース情報を含む）

## 処理フロー

### 処理シーケンス

```
1. ルートpackage.jsonの解析
   └─ workspacesフィールドを読み取り
2. ワークスペースパッケージの検出
   └─ globパターンでディレクトリを検索
3. 各ワークスペースのpackage.json解析
   └─ name、version、dependenciesを取得
4. 依存関係グラフの構築
   └─ ワークスペース間依存関係を解決
5. 依存関係の巻き上げ計算
   └─ 共通依存をルートに巻き上げ
6. インストール実行
   └─ 外部依存のインストール、ローカルリンク作成
7. lockfileの更新
   └─ ワークスペース情報を含めて保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ルートpackage.json読み込み]
    B --> C{workspaces設定あり?}
    C -->|No| D[通常インストール]
    C -->|Yes| E[globパターンでパッケージ検索]
    E --> F[各ワークスペースのpackage.json解析]
    F --> G[依存関係グラフ構築]
    G --> H{循環依存あり?}
    H -->|Yes| I[エラー: 循環依存検出]
    H -->|No| J[依存関係の巻き上げ計算]
    J --> K[外部依存をインストール]
    K --> L[ワークスペース間リンク作成]
    L --> M[lockfile更新]
    M --> N[終了]
    D --> N
    I --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | workspace:プロトコル | workspace:*でローカルパッケージを参照 | 依存関係にworkspace:指定がある場合 |
| BR-43-02 | バージョン解決 | workspace:^はセマンティックバージョン制約として解決 | publish時に変換 |
| BR-43-03 | 巻き上げ | 同一バージョンの依存はルートに巻き上げ | デフォルト有効 |
| BR-43-04 | nohoist | nohoistパターンに一致する依存は巻き上げない | nohoist設定時 |
| BR-43-05 | 名前解決 | ワークスペースパッケージは名前で解決 | package.jsonのname使用 |

### 計算ロジック

ワークスペースパス解決:
```
workspace_path = root_dir + "/" + glob_match_path
symlink_path = node_modules + "/" + workspace_name
```

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| DependencyLoop | 循環依存 | ワークスペース間の循環参照 | 依存関係を見直し |
| WorkspaceNameMissing | 名前未定義 | ワークスペースのpackage.jsonにname未設定 | nameフィールドを追加 |
| NonExistentWorkspace | 未存在 | workspace:で指定されたパッケージが存在しない | パス/名前を確認 |
| InvalidPattern | 無効パターン | workspaces globパターンが不正 | パターンを修正 |

### リトライ仕様

ワークスペース解決は同期処理のため、リトライ不要。外部依存のインストールは通常のリトライポリシーに従う。

## トランザクション仕様

ワークスペース全体を1つのインストールトランザクションとして扱う。途中失敗時はロールバック。

## パフォーマンス要件

- ワークスペース検出: 100ms以内（100パッケージまで）
- 依存グラフ構築: パッケージ数に比例（O(n)）
- シンボリックリンク作成: 1ms/リンク以下

## セキュリティ考慮事項

- シンボリックリンクの参照先検証
- ワークスペース外へのリンク作成禁止

## 備考

- npm/yarn workspaces互換
- pnpm-workspace.yaml対応
- `--filter`オプションで特定ワークスペースのみ操作可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ワークスペース管理で使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lockfile.zig | `src/install/lockfile.zig` | workspace_paths、workspace_versionsフィールド |
| 1-2 | install.zig | `src/install/install.zig` | Features.workspacesフラグ |

**読解のコツ**: Lockfile構造体のworkspace_paths（名前→パス）とworkspace_versions（名前→バージョン）のマップがワークスペース管理の中核。

#### Step 2: ワークスペース検出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PackageManager.zig | `src/install/PackageManager.zig` | workspace_package_json_cacheフィールド |
| 2-2 | pnpm.zig | `src/install/pnpm.zig` | workspace関連処理（pnpm移行時） |

**主要処理フロー**:
1. **123行目**: workspace_package_json_cacheでワークスペースのpackage.jsonをキャッシュ
2. pnpm.zigの migratePnpmLockfile でワークスペース情報を構築

#### Step 3: 依存関係解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dependency.zig | `src/install/dependency.zig` | Behavior.workspaces |
| 3-2 | install.zig | `src/install/install.zig` | Features.workspace設定 |

**主要処理フロー**:
- **142-143行目（install.zig）**: Features構造体のworkspaces、patched_dependenciesフラグ
- **172-176行目**: workspace Featuresの定義

#### Step 4: ワークスペースフィルタリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PackageManager.zig | `src/install/PackageManager.zig` | WorkspaceFilter構造体 |

**主要処理フロー**:
- **205-260行目**: WorkspaceFilter union型でall/name/pathフィルタを実装
- **210-228行目**: init関数でフィルタパターンを解析

### プログラム呼び出し階層図

```
PackageManager
    │
    ├─ workspace_package_json_cache
    │      └─ ワークスペースpackage.jsonのキャッシュ
    │
    ├─ WorkspaceFilter.init()
    │      └─ フィルタパターンの解析
    │
    ├─ Lockfile
    │      ├─ workspace_paths (HashMap)
    │      └─ workspace_versions (HashMap)
    │
    └─ Features.workspace
           └─ ワークスペース依存の有効化
```

### データフロー図

```
[入力]                    [処理]                         [出力]

package.json ──────────▶ workspaces解析 ─────────────▶ glob パターン
workspaces                     │
                              ▼
                      ディレクトリ検索 ────────────▶ ワークスペースパス
                              │
                              ▼
各ワークスペース ──────▶ package.json解析 ──────────▶ name/version/deps
package.json                   │
                              ▼
                      依存グラフ構築 ─────────────▶ Lockfile
                              │
                              ▼
                      シンボリックリンク ─────────▶ node_modules/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | ワークスペースフィルタ、キャッシュ管理 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | ワークスペース情報の永続化 |
| install.zig | `src/install/install.zig` | ソース | Features.workspaces定義 |
| dependency.zig | `src/install/dependency.zig` | ソース | 依存関係の振る舞い定義 |
| pnpm.zig | `src/install/pnpm.zig` | ソース | pnpm-workspace.yaml互換 |
| yarn.zig | `src/install/yarn.zig` | ソース | yarn workspaces互換 |
