# 機能設計書 5-REPL

## 概要

本ドキュメントは、Bunランタイムにおける対話的なJavaScript実行環境（REPL: Read-Eval-Print Loop）の設計仕様を定義する。

### 本機能の処理概要

本機能は、ユーザーがインタラクティブにJavaScript/TypeScriptコードを入力・評価し、結果を即座に確認できる対話的シェル環境を提供する。`bun repl`コマンドで起動し、開発時のコード検証やデバッグに利用される。

**業務上の目的・背景**：開発者がコードのスニペットを素早くテストしたり、APIの動作を確認したりする際に、完全なファイルを作成せずに対話的に実験できる環境が必要である。REPLはこのニーズに応え、開発効率を向上させる。

**機能の利用シーン**：新しいAPIの動作確認、デバッグ時の変数検証、ライブラリの機能テスト、学習目的でのコード実験など。

**主要な処理内容**：
1. REPLプロンプトの表示
2. ユーザー入力の読み取り
3. 入力コードのトランスパイル（TypeScript対応）
4. JavaScriptCoreでのコード評価
5. 結果のフォーマットと表示
6. 履歴管理とタブ補完

**関連システム・外部連携**：JavaScriptCoreエンジン、トランスパイラ、ファイルシステム（履歴保存）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repl | 主画面 | 対話的JavaScriptシェルの起動と評価 |

## 機能種別

ユーザーインターフェース / コード評価

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| code_input | string | Yes | 評価するコード | 空でないこと |
| --print | boolean | No | 評価結果を自動表示 | - |

### 入力データソース

- 標準入力（ユーザーの対話入力）
- 履歴ファイル（~/.bun_repl_history）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| result | any | 評価結果 |
| formatted_output | string | フォーマット済み出力 |

### 出力先

- 標準出力（評価結果）
- 標準エラー出力（エラーメッセージ）
- 履歴ファイル（入力履歴）

## 処理フロー

### 処理シーケンス

```
1. REPL起動
   └─ プロンプト表示とreadline初期化
2. 入力待機
   └─ ユーザー入力を読み取り
3. 構文解析
   └─ 入力が完全な文かを判定（複数行対応）
4. トランスパイル
   └─ TypeScript/JSXの場合は変換
5. 評価
   └─ JavaScriptCoreで実行
6. 結果表示
   └─ 結果をフォーマットして出力
7. 履歴保存
   └─ 入力履歴をファイルに保存
8. ループ継続
   └─ 2に戻る（exitまで）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[REPL初期化]
    B --> C[プロンプト表示]
    C --> D[入力待機]
    D --> E{入力あり?}
    E -->|No| D
    E -->|Yes| F{exit/quit?}
    F -->|Yes| G[終了]
    F -->|No| H{複数行継続?}
    H -->|Yes| I[継続プロンプト]
    I --> D
    H -->|No| J[トランスパイル]
    J --> K[評価実行]
    K --> L{成功?}
    L -->|Yes| M[結果表示]
    L -->|No| N[エラー表示]
    M --> O[履歴保存]
    N --> O
    O --> C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 複数行入力 | 開き括弧や未完了文は継続プロンプトで入力継続 | 構文不完全時 |
| BR-02 | 履歴保存 | 入力履歴は~/.bun_repl_historyに保存 | REPL終了時 |
| BR-03 | 自動表示 | 式の評価結果は自動的に表示される | 式評価時 |
| BR-04 | await対応 | トップレベルawaitをサポート | 非同期コード評価時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SyntaxError | 構文エラー | JavaScript/TypeScriptの構文が不正 | コードを修正 |
| ReferenceError | 参照エラー | 未定義の変数を参照 | 変数を定義 |
| TypeError | 型エラー | 型不一致の操作 | コードを修正 |

### リトライ仕様

該当なし（エラー後も継続可能）

## トランザクション仕様

該当なし

## パフォーマンス要件

- 入力からプロンプト表示まで: 50ms以内
- 単純な式評価: 10ms以内

## セキュリティ考慮事項

- REPLはローカル環境での実行を前提
- 履歴ファイルにはセンシティブな情報が含まれる可能性

## 備考

REPLはNode.jsのREPLと基本的な使い方は同様だが、TypeScriptのネイティブサポートが特徴。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cli.zig | `src/cli.zig` | Command.Tagでreplコマンドの定義を確認 |

**読解のコツ**: CLI全体のコマンド定義を把握し、REPLがどのように呼び出されるかを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HelpCommand | `src/cli.zig` | cli_helptext_fmtでreplコマンドのヘルプ表示を確認 |

**主要処理フロー**:
- **170行目**: `repl`コマンドが「Start a REPL session with Bun」として定義

#### Step 3: JavaScript実行基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BunObject.zig | `src/bun.js/api/BunObject.zig` | Bun APIオブジェクトでREPL内で利用可能な機能を確認 |

**読解のコツ**:
- REPL内ではBunオブジェクトのすべての機能が利用可能
- トップレベルawaitはVirtualMachineの機能として実装

### プログラム呼び出し階層図

```
bun repl
    │
    ├─ cli.zig::Command
    │      └─ ReplCommand判定
    │
    ├─ REPL初期化
    │      ├─ readline初期化
    │      └─ 履歴読み込み
    │
    └─ REPLループ
           ├─ 入力読み取り
           ├─ トランスパイル（必要に応じて）
           ├─ JavaScriptCore評価
           └─ 結果表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー入力 ───▶ readline ───▶ 入力バッファ
                                  │
                                  ▼
                          トランスパイラ
                                  │
                                  ▼
                         JavaScriptCore ───▶ 評価結果
                                  │
                                  ▼
                          フォーマッタ ───▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cli.zig | `src/cli.zig` | ソース | CLIコマンド定義 |
| BunObject.zig | `src/bun.js/api/BunObject.zig` | ソース | Bun API定義 |
| transpiler.zig | `src/transpiler.zig` | ソース | コードトランスパイル |
| VirtualMachine.zig | `src/bun.js/VirtualMachine.zig` | ソース | JavaScript実行環境 |
