# 機能設計書 54-DOMテスト

## 概要

本ドキュメントは、Bunテストランナーにおけるhappy-domを利用したDOMテスト機能の設計仕様を記述する。

### 本機能の処理概要

DOMテスト機能は、Bunのpreload機能を活用してhappy-domをテスト実行前にロードし、ブラウザAPI（document、window等）をNode.js/Bun環境で利用可能にする。これにより、フロントエンドコンポーネントやDOM操作のヘッドレステストを実現する。

**業務上の目的・背景**：フロントエンド開発において、ブラウザを起動せずにDOMを操作するコードをテストする必要がある。happy-domは完全なHTMLおよびDOM APIをJavaScriptで実装しており、高い忠実度でブラウザ環境をシミュレートできる。

**機能の利用シーン**：Reactコンポーネントのユニットテスト、DOM操作ライブラリのテスト、React Testing Libraryとの連携、SSR（サーバーサイドレンダリング）コードのテスト。

**主要な処理内容**：
1. bunfig.tomlでpreloadファイルを設定
2. preloadファイルでhappy-domのGlobalRegistratorを実行
3. グローバルスコープにブラウザAPIを登録
4. テストファイルでdocument、window等を使用可能に
5. テスト実行とアサーション

**関連システム・外部連携**：happy-dom（@happy-dom/global-registrator）、React Testing Library、Jest DOM。

**権限による制御**：特になし。全ユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | test | 主画面 | preload機能によるhappy-dom読み込み |

## 機能種別

テスト環境設定 / 外部ライブラリ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| preload | 文字列配列 | No | テスト前に実行するファイル | 有効なファイルパス |

### 設定ファイル

```toml
# bunfig.toml
[test]
preload = ["./happydom.ts"]
```

### preloadファイル例

```typescript
// happydom.ts
import { GlobalRegistrator } from "@happy-dom/global-registrator";

GlobalRegistrator.register();
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| グローバルAPI | object | document、window、HTMLElement等のブラウザAPI |

### 登録されるグローバルオブジェクト

- `document` - DOMドキュメント
- `window` - ブラウザウィンドウ
- `HTMLElement` - HTML要素基底クラス
- `Event` - イベントオブジェクト
- `CustomEvent` - カスタムイベント
- その他のWeb API（localStorage、sessionStorage等）

## 処理フロー

### 処理シーケンス

```
1. bunfig.toml読み込み
   └─ [test].preloadセクションを解析
2. preloadファイル実行
   └─ happydom.tsを同期的に実行
3. GlobalRegistrator.register()
   └─ グローバルスコープにブラウザAPIを登録
4. テストファイル実行
   └─ document、window等が使用可能な状態でテスト開始
5. テストアサーション
   └─ DOM要素の検証
```

### フローチャート

```mermaid
flowchart TD
    A[bun test開始] --> B[bunfig.toml読み込み]
    B --> C{preload設定あり?}
    C -->|No| D[テストファイル実行]
    C -->|Yes| E[preloadファイル実行]
    E --> F[GlobalRegistrator.register]
    F --> G[ブラウザAPI登録]
    G --> D
    D --> H[documentアクセス]
    H --> I[DOM操作]
    I --> J[アサーション]
    J --> K[テスト完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-1 | preload同期実行 | preloadファイルはテスト前に同期的に実行される | 常時 |
| BR-54-2 | グローバルスコープ注入 | happy-domはglobalThisにAPIを注入 | GlobalRegistrator.register()呼び出し時 |
| BR-54-3 | TypeScript型定義 | /// <reference lib="dom" />で型を注入 | TypeScriptプロジェクト |

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ModuleNotFoundError | @happy-dom/global-registratorが未インストール | bun add -d @happy-dom/global-registratorを実行 |
| - | PreloadError | preloadファイルが存在しない | パスを確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし（データベース操作なし）。

## パフォーマンス要件

- preloadファイルの実行は起動時のオーバーヘッドとして計上
- happy-domの初期化：通常100ms未満

## セキュリティ考慮事項

- happy-domはサンドボックス環境ではないため、実際のネットワークリクエストは行わない
- preloadファイルはプロジェクト内のファイルのみを指定することを推奨

## 備考

- Bunはhappy-domを公式に推奨している
- jsdomも使用可能だが、happy-domの方が軽量で高速
- React Testing LibraryはReactコンポーネントテストに推奨

---

## コードリーディングガイド

本機能はBunのpreload機能とサードパーティライブラリ（happy-dom）の組み合わせで実現されるため、Bun内部コードよりも設定とライブラリの使用法が中心となる。

### 推奨読解順序

#### Step 1: preload機能を理解する

まず、Bunのpreload機能がどのように実装されているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bunfig.zig | `src/bunfig.zig` | preloadオプションの解析 |
| 1-2 | test_command.zig | `src/cli/test_command.zig` | テスト実行時のpreload処理 |

**読解のコツ**: bunfigの[test]セクションでpreload配列を解析し、テスト開始前に各ファイルをrequire/importする流れを確認する。

#### Step 2: happy-domの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | 公式ドキュメント | `docs/test/dom.mdx` | happy-domのセットアップ手順 |

**主要処理フロー**:
- GlobalRegistrator.register()がglobalThisにwindow、document等を注入
- Bunのテストランナーがこれらのグローバル変数を認識

#### Step 3: React Testing Libraryとの連携

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 公式ドキュメント | `docs/test/dom.mdx` | React Testing Libraryの使用例 |

### プログラム呼び出し階層図

```
bun test (テスト実行)
    │
    ├─ bunfig.zig (設定読み込み)
    │      └─ [test].preload解析
    │
    ├─ preloadファイル実行
    │      └─ happydom.ts
    │             └─ GlobalRegistrator.register()
    │                    └─ globalThisにブラウザAPI注入
    │
    └─ テストファイル実行
           └─ document、window等が利用可能
```

### データフロー図

```
[入力]                    [処理]                           [出力]

bunfig.toml ────────▶ preload設定解析 ─────────▶ preloadファイルリスト
                              │
happydom.ts ────────▶ GlobalRegistrator.register ▶ グローバルAPI登録
                              │
テストファイル ─────▶ テスト実行 ───────────────▶ テスト結果
                              │
                              └─ document.body.innerHTML = ...
                              └─ document.querySelector(...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bunfig.zig | `src/bunfig.zig` | ソース | 設定ファイル解析、preloadオプション |
| test_command.zig | `src/cli/test_command.zig` | ソース | テストコマンド実行 |
| dom.mdx | `docs/test/dom.mdx` | ドキュメント | DOMテストの公式ガイド |
| happydom.ts | ユーザー作成 | 設定 | preloadファイル例 |
| @happy-dom/global-registrator | npm | 外部ライブラリ | happy-domのグローバル登録 |
