# 機能設計書 6-環境変数

## 概要

本ドキュメントは、Bunランタイムにおける.envファイルの自動読み込みと環境変数管理機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、.envファイルからの環境変数の自動読み込みと、process.envおよびBun.envを通じた環境変数アクセスを提供する。Node.jsのdotenvパッケージと同等の機能を内蔵し、追加のパッケージインストールなしで環境変数管理を実現する。

**業務上の目的・背景**：アプリケーションの設定値（APIキー、データベース接続情報、環境固有設定など）を環境変数で管理することはセキュリティとポータビリティの観点から重要である。Bunは.envファイルのネイティブサポートにより、設定の外部化を簡単に実現する。

**機能の利用シーン**：開発/本番環境の切り替え、APIキーの管理、データベース接続情報の設定、機能フラグの制御など。

**主要な処理内容**：
1. .envファイルの検索と読み込み
2. 環境固有ファイル（.env.local, .env.development等）の優先順位処理
3. 変数展開（${VAR}形式）
4. process.envおよびBun.envへの登録
5. NODE_ENVに基づく読み込みファイルの決定

**関連システム・外部連携**：ファイルシステム、プロセス環境

**権限による制御**：ファイルシステムアクセス権限に基づく

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | run | 補助機能 | .envファイルの読み込みとprocess.envへの設定 |

## 機能種別

設定管理 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --env-file | string | No | カスタム.envファイルのパス | 有効なファイルパス |
| NODE_ENV | string | No | 環境名（development/production/test） | - |

### 入力データソース

- .envファイル群
- 既存のプロセス環境変数
- bunfig.toml（env設定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| process.env | object | 環境変数オブジェクト |
| Bun.env | object | Bun固有の環境変数アクセサ |

### 出力先

- JavaScriptランタイム（process.env/Bun.env）

## 処理フロー

### 処理シーケンス

```
1. 環境判定
   └─ NODE_ENV/BUN_ENVの値を確認
2. ファイル探索
   └─ 優先順位に従い.envファイルを探索
3. ファイル読み込み
   └─ 各.envファイルをパースして変数を抽出
4. 変数展開
   └─ ${VAR}形式の参照を解決
5. 環境変数登録
   └─ process.envとBun.envに値を設定
6. プロキシ設定
   └─ HTTP_PROXY等のプロキシ関連変数を処理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NODE_ENV確認]
    B --> C{NODE_ENV?}
    C -->|development| D[.env.development読み込み]
    C -->|production| E[.env.production読み込み]
    C -->|test| F[.env.test読み込み]
    C -->|未設定| G[.env読み込み]
    D --> H[.env.local読み込み]
    E --> H
    F --> H
    G --> H
    H --> I[.env読み込み]
    I --> J[変数展開]
    J --> K[process.env登録]
    K --> L[Bun.env登録]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 読み込み優先順位 | .env.local > .env.{NODE_ENV}.local > .env.{NODE_ENV} > .env | 複数ファイル存在時 |
| BR-02 | 既存値保持 | 既にシステムで定義されている環境変数は上書きしない | 環境変数登録時 |
| BR-03 | 変数展開 | ${VAR}形式で他の変数を参照可能 | ファイルパース時 |
| BR-04 | コメント除外 | #で始まる行はコメントとして無視 | ファイルパース時 |
| BR-05 | 空白トリム | 値の前後の空白は除去される | 値取得時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル未検出 | .envファイルが存在しない | 警告のみ（エラーではない） |
| PARSE_ERROR | パースエラー | .envファイルの形式が不正 | ファイルを修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- .envファイル読み込み: 5ms以内
- 変数アクセス: 即時（キャッシュ済み）

## セキュリティ考慮事項

- .envファイルは.gitignoreに追加すべき
- 本番環境の認証情報は.envファイルに含めず、システム環境変数を使用
- ログ出力時に環境変数値をマスク

## 備考

Bunはdotenvパッケージなしで.envファイルをサポートするため、依存関係を削減できる。bunfig.tomlのenv設定でカスタマイズも可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | env_loader.zig | `src/env_loader.zig` | Loader構造体で環境変数ローダーの構造を理解 |

**読解のコツ**: DotEnvFileSuffix enumで環境固有ファイルサフィックスを定義。development/production/testの3種類をサポート。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | env_loader.zig | `src/env_loader.zig` | Loader構造体のフィールドで読み込み対象ファイルを確認 |

**主要処理フロー**:
1. **7-18行目**: Loader構造体で各.envファイルの読み込み状態を管理
2. **30-38行目**: iterator()でMapのイテレーションを提供
3. **41-49行目**: isProduction()/isTest()で環境判定

#### Step 3: 環境変数アクセスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | env_loader.zig | `src/env_loader.zig` | get()系メソッドで環境変数取得の仕組みを理解 |

**主要処理フロー**:
- **51-63行目**: getNodePath()でNODE実行パスを取得
- **65-71行目**: isCI()でCI環境を判定
- **75-135行目**: getS3Credentials()でAWS/S3認証情報を取得
- **139-156行目**: getTLSRejectUnauthorized()でTLS設定を取得
- **158-200行目以降**: getHttpProxy()でプロキシ設定を取得

### プログラム呼び出し階層図

```
Bunランタイム起動
    │
    ├─ env_loader.zig::Loader初期化
    │      ├─ .env読み込み
    │      ├─ .env.local読み込み
    │      ├─ .env.{NODE_ENV}読み込み
    │      └─ .env.{NODE_ENV}.local読み込み
    │
    ├─ Map構築
    │      └─ 変数名→値のマッピング
    │
    └─ ランタイムへ提供
           ├─ process.env
           └─ Bun.env
```

### データフロー図

```
[入力]               [処理]                    [出力]

.envファイル群 ───▶ Loader.load() ───▶ Map構築
                         │
                         ▼
               変数展開（${VAR}解決）
                         │
                         ▼
               process.env ───▶ JavaScript
               Bun.env    ───▶ JavaScript
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| env_loader.zig | `src/env_loader.zig` | ソース | 環境変数ローダーメイン実装 |
| env_var.zig | `src/env_var.zig` | ソース | 環境変数アクセスユーティリティ |
| bunfig.zig | `src/bunfig.zig` | ソース | bunfig.tomlのenv設定処理 |
