# 機能設計書 63-Bun.redis

## 概要

本ドキュメントは、BunランタイムのRedisクライアント機能（`Bun.redis`）の設計仕様を記載する。

### 本機能の処理概要

`Bun.redis`は、Redis/Valkeyデータベースへの高性能な接続と操作を提供するBun組み込みクライアントである。ネイティブZig実装により、外部依存なしに高速なRedis接続、自動パイプライニング、Pub/Subサポートを実現する。

**業務上の目的・背景**：Webアプリケーションやマイクロサービスアーキテクチャでは、Redisはセッション管理、キャッシュ、リアルタイム通信、メッセージキューなど多くの用途で使用される。従来のNode.js用Redisドライバ（ioredis等）は外部依存があり、Bunのネイティブ統合により依存関係を削減しつつ高性能なRedisアクセスを提供する。

**機能の利用シーン**：
- セッション管理とユーザー認証状態の保存
- アプリケーションキャッシュ
- リアルタイム通知（Pub/Sub）
- レート制限の実装
- 分散ロック
- リーダーボードとランキング（Sorted Set）

**主要な処理内容**：
1. Redis/Valkeyサーバーへの接続確立（TCP/TLS/Unix Socket）
2. 文字列、ハッシュ、リスト、セット、ソート済みセット等のデータ操作
3. Pub/Subによるメッセージング
4. 自動パイプライニングによる性能最適化
5. 自動再接続とエラーハンドリング
6. トランザクション（MULTI/EXEC）サポート

**関連システム・外部連携**：Redis/Valkeyサーバー（外部）、TLS/SSL証明書（任意）

**権限による制御**：Redis ACL（アクセス制御リスト）に依存

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI専用であり、直接関連する画面はない |

## 機能種別

データ連携 / キャッシュ操作 / メッセージング

## 入力仕様

### 入力パラメータ

#### 接続オプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | string | No | Redis接続URL（redis://...） | URL形式 |
| hostname | string | No | ホスト名（デフォルト: localhost） | - |
| port | number | No | ポート番号（デフォルト: 6379） | 正の整数 |
| username | string | No | ユーザー名（Redis 6.0+のACL用） | - |
| password | string | No | パスワード | - |
| database | number | No | データベース番号（デフォルト: 0） | 0-15 |
| tls | boolean \| TLSOptions | No | TLS設定 | - |
| idleTimeout | number | No | アイドルタイムアウト（ミリ秒） | 正の整数 |
| connectionTimeout | number | No | 接続タイムアウト（デフォルト: 10000ms） | 正の整数 |
| enableAutoReconnect | boolean | No | 自動再接続（デフォルト: true） | - |
| maxRetries | number | No | 最大リトライ回数（デフォルト: 20） | 正の整数 |
| enableOfflineQueue | boolean | No | オフラインキュー（デフォルト: true） | - |
| enableAutoPipelining | boolean | No | 自動パイプライニング（デフォルト: true） | - |

### 入力データソース

- Redis/Valkeyサーバー（TCP、TLS、Unix Socket経由）
- 環境変数（REDIS_URL等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| string値 | string \| null | GET等の文字列結果 |
| Buffer値 | Buffer | getBuffer等のバイナリ結果 |
| 数値 | number | INCR, DEL等の数値結果 |
| 配列 | Array | MGET, SMEMBERS等のリスト結果 |
| オブジェクト | Object | HGETALL等のハッシュ結果 |

### 出力先

- JavaScript オブジェクト/配列/文字列（コマンド結果）

## 処理フロー

### 処理シーケンス

```
1. 接続の確立
   └─ Redisサーバーへの接続、認証、DB選択
2. コマンドの準備
   └─ RESPプロトコル形式でコマンドをシリアライズ
3. パイプライニング
   └─ 複数コマンドをまとめて送信
4. コマンドの送信
   └─ ソケット経由でRedisサーバーに送信
5. 結果の受信
   └─ RESPプロトコルの解析
6. 結果の返却
   └─ JavaScript値としてPromiseを解決
7. 接続の管理
   └─ アイドルタイムアウト、自動再接続
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{接続済み?}
    B -->|No| C[Redisサーバーに接続]
    B -->|Yes| D[コマンド実行]
    C --> E{接続成功?}
    E -->|No| F{リトライ可能?}
    F -->|Yes| G[バックオフ待機]
    G --> C
    F -->|No| H[エラーを返却]
    E -->|Yes| I[認証/DB選択]
    I --> D
    D --> J[コマンドをRESPでシリアライズ]
    J --> K{パイプライン?}
    K -->|Yes| L[キューに追加]
    K -->|No| M[即座に送信]
    L --> N[Auto Flush]
    N --> M
    M --> O[結果受信]
    O --> P[RESPパース]
    P --> Q[Promiseを解決]
    Q --> R[終了]
    H --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 自動パイプライニング | 複数コマンドを自動的にパイプラインで送信 | enableAutoPipelining: true |
| BR-002 | オフラインキュー | 切断中のコマンドをキューに保持し再接続時に実行 | enableOfflineQueue: true |
| BR-003 | 自動再接続 | 接続断時に指数バックオフで再接続 | enableAutoReconnect: true |
| BR-004 | 指数バックオフ | 再接続間隔: 50ms〜2000ms（リトライ回数に応じて増加） | 再接続時 |

### 計算ロジック

- 再接続遅延: `min(baseDelay * 2^(attempt-1), maxDelay)` where baseDelay=50ms, maxDelay=2000ms

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| get/set | 文字列 | 読み取り/書き込み | キー・バリュー操作 |
| hget/hset | ハッシュ | 読み取り/書き込み | ハッシュフィールド操作 |
| lpush/rpush/lpop/rpop | リスト | 追加/削除 | リスト操作 |
| sadd/srem/smembers | セット | 追加/削除/読み取り | セット操作 |
| zadd/zrem/zrange | ソート済みセット | 追加/削除/読み取り | ランキング等 |
| subscribe/publish | Pub/Sub | サブスクライブ/パブリッシュ | メッセージング |

### テーブル別操作詳細

Redisはキー・バリューストアのため、テーブル概念はなし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ConnectionClosed | 接続エラー | 接続が切断された | 自動再接続を待つか手動で再接続 |
| AuthenticationFailed | 認証エラー | パスワードが不正 | 認証情報を確認 |
| ERR | Redisエラー | コマンドエラー | エラーメッセージを確認 |
| WRONGTYPE | 型エラー | 操作対象の型が不正 | 正しいデータ型で操作 |

### リトライ仕様

- 最大リトライ回数: デフォルト20回
- リトライ間隔: 指数バックオフ（50ms〜2000ms）
- オフラインキュー有効時、再接続後にキューのコマンドを実行

## トランザクション仕様

- Redisの`MULTI/EXEC`はサポート（`send`メソッド経由）
- 楽観的ロック（WATCH）もサポート可能

## パフォーマンス要件

- ネイティブZig実装による高速処理
- 自動パイプライニングによるラウンドトリップ削減
- バッファ管理による効率的なメモリ使用

## セキュリティ考慮事項

- TLS/SSL暗号化接続のサポート
- Redis ACLによるアクセス制御
- パスワード認証

## 備考

- Redis 6.0以降のACL（ユーザー名+パスワード）対応
- Valkey（Redis互換）もサポート
- Pub/Subモードでは専用接続を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Valkeyクライアントの状態管理構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | valkey.zig | `src/valkey/valkey.zig` | ConnectionFlags、Status、Protocol、Options構造 |
| 1-2 | valkey.classes.ts | `src/bun.js/api/valkey.classes.ts` | JSから公開されるメソッド一覧 |

**読解のコツ**: ConnectionFlagsの各フラグがクライアントの状態遷移にどう影響するかを理解する。

#### Step 2: エントリーポイントを理解する

ValkeyClientの主要構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | valkey.zig | `src/valkey/valkey.zig` | ValkeyClient構造体（170行目〜） |

**主要処理フロー**:
1. **170-208行目**: ValkeyClient構造体のフィールド定義
2. **8-32行目**: ConnectionFlagsの各フラグ意味
3. **114-167行目**: Address、Options、TLS設定

#### Step 3: 自動パイプライニングを理解する

パイプライニングによる性能最適化の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | valkey.zig | `src/valkey/valkey.zig` | registerAutoFlusher、onAutoFlush |

**主要処理フロー**:
- **254-267行目**: registerAutoFlusher/unregisterAutoFlusher
- **270-319行目**: onAutoFlush()でパイプライン実行

#### Step 4: 再接続ロジックを理解する

自動再接続と指数バックオフを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | valkey.zig | `src/valkey/valkey.zig` | getReconnectDelay、rejectAllPendingCommands |

**主要処理フロー**:
- **338-358行目**: getReconnectDelay()で指数バックオフ計算
- **360-381行目**: rejectAllPendingCommands()でエラー伝播

### プログラム呼び出し階層図

```
Bun.redis (JavaScript API)
    │
    ├─ ValkeyClient (valkey.zig)
    │      ├─ socket管理
    │      ├─ write_buffer / read_buffer
    │      ├─ in_flight (実行中コマンド)
    │      ├─ queue (待機中コマンド)
    │      └─ auto_flusher (パイプライン制御)
    │
    ├─ ValkeyCommand (ValkeyCommand.zig)
    │      ├─ シリアライズ
    │      └─ Promise管理
    │
    ├─ ValkeyContext (ValkeyContext.zig)
    │      └─ グローバルコンテキスト
    │
    └─ ValkeyProtocol (valkey_protocol.zig)
           ├─ RESPエンコード
           └─ RESPデコード
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンド + 引数 ─────────▶ Command.serialize() ─────────▶ RESPバイト列
                                │
                                ▼
                         queue.writeItem() ────────────▶ 待機キュー
                                │
                                ▼
                         onAutoFlush() ────────────────▶ パイプライン送信
                                │
                                ▼
                         socket.write() ───────────────▶ Redisサーバー
                                │
                                ▼
                         socket.read() ────────────────▶ RESPレスポンス
                                │
                                ▼
                         protocol.parse() ─────────────▶ JavaScript値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| valkey.zig | `src/valkey/valkey.zig` | ソース | メインクライアント実装 |
| valkey_protocol.zig | `src/valkey/valkey_protocol.zig` | ソース | RESPプロトコル実装 |
| ValkeyCommand.zig | `src/valkey/ValkeyCommand.zig` | ソース | コマンド管理 |
| ValkeyContext.zig | `src/valkey/ValkeyContext.zig` | ソース | コンテキスト管理 |
| valkey.classes.ts | `src/bun.js/api/valkey.classes.ts` | ソース | JSバインディング定義 |
