# 機能設計書 64-Bun.s3

## 概要

本ドキュメントは、BunランタイムのS3互換オブジェクトストレージクライアント機能（`Bun.s3`）の設計仕様を記載する。

### 本機能の処理概要

`Bun.s3`は、Amazon S3およびS3互換オブジェクトストレージ（MinIO、Cloudflare R2、DigitalOcean Spaces等）へのアクセスを提供するBun組み込みクライアントである。ネイティブZig実装により、マルチパートアップロード、署名付きURL生成、オブジェクト操作を高速に実行する。

**業務上の目的・背景**：クラウドネイティブアプリケーションでは、ファイルストレージとしてS3が広く使用されている。従来のNode.js用AWS SDKは重量級であり、Bunのネイティブ統合によりシンプルかつ高速なS3アクセスを提供する。

**機能の利用シーン**：
- ファイルアップロード・ダウンロード
- 静的アセットの配信
- バックアップとアーカイブ
- ユーザー生成コンテンツの保存
- 署名付きURLによる一時的アクセス許可

**主要な処理内容**：
1. S3バケットへのファイル読み書き
2. マルチパートアップロード（大容量ファイル対応）
3. 署名付きURL（Presigned URL）の生成
4. オブジェクトのメタデータ取得（stat, exists, size）
5. オブジェクトの削除
6. オブジェクト一覧の取得

**関連システム・外部連携**：Amazon S3、S3互換サービス（MinIO、R2、Spaces等）

**権限による制御**：AWS IAM、S3バケットポリシー、ACL

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI専用であり、直接関連する画面はない |

## 機能種別

データ連携 / ファイル操作 / オブジェクトストレージ

## 入力仕様

### 入力パラメータ

#### S3Client コンストラクタオプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| endpoint | string | No | カスタムエンドポイントURL | URL形式 |
| region | string | No | AWSリージョン | - |
| bucket | string | No | デフォルトバケット名 | - |
| accessKeyId | string | No | AWSアクセスキーID | - |
| secretAccessKey | string | No | AWSシークレットアクセスキー | - |
| sessionToken | string | No | 一時的セッショントークン | - |
| acl | string | No | アクセス制御（private, public-read等） | - |
| partSize | number | No | マルチパートアップロードのパートサイズ | - |
| queueSize | number | No | 同時アップロードキューサイズ | - |
| retry | number | No | リトライ回数 | - |

#### file/write/exists/size/stat/unlink メソッド

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| path | string | Yes | S3オブジェクトパス | - |
| options | object | No | 追加オプション | - |

### 入力データソース

- 環境変数（AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, AWS_REGION等）
- 設定オプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| S3File | Blob | S3オブジェクトのBlobインスタンス |
| presignedUrl | string | 署名付きURL |
| exists結果 | boolean | オブジェクト存在確認 |
| size結果 | number | オブジェクトサイズ（バイト） |
| stat結果 | S3Stat | オブジェクトメタデータ |
| list結果 | Array | オブジェクト一覧 |

### 出力先

- JavaScript オブジェクト（メタデータ、URL等）
- Blob/Buffer（ファイル内容）

## 処理フロー

### 処理シーケンス

```
1. クライアント初期化
   └─ 認証情報の取得（環境変数またはオプション）
2. リクエスト準備
   └─ AWS署名バージョン4の計算
3. HTTPリクエスト送信
   └─ S3 REST APIを呼び出し
4. レスポンス処理
   └─ XMLレスポンスのパース、エラーハンドリング
5. 結果返却
   └─ JavaScriptオブジェクトとしてPromiseを解決
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証情報取得}
    B -->|環境変数| C[AWS認証情報読み込み]
    B -->|オプション| D[オプションから認証情報取得]
    C --> E[S3Client作成]
    D --> E
    E --> F{操作種別}
    F -->|file| G[S3File Blob作成]
    F -->|write| H[PUTリクエスト]
    F -->|exists/size/stat| I[HEADリクエスト]
    F -->|unlink| J[DELETEリクエスト]
    F -->|list| K[GET Bucket]
    F -->|presign| L[署名付きURL生成]
    G --> M[結果返却]
    H --> M
    I --> M
    J --> M
    K --> M
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | マルチパートアップロード | 大容量ファイルを分割してアップロード | partSize超過時 |
| BR-002 | 仮想ホストスタイル | バケット名をホスト名に含める | virtualHostedStyle有効時 |
| BR-003 | パススタイル | バケット名をパスに含める | virtualHostedStyle無効時 |
| BR-004 | リージョン推定 | エンドポイントからリージョンを推定 | region未指定時 |

### 計算ロジック

- 署名付きURL: AWS Signature Version 4アルゴリズム

## データベース操作仕様

S3はオブジェクトストレージのため、データベース操作は適用外。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NoSuchKey | オブジェクトエラー | オブジェクトが存在しない | パスを確認 |
| AccessDenied | 認証エラー | アクセス権限がない | IAMポリシー/バケットポリシー確認 |
| InvalidAccessKeyId | 認証エラー | アクセスキーが不正 | 認証情報を確認 |
| BucketNotFound | バケットエラー | バケットが存在しない | バケット名を確認 |

### リトライ仕様

- retryオプションでリトライ回数を設定可能
- 一時的エラー（5xx）の場合に自動リトライ

## トランザクション仕様

S3はトランザクション非対応。マルチパートアップロードは完了またはアボートで一貫性を確保。

## パフォーマンス要件

- ネイティブZig実装による高速処理
- マルチパートアップロードによる大容量ファイル対応
- queueSizeによる同時アップロード制御

## セキュリティ考慮事項

- AWS Signature Version 4による認証
- HTTPS暗号化通信
- 一時的認証情報（sessionToken）対応
- 署名付きURLによる一時的アクセス許可

## 備考

- S3互換サービス（MinIO、Cloudflare R2、DigitalOcean Spaces等）に対応
- 環境変数からの認証情報自動読み込み
- Blob APIとの統合（S3FileはBlobを継承）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、S3Clientとその関連構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | S3Client.classes.ts | `src/bun.js/api/S3Client.classes.ts` | JSから公開されるメソッド定義 |
| 1-2 | S3Client.zig | `src/bun.js/webcore/S3Client.zig` | S3Client構造体とメソッド |

**読解のコツ**: classes.tsでメソッドシグネチャを確認し、Zigの対応メソッドを読む。

#### Step 2: エントリーポイントを理解する

S3Clientのコンストラクタと各メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | S3Client.zig | `src/bun.js/webcore/S3Client.zig` | constructor（93-106行目） |

**主要処理フロー**:
1. **93-106行目**: constructor()で認証情報とオプション取得
2. **128-142行目**: file()メソッドでS3Fileを生成
3. **144-160行目**: presign()で署名付きURL生成
4. **213-233行目**: write()でファイル書き込み

#### Step 3: ファイル操作を理解する

S3Fileの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | S3File.zig | `src/bun.js/webcore/S3File.zig` | S3File構造体 |

**主要処理フロー**:
- **exists/size/stat**: S3BlobStatTaskで非同期メタデータ取得
- **write**: Blob.writeFileInternalでアップロード
- **unlink**: DELETEリクエスト送信

#### Step 4: 認証情報管理を理解する

S3Credentialsの管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | S3Client.zig | `src/bun.js/webcore/S3Client.zig` | writeFormatCredentials（1-77行目） |

**主要処理フロー**:
- **1-77行目**: 認証情報のフォーマット出力（デバッグ用、機密情報はREDACTED）
- **87-91行目**: credentials、options、acl、storage_class等の保持

### プログラム呼び出し階層図

```
Bun.s3 / S3Client (JavaScript API)
    │
    ├─ S3Client (S3Client.zig)
    │      ├─ constructor()
    │      ├─ file() → S3File
    │      ├─ presign()
    │      ├─ exists()
    │      ├─ size()
    │      ├─ stat()
    │      ├─ write()
    │      ├─ unlink()
    │      └─ listObjects()
    │
    ├─ S3File (S3File.zig)
    │      ├─ Blob継承
    │      ├─ S3BlobStatTask
    │      └─ store → S3Store
    │
    └─ S3Credentials (bun.S3)
           ├─ accessKeyId
           ├─ secretAccessKey
           ├─ sessionToken
           ├─ region
           └─ endpoint
```

### データフロー図

```
[入力]                    [処理]                         [出力]

認証情報（env/option）───▶ S3Credentials.get() ─────▶ Credentials
                                │
ファイルパス ─────────────▶ S3File.construct() ─────▶ Blob
                                │
                                ▼
                         AWS Signature V4 ───────────▶ 署名付きリクエスト
                                │
                                ▼
                         HTTP Client ────────────────▶ S3 API呼び出し
                                │
                                ▼
                         レスポンスパース ───────────▶ 結果オブジェクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| S3Client.zig | `src/bun.js/webcore/S3Client.zig` | ソース | S3クライアント実装 |
| S3Client.classes.ts | `src/bun.js/api/S3Client.classes.ts` | ソース | JSバインディング定義 |
| S3File.zig | `src/bun.js/webcore/S3File.zig` | ソース | S3ファイル実装 |
| S3Stat.zig | `src/bun.js/webcore/S3Stat.zig` | ソース | S3オブジェクト統計 |
| S3Stat.classes.ts | `src/bun.js/api/S3Stat.classes.ts` | ソース | S3Stat JSバインディング |
