# 機能設計書 66-Bun.cc

## 概要

本ドキュメントは、BunランタイムのCコンパイラ統合機能（`Bun.cc`）の設計仕様を記載する。

### 本機能の処理概要

`Bun.cc`は、TCC（Tiny C Compiler）を統合し、Cソースコードをランタイムでコンパイルしてbun:ffiと連携する機能を提供する。外部コンパイラなしにCコードをJavaScriptから直接利用可能にする。

**業務上の目的・背景**：ネイティブ拡張の開発では、従来は事前にCコードをコンパイルする必要があった。Bun.ccにより、開発サイクルを短縮し、ポータブルなネイティブ拡張を実現する。

**機能の利用シーン**：
- 開発時のCコード即時コンパイル・テスト
- ポータブルなネイティブ拡張の配布
- パフォーマンスクリティカルなコードのランタイム最適化
- システムAPI呼び出しの簡易実装

**主要な処理内容**：
1. Cソースコードのコンパイル
2. コンパイルしたコードの即時実行
3. bun:ffiとの統合によるシンボル公開
4. インクルードディレクトリ、ライブラリ、定義の設定

**関連システム・外部連携**：bun:ffi、TCC（Tiny C Compiler、組み込み）

**権限による制御**：ファイルシステムアクセス権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI専用であり、直接関連する画面はない |

## 機能種別

システム連携 / コンパイル / ネイティブ連携

## 入力仕様

### 入力パラメータ

#### Bun.cc オプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source | string | Yes | Cソースコード、またはファイルパス | - |
| symbols | object | Yes | エクスポートするシンボル定義 | - |
| libraries | string[] | No | リンクするライブラリ | - |
| library_dirs | string[] | No | ライブラリ検索ディレクトリ | - |
| include_dirs | string[] | No | インクルードディレクトリ | - |
| define | object | No | プリプロセッサ定義 | - |
| flags | string | No | コンパイラフラグ | - |

### 入力データソース

- Cソースコード（文字列またはファイル）
- コンパイラオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| symbols | object | bun:ffi形式の呼び出し可能関数 |

### 出力先

- JavaScript関数オブジェクト

## 処理フロー

### 処理シーケンス

```
1. ソースコード取得
   └─ 文字列またはファイルから読み込み
2. TCC状態初期化
   └─ コンパイラ状態の作成
3. オプション設定
   └─ インクルード、ライブラリ、定義の設定
4. コンパイル
   └─ Cコードのコンパイル
5. シンボル解決
   └─ 定義されたシンボルのアドレス取得
6. FFI統合
   └─ bun:ffi形式のラッパー生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Cソース読み込み]
    B --> C[TCC状態初期化]
    C --> D[オプション設定]
    D --> E[コンパイル]
    E --> F{コンパイル成功?}
    F -->|No| G[コンパイルエラー]
    F -->|Yes| H[シンボル解決]
    H --> I[FFIラッパー生成]
    I --> J[結果返却]
    J --> K[終了]
    G --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | TCC制限 | 一部のC言語機能はTCCでサポートされない | 常時 |
| BR-002 | シンボル注入 | 標準C関数（printf等）はTCCに注入される | 常時 |
| BR-003 | JIT保護 | ARM Macでは一時的にJIT保護を無効化 | ARM Mac環境 |

### 計算ロジック

特になし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CompilationError | コンパイルエラー | Cコード構文エラー | コードを修正 |
| Error | シンボルエラー | シンボルが見つからない | シンボル名を確認 |

### リトライ仕様

特になし。

## パフォーマンス要件

- 小規模コードの高速コンパイル（TCCの特性）
- コンパイル結果のメモリ内保持

## セキュリティ考慮事項

- 任意コード実行のため信頼できるコードのみ使用
- JIT保護の一時的無効化による影響

## 備考

- TCC（Tiny C Compiler）を使用
- 完全なC99/C11サポートではない
- システム依存のヘッダファイルは別途設定が必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ffi.zig | `src/bun.js/api/ffi.zig` | CompileC構造体 |

#### Step 2: コンパイル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ffi.zig | `src/bun.js/api/ffi.zig` | CompileC.Source、stdarg注入 |

### プログラム呼び出し階層図

```
Bun.cc
    │
    ├─ CompileC (ffi.zig)
    │      ├─ source（Cソース）
    │      ├─ include_dirs
    │      ├─ library_dirs
    │      └─ define
    │
    ├─ TCC.State
    │      ├─ addFile()
    │      ├─ addSymbolsComptime()
    │      └─ compile()
    │
    └─ FFI統合
           └─ bun:ffi形式のシンボル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ffi.zig | `src/bun.js/api/ffi.zig` | ソース | FFI/CC統合実装 |
