# 機能設計書 67-Bun.Glob

## 概要

本ドキュメントは、Bunランタイムのファイルパターンマッチング機能（`Bun.Glob`）の設計仕様を記載する。

### 本機能の処理概要

`Bun.Glob`は、ファイルシステム上のファイルをGlobパターンで検索・マッチングする機能を提供する。ネイティブZig実装により、高速なディレクトリウォークとパターンマッチングを実現する。

**業務上の目的・背景**：ビルドツール、テストランナー、ファイル操作ツールなどでは、Globパターンによるファイル検索が頻繁に使用される。Node.jsのglob系パッケージはJavaScript実装のため性能面での制約があった。Bunのネイティブ実装により高速なファイル検索を提供する。

**機能の利用シーン**：
- ビルドシステムでのソースファイル収集
- テストファイルの検索
- 静的アセットの列挙
- ファイル整理・移動スクリプト
- コードベースの分析

**主要な処理内容**：
1. Globパターンのパース
2. ファイルシステムの再帰的走査
3. パターンマッチング
4. 結果の収集と返却（同期/非同期）

**関連システム・外部連携**：ファイルシステム

**権限による制御**：ファイルシステムアクセス権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI専用であり、直接関連する画面はない |

## 機能種別

ファイル操作 / パターンマッチング

## 入力仕様

### 入力パラメータ

#### Glob コンストラクタ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pattern | string | Yes | Globパターン | - |

#### scan/scanSync オプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| cwd | string | No | 検索開始ディレクトリ | 存在するディレクトリ |
| dot | boolean | No | ドットファイルを含める | - |
| absolute | boolean | No | 絶対パスで返却 | - |
| onlyFiles | boolean | No | ファイルのみ（デフォルト: true） | - |
| followSymlinks | boolean | No | シンボリックリンクを追跡 | - |
| throwErrorOnBrokenSymlink | boolean | No | 壊れたシンボリックリンクでエラー | - |

### 入力データソース

- Globパターン文字列
- ファイルシステム

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| scan結果 | AsyncIterator<string> | マッチしたパスのイテレータ |
| scanSync結果 | Iterator<string> | マッチしたパスのイテレータ（同期） |
| match結果 | boolean | パターンマッチ結果 |

### 出力先

- JavaScript文字列配列またはイテレータ

## 処理フロー

### 処理シーケンス

```
1. パターンパース
   └─ Globパターンを内部表現に変換
2. ディレクトリ走査
   └─ cwdから再帰的にファイルを列挙
3. パターンマッチング
   └─ 各ファイルパスとパターンを照合
4. 結果収集
   └─ マッチしたパスをイテレータで返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Glob作成]
    B --> C[パターンパース]
    C --> D{scan/scanSync/match?}
    D -->|scan| E[非同期ウォーク開始]
    D -->|scanSync| F[同期ウォーク開始]
    D -->|match| G[単一パスマッチング]
    E --> H[ディレクトリ読み込み]
    F --> H
    H --> I{エントリ処理}
    I -->|ファイル| J{パターンマッチ?}
    I -->|ディレクトリ| K{再帰?}
    J -->|Yes| L[結果に追加]
    J -->|No| I
    K -->|Yes| H
    K -->|No| I
    L --> I
    G --> M[マッチ結果返却]
    I -->|完了| N[結果返却]
    M --> O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ドットファイル除外 | dot: falseでドットファイルを除外（デフォルト） | dot未指定時 |
| BR-002 | ファイルのみ | onlyFiles: trueでディレクトリを除外（デフォルト） | onlyFiles未指定時 |
| BR-003 | シンボリックリンク | followSymlinks: falseでリンク先を追跡しない（デフォルト） | followSymlinks未指定時 |
| BR-004 | 相対パス | absolute: falseで相対パスを返却（デフォルト） | absolute未指定時 |

### 計算ロジック

- パターンマッチング: Globパターン構文（*, **, ?, [...]等）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Error | パターンエラー | 不正なGlobパターン | パターンを修正 |
| Error | パスエラー | cwdが長すぎる | パスを短縮 |
| Error | シンボリックエラー | 壊れたシンボリックリンク | リンクを修正またはオプション変更 |

### リトライ仕様

特になし。

## パフォーマンス要件

- ネイティブZig実装による高速ディレクトリウォーク
- イテレータベースでメモリ効率的
- パターンの事前コンパイル

## セキュリティ考慮事項

- ファイルシステムアクセス権限に依存
- シンボリックリンク追跡時のディレクトリ脱出に注意

## 備考

- Node.jsのglob、fast-glob互換を意識した設計
- Unicode正規化対応（pattern_codepoints）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | glob.zig | `src/bun.js/api/glob.zig` | Glob構造体、ScanOpts |

**主要処理フロー**:
- **1-11行目**: Glob構造体定義（pattern、pattern_codepoints）
- **12-124行目**: ScanOpts構造体とオプション解析

#### Step 2: ウォーク処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | glob.zig | `src/bun.js/api/glob.zig` | WalkTask |

**主要処理フロー**:
- **127-195行目**: WalkTask構造体と非同期処理
- **164-176行目**: walker.walk()でディレクトリ走査
- **178-189行目**: then()で結果をPromiseに変換

### プログラム呼び出し階層図

```
Bun.Glob
    │
    ├─ Glob (glob.zig)
    │      ├─ pattern
    │      ├─ pattern_codepoints
    │      └─ has_pending_activity
    │
    ├─ ScanOpts (glob.zig)
    │      ├─ cwd
    │      ├─ dot
    │      ├─ absolute
    │      ├─ only_files
    │      ├─ follow_symlinks
    │      └─ error_on_broken_symlinks
    │
    ├─ WalkTask (glob.zig)
    │      ├─ walker: GlobWalker
    │      └─ AsyncGlobWalkTask
    │
    └─ GlobWalker (glob.zig)
           └─ matchedPaths
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| glob.zig | `src/bun.js/api/glob.zig` | ソース | Glob API実装 |
| glob.zig | `src/glob.zig` | ソース | Globパターンパーサー |
| glob.ts | `src/js/internal/fs/glob.ts` | ソース | TypeScriptインターフェース |
