# 機能設計書 68-FileSystemRouter

## 概要

本ドキュメントは、Bunランタイムのファイルシステムベースルーティング機能（`FileSystemRouter`）の設計仕様を記載する。

### 本機能の処理概要

`FileSystemRouter`は、ファイルシステムの構造に基づいてURLルーティングを行う機能を提供する。Next.jsスタイルのファイルベースルーティングをネイティブ実装で高速に実現する。

**業務上の目的・背景**：モダンなWebフレームワークでは、ファイル配置に基づく自動ルーティングが一般的である。Next.jsなどのフレームワークではビルド時にルートを解析するが、Bunではランタイムで高速にルート解析を行うことで、開発体験を向上させる。

**機能の利用シーン**：
- ファイルベースルーティングのWebアプリケーション
- Next.js互換のルーティングシステム
- APIエンドポイントの自動検出
- 静的サイト生成のルート解析

**主要な処理内容**：
1. ディレクトリ構造の読み込み
2. ルートパターンの解析（動的ルート、キャッチオール等）
3. URLとファイルパスのマッチング
4. ルートパラメータの抽出

**関連システム・外部連携**：ファイルシステム

**権限による制御**：ファイルシステムアクセス権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI専用であり、直接関連する画面はない |

## 機能種別

ルーティング / ファイルシステム / Webフレームワーク

## 入力仕様

### 入力パラメータ

#### FileSystemRouter コンストラクタオプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dir | string | Yes | ルートディレクトリ | 存在するディレクトリ |
| style | string | Yes | ルーティングスタイル | "nextjs"のみ対応 |
| origin | string | No | ベースURL | - |
| assetPrefix | string | No | アセットのプレフィックス | - |
| fileExtensions | string[] | No | 対象ファイル拡張子 | デフォルト: tsx, jsx, ts, mjs, cjs, js |

### 入力データソース

- ファイルシステム（ディレクトリ構造）
- URLパス（マッチング対象）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| routes | object | ルート名とファイルパスのマッピング |
| match結果 | MatchedRoute | マッチしたルート情報 |

#### MatchedRoute プロパティ

| プロパティ名 | 型 | 説明 |
|-------------|-----|------|
| name | string | ルート名（例: /users/[id]） |
| filePath | string | 対応するファイルパス |
| pathname | string | マッチしたパス名 |
| params | object | 動的パラメータ |
| query | object | クエリパラメータ |
| kind | string | ルート種別（exact, dynamic, catch-all, optional-catch-all） |
| src | string | スクリプトソースパス |

### 出力先

- JavaScript オブジェクト

## 処理フロー

### 処理シーケンス

```
1. ルーター初期化
   └─ オプション検証（style: "nextjs"必須）
2. ディレクトリ読み込み
   └─ 指定ディレクトリを再帰的に走査
3. ルート登録
   └─ ファイル名からルートパターンを生成
4. マッチング（match呼び出し時）
   └─ URLパスとルートパターンを照合
5. パラメータ抽出
   └─ 動的セグメントから値を抽出
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[FileSystemRouter作成]
    B --> C[styleオプション確認]
    C --> D{style == "nextjs"?}
    D -->|No| E[エラー: nextjsのみ対応]
    D -->|Yes| F[ディレクトリ読み込み]
    F --> G[ルート登録]
    G --> H[ルーター準備完了]
    H --> I{match呼び出し?}
    I -->|Yes| J[URLパス解析]
    J --> K[ルートマッチング]
    K --> L{マッチあり?}
    L -->|Yes| M[MatchedRoute返却]
    L -->|No| N[null返却]
    I -->|No| O{reload呼び出し?}
    O -->|Yes| P[キャッシュクリア]
    P --> F
    E --> Q[終了]
    M --> Q
    N --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | Next.jsスタイル | [param]で動的パラメータ | style: "nextjs" |
| BR-002 | キャッチオール | [...slug]で残りパス全取得 | ファイル名に[...含む |
| BR-003 | オプショナルキャッチオール | [[...slug]]でオプショナル | ファイル名に[[...含む |
| BR-004 | 拡張子優先順位 | tsx > jsx > ts > mjs > cjs > js | 同名ファイル存在時 |

### 計算ロジック

- ルート種別判定
  - `[[...param]]` → optional-catch-all
  - `[...param]` → catch-all
  - `[param]` → dynamic
  - その他 → exact

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArguments | 引数エラー | オプション不正 | オプションを確認 |
| Error | スタイルエラー | style != "nextjs" | "nextjs"を指定 |
| Error | ディレクトリエラー | dirが見つからない | パスを確認 |

### リトライ仕様

特になし。

## パフォーマンス要件

- ネイティブZig実装による高速ルート解析
- ディレクトリ情報のキャッシュ
- reload()でキャッシュの明示的クリア可能

## セキュリティ考慮事項

- ファイルシステムアクセス権限に依存
- 禁止ディレクトリ（node_modules等）の自動除外

## 備考

- 現在Next.jsスタイルのみサポート
- 将来的に他のルーティングスタイル追加の可能性

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | filesystem_router.zig | `src/bun.js/api/filesystem_router.zig` | FileSystemRouter構造体 |
| 1-2 | filesystem_router.zig | `src/bun.js/api/filesystem_router.zig` | MatchedRoute構造体 |

**主要処理フロー**:
- **10-17行目**: FileSystemRouter構造体定義（origin、base_dir、router、arena等）
- **396-406行目**: MatchedRoute構造体定義（route、query_string_map、param_map等）

#### Step 2: コンストラクタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | filesystem_router.zig | `src/bun.js/api/filesystem_router.zig` | constructor |

**主要処理フロー**:
- **23-173行目**: コンストラクタ実装
- **41-47行目**: styleオプション検証（"nextjs"のみ対応）
- **49-67行目**: dirオプション処理
- **72-92行目**: fileExtensions処理
- **123-134行目**: Router初期化とルート読み込み

#### Step 3: マッチング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | filesystem_router.zig | `src/bun.js/api/filesystem_router.zig` | match |

**主要処理フロー**:
- **265-335行目**: match関数
- **276-293行目**: 入力パス処理（string、Request、Response対応）
- **306-318行目**: URLPathパースとルートマッチング
- **320-334行目**: MatchedRoute生成

#### Step 4: ルート種別判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | filesystem_router.zig | `src/bun.js/api/filesystem_router.zig` | KindEnum |

**主要処理フロー**:
- **503-521行目**: KindEnum定義
- **510-519行目**: ルート名からkind判定ロジック

### プログラム呼び出し階層図

```
FileSystemRouter
    │
    ├─ constructor (filesystem_router.zig)
    │      ├─ style検証 ("nextjs"のみ)
    │      ├─ dir解析
    │      ├─ fileExtensions設定
    │      └─ Router.init / loadRoutes
    │
    ├─ match (filesystem_router.zig)
    │      ├─ パス抽出（string/Request/Response）
    │      ├─ URLPath.parse
    │      ├─ router.routes.matchPageWithAllocator
    │      └─ MatchedRoute.init
    │
    ├─ reload (filesystem_router.zig)
    │      ├─ bustDirCache
    │      └─ Router再初期化
    │
    └─ MatchedRoute (filesystem_router.zig)
           ├─ name, filePath, pathname
           ├─ params, query
           ├─ kind (exact/dynamic/catch-all/optional-catch-all)
           └─ src (scriptSrc)
```

### データフロー図

```
[URLパス/Request/Response]
        │
        ▼
    ┌───────────┐
    │ match()   │
    └─────┬─────┘
          │
          ▼
    ┌───────────────┐
    │ URLPath.parse │
    └───────┬───────┘
            │
            ▼
    ┌──────────────────────┐
    │ matchPageWithAllocator│
    └──────────┬───────────┘
               │
               ▼
    ┌───────────────────┐
    │ MatchedRoute作成   │
    │ - name            │
    │ - filePath        │
    │ - params          │
    │ - query           │
    │ - kind            │
    └───────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| filesystem_router.zig | `src/bun.js/api/filesystem_router.zig` | ソース | FileSystemRouter実装 |
| router.zig | `src/router.zig` | ソース | 内部Router実装 |
| URLPath.zig | `src/http/URLPath.zig` | ソース | URLパスパーサー |
| url.zig | `src/url.zig` | ソース | QueryStringMap等 |
