# 機能設計書 70-Bun.color

## 概要

本ドキュメントは、Bunランタイムの色操作ユーティリティ機能（`Bun.color`）の設計仕様を記載する。

### 本機能の処理概要

`Bun.color`は、様々な形式の色を解析し、異なる出力フォーマットに変換する機能を提供する。CSS色、数値、RGB配列、オブジェクト形式など多様な入力を受け付け、ANSI、CSS、HEX、RGB、HSL、LAB等の形式で出力する。

**業務上の目的・背景**：CLIツールやターミナル出力では、色の扱いが重要となる。特にANSIエスケープシーケンスによる色付けは、ユーザー体験向上に寄与する。また、Web開発では色形式の変換が頻繁に必要となる。統一されたAPIで多様な色形式を扱えることで、開発効率を向上させる。

**機能の利用シーン**：
- CLIツールの色付き出力
- CSS色のフォーマット変換
- 色空間の変換（RGB → HSL、LAB等）
- ターミナルの色深度に応じた最適化
- Webアプリケーションの色処理

**主要な処理内容**：
1. 入力色のパース（CSS、数値、配列、オブジェクト）
2. 内部色空間（RGBA）への変換
3. 指定フォーマットへの出力変換
4. ターミナル色深度の自動検出（ANSI出力時）

**関連システム・外部連携**：CSSパーサー（組み込み）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI専用であり、直接関連する画面はない |

## 機能種別

ユーティリティ / 色変換 / CSS

## 入力仕様

### 入力パラメータ

#### Bun.color() 関数

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | string/number/array/object | Yes | 色の入力 | - |
| format | string | No | 出力フォーマット | OutputColorFormat |

#### input の形式

| 形式 | 例 | 説明 |
|------|-----|------|
| CSS文字列 | "red", "#ff0000", "rgb(255,0,0)" | CSS色構文 |
| 数値 | 0xff0000 | 24ビット整数 |
| 配列[3] | [255, 0, 0] | [R, G, B] |
| 配列[4] | [255, 0, 0, 255] | [R, G, B, A] |
| オブジェクト | {r: 255, g: 0, b: 0} | r, g, b (, a) |

#### format の選択肢

| フォーマット | 出力例 | 説明 |
|-------------|-------|------|
| css | "red" | CSS標準出力 |
| hex | "#ff0000" | 16進数小文字 |
| HEX | "#FF0000" | 16進数大文字 |
| rgb | "rgb(255, 0, 0)" | RGB関数形式 |
| rgba | "rgba(255, 0, 0, 1)" | RGBA関数形式 |
| hsl | "hsl(0, 100, 50)" | HSL形式 |
| lab | "lab(53.23, 80.11, 67.22)" | LAB形式 |
| number | 16711680 | 整数値 |
| ansi | ESC[38;5;196m | ターミナル色深度に応じた最適 |
| ansi-16 | ESC[38;5;9m | 16色ANSI |
| ansi-256 | ESC[38;5;196m | 256色ANSI |
| ansi-16m | ESC[38;2;255;0;0m | TrueColor ANSI |
| [rgb] | [255, 0, 0] | 配列形式 |
| [rgba] | [255, 0, 0, 255] | 配列形式+alpha |
| {rgb} | {r: 255, g: 0, b: 0} | オブジェクト形式 |
| {rgba} | {r: 255, g: 0, b: 0, a: 1} | オブジェクト形式+alpha |

### 入力データソース

- 色データ（各種形式）
- フォーマット指定文字列

## 出力仕様

### 出力データ

| フォーマット | 戻り値の型 | 説明 |
|-------------|-----------|------|
| css, hex, HEX, rgb, rgba, hsl, lab | string | 文字列形式 |
| number | number | 整数値 |
| ansi, ansi-16, ansi-256, ansi-16m | string | ANSIエスケープシーケンス |
| [rgb], [rgba] | number[] | 配列形式 |
| {rgb}, {rgba} | object | オブジェクト形式 |

### 出力先

- JavaScript値（文字列、数値、配列、オブジェクト）

## 処理フロー

### 処理シーケンス

```
1. 入力パース
   ├─ 数値の場合: ビット分解
   ├─ 配列の場合: R, G, B (, A) 抽出
   ├─ オブジェクトの場合: r, g, b (, a) プロパティ抽出
   └─ 文字列の場合: CSSパーサーで解析
2. 内部色表現への変換
   └─ CssColor / RGBA形式に統一
3. フォーマット解決
   ├─ ansiの場合: ターミナル色深度を検出
   └─ その他: 指定フォーマット使用
4. 出力変換
   └─ 指定フォーマットに応じた変換・出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{入力タイプ?}
    B -->|number| C[ビット分解でRGBA]
    B -->|array| D[配列からRGBA]
    B -->|object| E[プロパティからRGBA]
    B -->|string| F[CSSパーサー]
    C --> G[CssColor生成]
    D --> G
    E --> G
    F --> G
    G --> H{formatパラメータ?}
    H -->|ansi| I[ターミナル色深度検出]
    I --> J{色深度?}
    J -->|none| K[空文字列返却]
    J -->|16| L[ansi_16変換]
    J -->|256| M[ansi_256変換]
    J -->|16m| N[ansi_16m変換]
    H -->|css| O[CSSプリンタで出力]
    H -->|hex/HEX| P[16進数文字列生成]
    H -->|rgb/rgba| Q[rgb関数形式生成]
    H -->|hsl| R[HSL変換・出力]
    H -->|lab| S[LAB変換・出力]
    H -->|number| T[整数値返却]
    H -->|配列/オブジェクト| U[配列/オブジェクト生成]
    K --> V[終了]
    L --> V
    M --> V
    N --> V
    O --> V
    P --> V
    Q --> V
    R --> V
    S --> V
    T --> V
    U --> V
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | CSS色値範囲 | RGB各値は0-255にクランプ | 常時 |
| BR-002 | デフォルトフォーマット | format未指定時はcss | format省略時 |
| BR-003 | ansi自動検出 | ansi指定時はターミナル色深度を自動検出 | format: "ansi" |
| BR-004 | 無効色 | パース失敗時はnull返却 | パースエラー時 |

### 計算ロジック

- **Ansi256変換**: RGBからtmux互換の256色パレットインデックスへの変換
- **Ansi16変換**: 256色からさらに16色へのマッピング
- **HSL変換**: RGB → HSL色空間変換
- **LAB変換**: RGB → SRGB → LAB色空間変換

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| null | パースエラー | 不正な色入力 | 入力形式を確認 |
| Error | 引数エラー | inputがundefined | 値を指定 |
| Error | 配列長エラー | 配列長が3または4以外 | 正しい長さの配列を使用 |
| Error | フォーマットエラー | 不正なformat | 有効なフォーマットを指定 |

### リトライ仕様

特になし。

## パフォーマンス要件

- 組み込みCSSパーサーによる高速パース
- 色空間変換の最適化
- ANSIコード生成の事前計算テーブル

## セキュリティ考慮事項

- 入力値のサニタイズ（範囲クランプ）
- ターミナル制御文字の安全な生成

## 備考

- CSS Color Level 4仕様に準拠したパース
- tmux互換のANSI 256色変換アルゴリズム

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 出力フォーマットを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | color_js.zig | `src/css/values/color_js.zig` | OutputColorFormat |

**主要処理フロー**:
- **1-45行目**: OutputColorFormat enum定義（ansi, css, hex, rgb等）
- **19-44行目**: フォーマット文字列からenumへのマッピング

#### Step 2: メイン関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | color_js.zig | `src/css/values/color_js.zig` | jsFunctionColor |

**主要処理フロー**:
- **134-429行目**: jsFunctionColor関数
- **148-158行目**: formatパラメータ解析
- **162-226行目**: 入力タイプ判定とパース
  - **163-174行目**: number入力のビット分解
  - **175-193行目**: 配列入力の処理
  - **194-219行目**: オブジェクト入力の処理
  - **221-226行目**: 文字列入力のCSSパース

#### Step 3: 出力変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | color_js.zig | `src/css/values/color_js.zig` | format別処理 |

**主要処理フロー**:
- **237-244行目**: ansiフォーマット時の色深度自動検出
- **246-405行目**: フォーマット別の出力処理
  - **279-309行目**: オブジェクト/配列出力（{rgb}, [rgba]等）
  - **310-316行目**: number出力
  - **317-328行目**: hex/HEX出力
  - **323-328行目**: rgb/rgba出力
  - **329-339行目**: ansi_16出力
  - **340-358行目**: ansi_16m出力
  - **359-364行目**: ansi_256出力
  - **369-401行目**: hsl/lab出力

#### Step 4: ANSI 256色変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | color_js.zig | `src/css/values/color_js.zig` | Ansi256 |

**主要処理フロー**:
- **57-132行目**: Ansi256構造体
- **60-70行目**: sqdist, to6Cube関数（色距離計算）
- **72-91行目**: get関数（RGB→256色インデックス変換）
- **93-110行目**: table_256（256→16色マッピングテーブル）
- **119-131行目**: from関数（ANSIエスケープシーケンス生成）

### プログラム呼び出し階層図

```
Bun.color
    │
    ├─ jsFunctionColor (color_js.zig)
    │      │
    │      ├─ 入力パース
    │      │      ├─ number: ビット分解
    │      │      ├─ array: 配列抽出
    │      │      ├─ object: プロパティ抽出
    │      │      └─ string: css.CssColor.parse
    │      │
    │      ├─ フォーマット解決
    │      │      └─ ansi時: colorDepth検出
    │      │
    │      └─ 出力変換
    │             ├─ css: css.Printer
    │             ├─ hex/HEX: bun.fmt.hexInt
    │             ├─ rgb/rgba: String.createFormat
    │             ├─ hsl: HSL変換
    │             ├─ lab: LAB変換
    │             ├─ number: 整数値
    │             ├─ [rgb]/[rgba]: 配列作成
    │             ├─ {rgb}/{rgba}: オブジェクト作成
    │             └─ ansi_*: Ansi256変換
    │
    └─ Ansi256 (color_js.zig)
           ├─ get: RGB→256色インデックス
           ├─ get16: 256色→16色変換
           └─ from: ANSIエスケープ生成
```

### データフロー図

```
[入力: string/number/array/object]
              │
              ▼
    ┌─────────────────────┐
    │ 入力タイプ判定       │
    └──────────┬──────────┘
               │
    ┌──────────┴──────────┐
    │                     │
    ▼                     ▼
┌─────────┐        ┌───────────┐
│直接変換 │        │CSSパーサー│
│(num/arr/│        │(string)   │
│obj)     │        └─────┬─────┘
└────┬────┘              │
     │                   │
     └─────────┬─────────┘
               │
               ▼
    ┌─────────────────────┐
    │ CssColor / RGBA     │
    │ (内部色表現)        │
    └──────────┬──────────┘
               │
               ▼
    ┌─────────────────────┐
    │ フォーマット別変換   │
    └──────────┬──────────┘
               │
    ┌──────────┼──────────┐
    │          │          │
    ▼          ▼          ▼
┌──────┐ ┌─────────┐ ┌─────────┐
│string│ │number   │ │array/obj│
│出力  │ │出力     │ │出力     │
└──────┘ └─────────┘ └─────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| color_js.zig | `src/css/values/color_js.zig` | ソース | Bun.color実装 |
| color.zig | `src/css/values/color.zig` | ソース | 色空間定義（HSL, LAB, RGBA, SRGB） |
| css.zig | `src/css/` | ソース | CSSパーサー |
