# 機能設計書 8-bunfig.toml設定

## 概要

本ドキュメントは、Bunの動作をTOMLファイルで設定するbunfig.toml機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、bunfig.tomlファイルを通じてBunランタイムの動作をカスタマイズする設定機能を提供する。コマンドライン引数の代わりに設定ファイルで恒久的な設定を管理でき、プロジェクト固有の設定を共有できる。

**業務上の目的・背景**：プロジェクトごとに異なるBunの動作設定（ログレベル、インストールオプション、テスト設定等）を一元管理し、チームメンバー間で設定を共有する必要がある。bunfig.tomlにより、これらの設定をバージョン管理下に置くことができる。

**機能の利用シーン**：npmレジストリのカスタマイズ、インストールオプションの設定、テスト設定、ログレベルの変更、環境変数設定のカスタマイズなど。

**主要な処理内容**：
1. bunfig.tomlファイルの検索と読み込み
2. TOML形式のパース
3. 設定値のバリデーション
4. コマンドごとの設定適用
5. コマンドライン引数との優先順位処理

**関連システム・外部連携**：TOMLパーサー、各種コマンド（run, test, install等）

**権限による制御**：ファイルシステムアクセス権限に基づく

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | run | 補助機能 | 設定ファイルからの実行オプション読み込み |

## 機能種別

設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| bunfig.toml | file | No | 設定ファイル | 有効なTOML形式 |
| --config | string | No | カスタム設定ファイルパス | 有効なファイルパス |

### 入力データソース

- bunfig.tomlファイル（カレントディレクトリまたは親ディレクトリ）
- コマンドライン引数（--config）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| config | object | パース済み設定オブジェクト |

### 出力先

- 各コマンドの実行コンテキスト

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル検索
   └─ カレントディレクトリから親方向にbunfig.tomlを探索
2. ファイル読み込み
   └─ TOMLファイルの内容を読み取り
3. TOMLパース
   └─ TOML形式をJSONオブジェクトに変換
4. バリデーション
   └─ 各設定値の型と範囲を検証
5. コマンド適用
   └─ 実行コマンドに応じた設定を適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[--config指定あり?]
    B -->|Yes| C[指定パスを使用]
    B -->|No| D[bunfig.toml探索]
    C --> E[ファイル読み込み]
    D --> E
    E --> F{ファイル存在?}
    F -->|No| G[デフォルト設定使用]
    F -->|Yes| H[TOMLパース]
    H --> I{パース成功?}
    I -->|No| J[エラー出力]
    I -->|Yes| K[バリデーション]
    K --> L{有効?}
    L -->|No| J
    L -->|Yes| M[設定適用]
    G --> N[終了]
    M --> N
    J --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 優先順位 | コマンドライン引数 > bunfig.toml > デフォルト | 設定適用時 |
| BR-02 | 検索順序 | カレントディレクトリから親方向に探索 | ファイル検索時 |
| BR-03 | コマンド固有設定 | [test]、[install]等のセクションでコマンド固有設定 | 設定読み込み時 |
| BR-04 | 環境変数無効化 | env = null または env = false で.env読み込み無効化 | env設定時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PARSE_ERROR | パースエラー | TOMLの構文が不正 | bunfig.tomlを修正 |
| INVALID_VALUE | 値エラー | 設定値が範囲外または型不正 | 正しい値を設定 |
| FILE_NOT_FOUND | ファイル未検出 | --configで指定したファイルが存在しない | パスを確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 設定ファイル読み込み: 5ms以内
- TOMLパース: 10ms以内

## セキュリティ考慮事項

- レジストリ認証情報はbunfig.tomlに含めず環境変数を使用
- bunfig.tomlは適切なファイル権限で保護

## 備考

bunfig.tomlはbun.lockbと同様にプロジェクトルートに配置するのが一般的。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bunfig.zig | `src/bunfig.zig` | Bunfig構造体とParser構造体で設定パースの仕組みを理解 |

**読解のコツ**: OfflineMode enumでオフラインモード設定を理解。Prefer map でoffline/latest/onlineの文字列マッピングを確認。

#### Step 2: パーサーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bunfig.zig | `src/bunfig.zig` | Parser構造体のparse()メソッドで設定パース処理を理解 |

**主要処理フロー**:
1. **7-17行目**: Bunfig.OfflineModeとPrefer map定義
2. **19-43行目**: Parser構造体でパーサーの基本構造
3. **45-64行目**: parseRegistryURLString()でレジストリURL解析
4. **66-107行目**: parseRegistryObject()/parseRegistry()でレジストリ設定解析

#### Step 3: 各設定項目を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bunfig.zig | `src/bunfig.zig` | parse()メソッド内の各設定項目処理 |

**主要処理フロー**:
- **109-123行目**: loadLogLevel()でログレベル設定
- **125-149行目**: loadPreload()でプリロードスクリプト設定
- **151-186行目**: loadEnvConfig()で環境変数設定
- **188-300行目以降**: parse()で各種設定項目を処理
  - define、origin、env、serve、preload、telemetry、smol、testセクション

### プログラム呼び出し階層図

```
Bunコマンド起動
    │
    ├─ bunfig.toml検索
    │
    ├─ bunfig.zig::Parser.parse()
    │      ├─ TOMLパース（js_ast.Expr経由）
    │      ├─ loadLogLevel()
    │      ├─ loadPreload()
    │      ├─ loadEnvConfig()
    │      └─ 各セクション処理
    │
    └─ Command.Context
           └─ 設定適用
```

### データフロー図

```
[入力]               [処理]                    [出力]

bunfig.toml ───▶ TOMLパーサー ───▶ js_ast.Expr
                       │
                       ▼
              Parser.parse() ───▶ api.TransformOptions
                       │
                       ▼
              Command.Context ───▶ 各コマンドへ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bunfig.zig | `src/bunfig.zig` | ソース | bunfig.tomlパーサーメイン実装 |
| js_ast.zig | `src/js_ast.zig` | ソース | 式表現（TOMLパース結果） |
| cli.zig | `src/cli.zig` | ソース | コマンドコンテキスト |
| api.zig | `src/api.zig` | ソース | TransformOptions定義 |
