# 機能設計書 86-JSONC

## 概要

本ドキュメントは、BunランタイムにおけるJSONCパーサー機能の設計を記述するものである。JSONCはJSON with Comments（コメント付きJSON）であり、特にTypeScriptの設定ファイル（tsconfig.json）で使用される形式である。

### 本機能の処理概要

JSONC機能は、コメントを含むJSON形式のデータをパースする機能を提供する。シリアライズ（stringify）機能は提供しない。

**業務上の目的・背景**：TypeScriptプロジェクトではtsconfig.jsonが必須であり、このファイルはJSONC形式（コメント付きJSON）で記述される。Bunがネイティブでtsconfig.jsonを処理するためにJSONCパーサーが必要であり、これをユーザーAPIとしても公開している。Visual Studio Codeでもsettings.jsonなどでJSONC形式が使用されており、広く普及している形式である。

**機能の利用シーン**：
- tsconfig.jsonの読み込みと解析
- VS Code設定ファイルの処理
- コメント付きの設定ファイル全般の解析
- ビルドツールの設定読み込み

**主要な処理内容**：
1. JSONC文字列のパース（parse）
2. 行コメント（//）のスキップ
3. ブロックコメント（/* */）のスキップ
4. 末尾カンマの許容
5. AST生成とJavaScript値への変換

**関連システム・外部連携**：Bunの内部JSONパーサー（parseTSConfig）を使用。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | APIとして利用 |

## 機能種別

パーサー / データ変換

## 入力仕様

### 入力パラメータ（JSONC.parse）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| text | string | Yes | パース対象テキスト | JSONC形式であること |

### 入力データソース

JavaScript API呼び出しを通じて提供される文字列。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| value | any | パース結果（オブジェクト/配列/プリミティブ） |

### 出力先

JavaScript呼び出し元への戻り値。

## 処理フロー

### 処理シーケンス

```
1. JSONC.parse(text)の呼び出し
   └─ 入力文字列の取得
2. ASTメモリアロケータの初期化
   └─ bun.ArenaAllocatorの使用
3. parseTSConfigでパース
   └─ ast.Exprツリーの生成
4. toJSでJavaScript値に変換
   └─ 再帰的な値変換
5. 結果の返却
```

### フローチャート

```mermaid
flowchart TD
    A[JSONC.parse呼び出し] --> B[入力文字列取得]
    B --> C[ArenaAllocator初期化]
    C --> D[Log初期化]
    D --> E[parseTSConfig]
    E --> F{パース成功?}
    F -->|Yes| G[toJS変換]
    F -->|No| H[エラーログをJSに変換]
    G --> I[JSValue返却]
    H --> J[エラー返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | parseのみ提供 | stringifyは提供しない | - |
| BR-02 | コメント除去 | //と/* */コメントを除去 | parse時 |
| BR-03 | 末尾カンマ許容 | 配列・オブジェクトの末尾カンマを許容 | parse時 |
| BR-04 | tsconfig互換 | TypeScriptのtsconfig.json形式と互換 | parse時 |

### 計算ロジック

特になし。

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArguments | 引数エラー | 空/undefined/null入力 | 有効な文字列を渡す |
| SyntaxError | 構文エラー | 不正なJSONC構文 | 構文を確認 |
| StackOverflow | スタックエラー | 深いネスト | データ構造を見直す |

### リトライ仕様

パースエラー時は自動リトライなし。

## トランザクション仕様

該当なし

## パフォーマンス要件

- ArenaAllocatorによる効率的なメモリ管理
- Logオブジェクトでエラー情報を蓄積

## セキュリティ考慮事項

- 巨大ファイルのパース時のリソース消費に注意
- スタックオーバーフロー保護あり

## 備考

Bunはbun:jsoncとしてモジュールをエクスポート。JSON5とは異なり、シリアライズ機能は提供しない（コメントを保持したシリアライズが困難なため）。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JSONC処理の中心となるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JSONCObject.zig | `src/bun.js/api/JSONCObject.zig` | create関数、parse関数 |

**読解のコツ**:
- **1-16行目**: create関数でparseのみをエクスポート（stringifyは提供しない）
- **56-64行目**: @importでbun、ast、logger、jsonモジュールを取得

#### Step 2: parse関数を理解する

JSONC文字列のパース処理を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JSONCObject.zig | `src/bun.js/api/JSONCObject.zig` | `parse`関数 |

**主要処理フロー**:
1. **18-54行目**: parse関数全体
2. **22-28行目**: ArenaAllocator初期化とASTメモリアロケータ設定
3. **30-31行目**: Log初期化（エラーメッセージ蓄積用）
4. **37-38行目**: 入力文字列のスライス取得
5. **40-45行目**: parseTSConfigでJSONCをパース
6. **47-53行目**: toJSでJavaScript値に変換

#### Step 3: 内部パーサーとの連携を理解する

bun.interchange.jsonのparseTSConfig関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | json.zig | `src/bun/interchange/json/` | parseTSConfig関数 |

### プログラム呼び出し階層図

```
JSONC.parse() (JavaScript)
    │
    └─ parse() (Zig, lines 18-54)
           │
           ├─ ArenaAllocator.init() - メモリ管理
           │
           ├─ Log.init() - エラーログ
           │
           ├─ input_value.toSlice() - 入力取得
           │
           ├─ json.parseTSConfig() - JSONC→AST (line 40)
           │      │
           │      └─ コメント除去、末尾カンマ処理
           │
           └─ parse_result.toJS() - AST→JSValue (line 47)
```

### データフロー図

```
[入力]               [処理]                    [出力]

JSONC text      ───▶ parseTSConfig          ───▶ ast.Expr
(コメント付き)        │
                     ├─ コメント除去
                     └─ 末尾カンマ処理

ast.Expr        ───▶ toJS                   ───▶ JSValue
                     (再帰変換)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JSONCObject.zig | `src/bun.js/api/JSONCObject.zig` | ソース | JSONC APIのメイン実装 |
| json.zig | `src/bun/interchange/json/` | ソース | JSONパーサー本体 |
| logger.zig | `src/logger.zig` | ソース | ログ/エラー管理 |
