# 機能設計書 87-node:fs

## 概要

本ドキュメントは、Bunランタイムにおけるnode:fs（ファイルシステム操作）モジュールの設計を記述するものである。Node.jsのfsモジュールと互換性のあるファイル操作APIを提供する。

### 本機能の処理概要

node:fs機能は、ファイルの読み書き、ディレクトリ操作、ファイル情報取得など、ファイルシステムに対する各種操作を提供するNode.js互換モジュールである。

**業務上の目的・背景**：サーバーサイドJavaScriptアプリケーションでは、ファイル操作は最も基本的かつ頻繁に使用される機能である。Node.jsのfsモジュールは広く使われており、既存のNode.jsアプリケーションをBunで実行するためには完全な互換性が必要である。Bunはこの互換性を提供しつつ、パフォーマンスの最適化も行っている。

**機能の利用シーン**：
- 設定ファイルの読み込み
- ログファイルへの書き込み
- ユーザーアップロードファイルの保存
- 一時ファイルの作成と削除
- ディレクトリの走査と管理
- ファイル監視（watch）

**主要な処理内容**：
1. ファイル読み取り（readFile, readFileSync, read等）
2. ファイル書き込み（writeFile, writeFileSync, write等）
3. ディレクトリ操作（mkdir, readdir, rmdir等）
4. ファイル情報取得（stat, lstat, fstat等）
5. ファイル操作（rename, unlink, copy等）
6. シンボリックリンク操作（symlink, readlink等）
7. ファイル監視（watch, watchFile）
8. ストリーム（createReadStream, createWriteStream）

**関連システム・外部連携**：OS固有のファイルシステムAPI（POSIX、Windows）。Windowsではlibuv経由で一部操作を実行。

**権限による制御**：OSのファイルシステム権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | APIとして利用 |

## 機能種別

ファイルシステム操作 / Node.js互換

## 入力仕様

### 主要入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| path | string/Buffer/URL | Yes | 操作対象のパス | 有効なパスであること |
| data | string/Buffer | Yes (write系) | 書き込みデータ | - |
| options | object | No | エンコーディング、フラグ等 | - |
| callback | function | Yes (非同期) | 完了コールバック | 関数であること |

### 入力データソース

JavaScript API呼び出し、ファイルパス指定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| data | Buffer/string | 読み取ったデータ |
| stats | Stats | ファイル情報オブジェクト |
| files | string[] | ディレクトリ内のファイル一覧 |
| fd | number | ファイルディスクリプタ |

### 出力先

JavaScript呼び出し元への戻り値/コールバック/Promise。

## 処理フロー

### 処理シーケンス（非同期API）

```
1. fs.readFile(path, options, callback)の呼び出し
   └─ Arguments.ReadFile構造体でパラメータ解析
2. 非同期タスクの作成
   └─ NewAsyncFSTaskでタスク生成
3. WorkPoolでの実行
   └─ スレッドプールでファイル操作実行
4. 結果の返却
   └─ eventLoop経由でコールバック呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[fs.* API呼び出し] --> B{同期/非同期?}
    B -->|同期| C[NodeFS.*Sync実行]
    B -->|非同期| D[AsyncFSTask作成]
    C --> E[システムコール実行]
    D --> F[WorkPool.schedule]
    F --> G[スレッドプールで実行]
    G --> H[eventLoop.enqueueTask]
    H --> I[コールバック/Promise解決]
    E --> J[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Node.js互換 | Node.js fsモジュールのAPIと互換 | 全API |
| BR-02 | 非同期優先 | 非同期APIはスレッドプールで実行 | 非同期API |
| BR-03 | デフォルト権限 | 0o666（rw-rw-rw-）をデフォルト | ファイル作成時 |
| BR-04 | Windows対応 | libuv経由でWindows対応 | Windows環境 |

### 計算ロジック

ファイル権限計算：default_permission = IRUSR | IWUSR | IRGRP | IWGRP | IROTH | IWOTH

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル不在 | ファイルが存在しない | パスを確認 |
| EACCES | 権限エラー | アクセス権限がない | 権限を確認 |
| EEXIST | 既存エラー | ファイルが既に存在 | フラグを確認 |
| EISDIR | ディレクトリ | ファイル操作をディレクトリに | パスを確認 |

### リトライ仕様

自動リトライなし（アプリケーション側で実装）。

## トランザクション仕様

該当なし（個別ファイル操作は原子的でない）

## パフォーマンス要件

- WorkPoolによる非同期操作のスレッドプール化
- AbortSignal対応（readFile, writeFile）
- 大規模ファイル対応のストリーミング

## セキュリティ考慮事項

- パストラバーサル攻撃への注意（アプリケーション側）
- シンボリックリンク追跡の注意
- 一時ファイル作成時の競合状態

## 備考

fs/promisesも提供。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

node:fs処理の中心となるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node_fs.zig | `src/bun.js/node/node_fs.zig` | Flavor enum（sync/async）、Async構造体 |

**読解のコツ**:
- **23行目**: Flavor enum（sync, async）の定義
- **25-66行目**: Async構造体で各非同期関数を定義
- **9-17行目**: default_permission定数の定義

#### Step 2: 非同期タスク構造を理解する

非同期ファイル操作の実行方式を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | node_fs.zig | `src/bun.js/node/node_fs.zig` | NewAsyncFSTask、NewUVFSRequest |

**主要処理フロー**:
1. **336-442行目**: NewAsyncFSTask関数（POSIXおよびWindows非UV操作用）
2. **114-334行目**: NewUVFSRequest関数（Windows UV操作用）
3. **356-374行目**: create関数でタスク生成とWorkPoolスケジュール
4. **376-388行目**: workPoolCallbackでスレッドプール実行

#### Step 3: 個別操作の実装を理解する

具体的なファイル操作の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node_fs_binding.zig | `src/bun.js/node/node_fs_binding.zig` | Binding構造体 |

### プログラム呼び出し階層図

```
fs.readFile() (JavaScript)
    │
    └─ Async.readFile.create() (Zig, lines 336-374)
           │
           ├─ bun.new(Task, ...) - タスク作成
           ├─ args.toThreadSafe() - 引数をスレッドセーフに
           └─ jsc.WorkPool.schedule() - スレッドプールにスケジュール
                  │
                  └─ workPoolCallback() (lines 376-388)
                         │
                         ├─ NodeFS.readFile() - 実際のファイル読み取り
                         └─ eventLoop.enqueueTaskConcurrent() - 結果通知
                                │
                                └─ runFromJSThread() - コールバック実行
```

### データフロー図

```
[入力]               [処理]                    [出力]

path, options   ───▶ Arguments解析          ───▶ Arguments構造体
(JavaScript)

Arguments       ───▶ AsyncFSTask            ───▶ WorkPool
                     create()

システムコール  ◀─── NodeFS.*()             ───▶ bun.sys.Maybe(Result)
結果

Promise/       ◀─── runFromJSThread        ───▶ JSValue
callback                (結果変換)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node_fs.zig | `src/bun.js/node/node_fs.zig` | ソース | メイン実装、非同期タスク |
| node_fs_binding.zig | `src/bun.js/node/node_fs_binding.zig` | ソース | JSバインディング |
| node_fs_constant.zig | `src/bun.js/node/node_fs_constant.zig` | ソース | 定数定義 |
| node_fs_watcher.zig | `src/bun.js/node/node_fs_watcher.zig` | ソース | ファイル監視 |
| node_fs_stat_watcher.zig | `src/bun.js/node/node_fs_stat_watcher.zig` | ソース | Stat監視 |
| fs.ts | `src/js/node/fs.ts` | ソース | JavaScript側実装 |
