# 機能設計書 88-node:path

## 概要

本ドキュメントは、Bunランタイムにおけるnode:path（パス操作ユーティリティ）モジュールの設計を記述するものである。Node.jsのpathモジュールと互換性のあるパス操作APIを提供する。

### 本機能の処理概要

node:path機能は、ファイルパスの解析、結合、正規化などのパス文字列操作を提供するNode.js互換モジュールである。POSIX形式とWindows形式の両方に対応。

**業務上の目的・背景**：ファイルシステム操作を行うアプリケーションでは、パス文字列の操作が頻繁に必要となる。異なるOSでパス区切り文字が異なる（POSIX: /、Windows: \\）ため、クロスプラットフォーム対応のパス操作ユーティリティは必須である。Node.jsのpathモジュールは広く使われており、Bunでもこれと互換性のあるAPIを提供する。

**機能の利用シーン**：
- ファイルパスの結合（join）
- パスの正規化（normalize）
- 絶対パスの取得（resolve）
- パスの解析（parse）とフォーマット（format）
- ディレクトリ名/ファイル名/拡張子の取得
- 相対パスの計算（relative）

**主要な処理内容**：
1. パス結合（join）
2. パス正規化（normalize）
3. 絶対パス解決（resolve）
4. パス解析（parse）とフォーマット（format）
5. ディレクトリ名取得（dirname）
6. ファイル名取得（basename）
7. 拡張子取得（extname）
8. 相対パス計算（relative）
9. 絶対パス判定（isAbsolute）

**関連システム・外部連携**：特になし。純粋な文字列操作。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | APIとして利用 |

## 機能種別

ユーティリティ / Node.js互換

## 入力仕様

### 主要入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| path | string | Yes | 操作対象のパス文字列 | 文字列であること |
| ...paths | string[] | Yes (join等) | 結合するパス群 | 文字列配列 |
| from | string | Yes (relative) | 基点パス | 文字列 |
| to | string | Yes (relative) | 目標パス | 文字列 |

### 入力データソース

JavaScript API呼び出し。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| path | string | 処理結果のパス文字列 |
| parsed | object | 解析結果オブジェクト（parse） |
| boolean | boolean | 判定結果（isAbsolute） |

### 出力先

JavaScript呼び出し元への戻り値。

## 処理フロー

### 処理シーケンス

```
1. path.*メソッドの呼び出し
   └─ JavaScript引数の取得
2. 入力バリデーション
   └─ 文字列型チェック
3. パス処理実行
   └─ POSIX/Windows形式に応じた処理
4. 結果の返却
   └─ 文字列またはオブジェクト
```

### フローチャート

```mermaid
flowchart TD
    A[path.* 呼び出し] --> B{バリデーション}
    B -->|OK| C{POSIX or Windows?}
    B -->|NG| D[TypeError]
    C -->|POSIX| E[posixT関数]
    C -->|Windows| F[windowsT関数]
    E --> G[結果返却]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Node.js互換 | Node.js pathモジュールのAPIと互換 | 全API |
| BR-02 | プラットフォーム自動判定 | path.sep等は実行環境に依存 | デフォルトpath |
| BR-03 | POSIX/Windows明示指定 | path.posix/path.win32で明示可能 | 明示指定時 |
| BR-04 | 空パス処理 | 空パスは "." として扱う | dirname等 |

### 計算ロジック

- POSIX区切り文字: `/`
- Windows区切り文字: `\`

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TypeError | 型エラー | 引数が文字列でない | 文字列を渡す |

### リトライ仕様

該当なし（同期的な純関数）。

## トランザクション仕様

該当なし

## パフォーマンス要件

- スタックフォールバックアロケータによるメモリ効率化
- 可能な限りコピーを避ける実装

## セキュリティ考慮事項

- パストラバーサル攻撃への対策はアプリケーション側の責任
- 正規化によりパス検証を支援

## 備考

path.posixとpath.win32で明示的にプラットフォーム指定可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

node:path処理の中心となるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | path.zig | `src/bun.js/node/path.zig` | 定数定義、PathParsed構造体 |

**読解のコツ**:
- **52-57行目**: 区切り文字定数（CHAR_FORWARD_SLASH等）
- **65-83行目**: PathParsed構造体（root, dir, base, ext, name）
- **93-97行目**: sep_posix/sep_windows定数

#### Step 2: POSIX/Windows関数を理解する

各プラットフォーム向けの関数実装を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | path.zig | `src/bun.js/node/path.zig` | basenamePosixT、basenameWindowsT等 |

**主要処理フロー**:
1. **187-285行目**: basenamePosixT関数
2. **289-391行目**: basenameWindowsT関数
3. **442-478行目**: dirnamePosixT関数
4. **482-500行目**: dirnameWindowsT関数

#### Step 3: JavaScript連携を理解する

JavaScriptからの呼び出しインターフェースを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | path.zig | `src/bun.js/node/path.zig` | basename、dirname等のJS向け関数 |

**主要処理フロー**:
- **408-438行目**: basename関数（JS向けエントリポイント）
- 引数バリデーション（validateString）
- ZigString.Slice変換

### プログラム呼び出し階層図

```
path.basename() (JavaScript)
    │
    └─ Path.basename() (Zig, lines 408-438)
           │
           ├─ validateString() - 引数検証
           │
           ├─ path_ptr.getZigString() - JS文字列取得
           │
           ├─ pathZStr.toSlice() - スライス変換
           │
           └─ basenameJS_T() (lines 401-406)
                  │
                  └─ isWindows?
                         ├─ Yes → basenameWindowsT() (lines 289-391)
                         └─ No  → basenamePosixT() (lines 187-285)
```

### データフロー図

```
[入力]               [処理]                    [出力]

JSValue (string) ───▶ getZigString          ───▶ ZigString
                      │
                      └─ toSlice            ───▶ Slice ([]const u8)

Slice           ───▶ basename/dirname/...   ───▶ Slice (結果)
                     │
                     ├─ POSIX処理
                     └─ Windows処理

Slice           ───▶ createUTF8ForJS        ───▶ JSValue (string)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| path.zig | `src/bun.js/node/path.zig` | ソース | メイン実装 |
| path.ts | `src/js/node/path.ts` | ソース | JavaScript側実装 |
| path_binding.zig | `src/bun.js/node/` | ソース | JSバインディング |
