# 機能設計書 9-bun run

## 概要

本ドキュメントは、package.jsonスクリプトまたはファイルを実行する`bun run`コマンドの設計仕様を定義する。

### 本機能の処理概要

本機能は、package.jsonに定義されたスクリプトの実行、またはJavaScript/TypeScriptファイルの直接実行を行うコマンドを提供する。npm run / yarn run と互換性を持ちながら、Bunの高速な実行環境を活用する。

**業務上の目的・背景**：開発者はpackage.jsonのscriptsセクションにビルド、テスト、開発サーバー起動などの定型タスクを定義する。`bun run`はこれらのタスクを高速に実行し、開発ワークフローを効率化する。

**機能の利用シーン**：package.jsonスクリプトの実行（build, dev, start等）、任意のJavaScript/TypeScriptファイルの実行、シェルコマンドの実行など。

**主要な処理内容**：
1. コマンドライン引数の解析
2. package.jsonの検索と読み込み
3. スクリプト名の解決
4. 環境変数の設定（npm_lifecycle_event等）
5. シェルまたはBunでのスクリプト実行
6. 終了コードの伝播

**関連システム・外部連携**：シェル（bash/sh/zsh）、環境変数、package.json

**権限による制御**：ファイルシステムアクセス権限、実行権限に基づく

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | run | 主画面 | package.jsonスクリプトまたはファイルの実行コマンド処理 |

## 機能種別

コマンド実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| script_name | string | Yes | 実行するスクリプト名またはファイルパス | 空でないこと |
| -- | string[] | No | スクリプトに渡す追加引数 | - |
| --bun | boolean | No | Bunのシェルで実行（システムシェルではなく） | - |
| --silent | boolean | No | 実行コマンドを出力しない | - |

### 入力データソース

- コマンドライン引数
- package.json（scriptsセクション）
- 環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stdout | string | スクリプトの標準出力 |
| stderr | string | スクリプトの標準エラー出力 |
| exitCode | number | 終了コード |

### 出力先

- 標準出力
- 標準エラー出力
- プロセス終了コード

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ スクリプト名とオプションを解析
2. package.json検索
   └─ カレントディレクトリからpackage.jsonを探索
3. スクリプト解決
   └─ scriptsセクションからスクリプト内容を取得
4. 環境変数設定
   └─ npm_lifecycle_event、npm_lifecycle_script等を設定
5. コマンド変換
   └─ npm run/yarn/pnpmをbun runに置換
6. 実行
   └─ シェルまたはBunシェルでスクリプト実行
7. 終了コード伝播
   └─ 子プロセスの終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{ファイルパス?}
    C -->|Yes| D[ファイル実行]
    C -->|No| E[package.json検索]
    E --> F{scripts存在?}
    F -->|No| G[エラー: スクリプト未検出]
    F -->|Yes| H[スクリプト取得]
    H --> I[環境変数設定]
    I --> J[コマンド変換]
    J --> K{--bun?}
    K -->|Yes| L[Bunシェル実行]
    K -->|No| M[システムシェル実行]
    D --> N[終了コード返却]
    L --> N
    M --> N
    G --> O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | パッケージマネージャ置換 | yarn run/npm run/pnpm runをbun runに自動置換 | スクリプト実行時 |
| BR-02 | 暗黙的実行 | package.jsonのbinや./node_modules/.binを自動的にPATHに追加 | スクリプト実行時 |
| BR-03 | ファイル優先 | ファイルが存在する場合はpackage.jsonスクリプトより優先 | 引数解析時 |
| BR-04 | 環境変数継承 | npm_package_name、npm_package_version等を自動設定 | スクリプト実行時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SCRIPT_NOT_FOUND | スクリプト未検出 | scriptsに指定名が存在しない | スクリプト名を確認 |
| SHELL_NOT_FOUND | シェル未検出 | システムシェルが見つからない | シェルをインストール |
| EXECUTION_ERROR | 実行エラー | スクリプトがエラーで終了 | スクリプトを修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- スクリプト起動: 50ms以内
- パッケージマネージャ置換: 1ms以内

## セキュリティ考慮事項

- スクリプトは任意のコマンドを実行可能
- 信頼できないpackage.jsonのスクリプトは実行前に確認

## 備考

`bun`コマンド単体でも暗黙的に`bun run`として動作する（例: `bun dev` = `bun run dev`）。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | run_command.zig | `src/cli/run_command.zig` | RunCommand構造体とNpmArgs定数で環境変数設定を理解 |

**読解のコツ**: NpmArgs.package_name/package_versionでnpm互換の環境変数名を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | run_command.zig | `src/cli/run_command.zig` | RunCommand構造体のメイン処理を理解 |

**主要処理フロー**:
1. **3-7行目**: NpmArgs定数でnpm_package_name/npm_package_versionを定義
2. **9-15行目**: RunCommand構造体の定義
3. **16-49行目**: findShellImpl()でシステムシェルを探索

#### Step 3: スクリプト実行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | run_command.zig | `src/cli/run_command.zig` | runPackageScriptForeground()でスクリプト実行処理を理解 |

**主要処理フロー**:
- **208-268行目**: runPackageScriptForeground()でスクリプト実行
  - 219-221行目: npm_lifecycle_event/npm_lifecycle_script設定
  - 230行目: replacePackageManagerRun()でコマンド置換
  - 248-267行目: Bunシェルまたはシステムシェルで実行

#### Step 4: パッケージマネージャ置換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | run_command.zig | `src/cli/run_command.zig` | replacePackageManagerRun()でコマンド置換処理を理解 |

**主要処理フロー**:
- **86-204行目**: replacePackageManagerRun()
  - yarn/npm run/pnpm run/npx/pnpm dlxをbun runに置換
  - yarn_commandsマップで暗黙的yarnコマンドを処理

### プログラム呼び出し階層図

```
bun run <script>
    │
    ├─ cli.zig::Command
    │      └─ RunCommand判定
    │
    ├─ run_command.zig::RunCommand
    │      ├─ findShell() → シェル探索
    │      ├─ package.json読み込み
    │      └─ runPackageScriptForeground()
    │             ├─ replacePackageManagerRun()
    │             ├─ 環境変数設定
    │             └─ シェル実行
    │
    └─ 終了コード返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

bun run dev ───▶ 引数解析 ───▶ "dev"
                       │
                       ▼
              package.json ───▶ "vite"
                       │
                       ▼
              replacePackageManagerRun()
                       │
                       ▼
              シェル実行 ───▶ stdout/stderr
                       │
                       ▼
              終了コード ───▶ プロセス終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| run_command.zig | `src/cli/run_command.zig` | ソース | bun runコマンドメイン実装 |
| cli.zig | `src/cli.zig` | ソース | CLIコマンドディスパッチ |
| shell/ | `src/shell/` | ソース | Bunシェル実装 |
