---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-JavaScript_TypeScript実行.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：具体的なベンチマーク根拠が不足
  2. **コールドスタート50ms以内**：公式ドキュメント・ベンチマーク未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.zig` - メインエントリーポイントファイル
- E-02: `src/cli.zig` - CLI処理実装
- E-03: `src/cli/run_command.zig` - RunCommand実装
- E-04: `src/transpiler.zig` - トランスパイラ実装
- E-05: `src/js_parser.zig` - JavaScriptパーサー実装
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebKit JavaScriptCoreエンジンを使用 | E-06 (機能一覧.csvのNo.1備考欄) | ○ |
| C-02 | TypeScriptを事前コンパイルなしで直接実行 | E-04 (transpiler.zig) | ○ |
| C-03 | Cli.start()がエントリーポイント | E-02 (cli.zig 11-25行目) | ○ |
| C-04 | Command.start()を呼び出し | E-02 (cli.zig 20行目) | ○ |
| C-05 | RunCommandでファイル実行処理 | E-03 (run_command.zig) | ○ |
| C-06 | npm/yarn/pnpmコマンドをbunに置換 | E-03 (run_command.zig 86-204行目) | ○ |
| C-07 | ParseResult構造体でパース結果を管理 | E-04 (transpiler.zig 7-56行目) | ○ |
| C-08 | Expression/Binding/Statement の3要素 | E-05 (js_parser.zig 104-116行目コメント) | ○ |
| C-09 | .ts, .tsx, .js, .jsx等の拡張子自動判定 | E-04 (options.Loader enum) | ○ |
| C-10 | package.jsonのtypeフィールドでESM/CJS判定 | E-04 (resolver経由) | ○ |
| C-11 | 画面No.1「run」と関連 | E-07 (画面機能マッピング.csv) | ○ |
| C-12 | モジュール解決機能と連携 | E-07 (画面機能マッピング.csv) | ○ |
| C-13 | 環境変数機能と連携 | E-07 (画面機能マッピング.csv) | ○ |
| C-14 | トランスパイラ機能と連携 | E-07 (画面機能マッピング.csv) | ○ |
| C-15 | PluginRunner構造体でプラグイン処理 | E-04 (transpiler.zig 58-185行目) | ○ |
| C-16 | コールドスタート50ms以内 | **根拠なし** | △ |
| C-17 | トランスパイル10ms以内 | **根拠なし** | △ |
| C-18 | バイトコードキャッシュ機能 | E-04 (AlreadyBundled enum 18-39行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は公式ベンチマークまたは内部テスト結果からの引用が必要
  - 候補：公式ドキュメント / ベンチマークCI / 内部パフォーマンステスト

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：機能概要、処理フロー、コードリーディングガイドは十分な根拠あり
- 1（中リスク）：パフォーマンス要件の数値は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認（ベンチマーク結果と照合）
- [ ] JavaScriptCoreエンジンの制限事項が網羅されているか確認
- [ ] エラーケース一覧が実際のエラーハンドリングと一致しているか確認
