---
generated_at: 2026-01-27 18:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-bun_test.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトタイムアウト値**：5000msの根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/test_command.zig` - bun testコマンド実装
- E-02: `src/bun.js/test/jest.zig` - TestRunnerとJest API
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jest互換のテストランナーを実行 | E-03 (機能一覧.csv No.10) | ○ |
| C-02 | src/cli/test_command.zigで実装 | E-03 (機能一覧.csv No.10備考) | ○ |
| C-03 | escapeXml()でXMLエスケープ | E-01 (test_command.zig 4-41行目) | ○ |
| C-04 | fmtStatusTextLine()で結果フォーマット | E-01 (test_command.zig 42-68行目) | ○ |
| C-05 | JunitReporter構造体でJUnitレポート生成 | E-01 (test_command.zig 73-300行目以降) | ○ |
| C-06 | TestRunner構造体でテスト実行管理 | E-02 (jest.zig 64-172行目) | ○ |
| C-07 | Summary構造体でpass/fail/skip/todo集計 | E-02 (jest.zig 116-128行目) | ○ |
| C-08 | shouldFileRunConcurrently()で並列実行判定 | E-02 (jest.zig 134-151行目) | ○ |
| C-09 | getOrPutFile()でテストファイル管理 | E-02 (jest.zig 153-171行目) | ○ |
| C-10 | createTestModule()でJest互換モジュール作成 | E-02 (jest.zig 181-200行目) | ○ |
| C-11 | test/it/describe関数の登録 | E-02 (jest.zig 184-196行目) | ○ |
| C-12 | xtest/xit/xdescribeでスキップ | E-02 (jest.zig 188-196行目) | ○ |
| C-13 | beforeEach/beforeAll/afterAllフック | E-02 (jest.zig 198-200行目) | ○ |
| C-14 | 画面No.2「test」と関連 | E-04 (画面機能マッピング.csv) | ○ |
| C-15 | Jest互換テスト機能と連携 | E-04 (画面機能マッピング.csv) | ○ |
| C-16 | File.List/File.MapでテストファイルMultiArrayList管理 | E-02 (jest.zig 164-171行目) | ○ |
| C-17 | filter_regexでテスト名フィルタリング | E-02 (jest.zig 93行目) | ○ |
| C-18 | デフォルトタイムアウト5000ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- デフォルトタイムアウト値5000msの実装箇所の確認が必要
  - 候補：jest.zig内のdefault_timeout_ms / bunfig.tomlのデフォルト値

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：テスト実行処理、Jest API、JUnitレポートは十分な根拠あり
- 1（中リスク）：デフォルトタイムアウト値は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトタイムアウト値の実装を確認
- [ ] 並列実行のデフォルト動作を確認
- [ ] Jestとの互換性範囲を確認（未サポート機能）
