---
generated_at: 2026-01-27 17:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-node_assert

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のMyers差分計算量**：計算量の表記は一般的な知識に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `src/js/node/assert.ts` - メインのassertモジュール実装
- E-02: `src/js/node/assert.strict.ts` - strict版エクスポート
- E-03: `src/js/internal/assert/assertion_error.ts` - AssertionErrorクラス
- E-04: `src/bun.js/node/node_assert.zig` - Myers差分のZig実装
- E-05: `src/bun.js/node/node_assert_binding.zig` - JSバインディング
- E-06: `src/bun.js/node/assert/myers_diff.zig` - Myers差分アルゴリズム
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | assert関数はok関数のエイリアス | E-01 (88行目) | ○ |
| C-02 | isDeepEqualはBun.deepEqualsを使用 | E-01 (60-65行目) | ○ |
| C-03 | strictEqualはObject.is()を使用 | E-01 (341行目) | ○ |
| C-04 | deepStrictEqualはBun.deepEquals(a,b,true)を使用 | E-01 (295行目) | ○ |
| C-05 | partialDeepStrictEqual関数が存在 | E-01 (540-555行目) | ○ |
| C-06 | AssertionErrorはERR_ASSERTIONコードを持つ | E-03 (366行目) | ○ |
| C-07 | Myers差分アルゴリズムをZigで実装 | E-04, E-06 | ○ |
| C-08 | DiffKindはinsert/delete/equalの3種類 | E-06 (373-386行目) | ○ |
| C-09 | myersDiff関数はJSバインディング経由で呼び出し | E-05 (10-49行目) | ○ |
| C-10 | kReadableOperatorでエラーメッセージテンプレート定義 | E-03 (38-49行目) | ○ |
| C-11 | createErrDiff関数で差分メッセージ生成 | E-03 (183-230行目) | ○ |
| C-12 | CallTrackerはDEP0173で非推奨 | E-01 (1006行目) | ○ |
| C-13 | assert.strictはstrictモードのエイリアス集 | E-01 (1027-1032行目) | ○ |
| C-14 | throws関数でgetActualを呼び出し | E-01 (843行目) | ○ |
| C-15 | NaN同士は等価と見なす | E-01 (203行目, 227行目) | ○ |
| C-16 | 入力サイズ上限はMAXLEN(u32最大値) | E-06 (34行目) | ○ |
| C-17 | Options構造体で設定を定義 | E-06 (10-22行目) | ○ |
| C-18 | Myers差分計算量はO((M+N)*D) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- Myers差分アルゴリズムの計算量表記は、Eugene W. Myersの論文「An O(ND) Difference Algorithm and Its Variations」に基づく一般的な知識であり、Bunのソースコード内に明示的な記載はない
  - 候補：論文参照 / ベンチマーク結果 / コードコメント

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全体的にソースコードから直接確認できる主張が多い
- **1: 中リスク** - パフォーマンス要件の計算量表記は一般的な知識に基づくため、実測値との差異に注意

## 6) レビュアーチェックリスト（最小）

- [ ] assert.tsの各関数が正しく説明されているか確認
- [ ] AssertionErrorのプロパティ一覧が漏れなく記載されているか確認
- [ ] Myers差分アルゴリズムの実装がmyers_diff.zigと一致しているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] エラーケース一覧が網羅的か確認
