---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：102-node_dns

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様のデフォルト動作**：システム依存の詳細が不明

## 2) 参照した情報（Evidence一覧）

- E-01: `src/js/node/dns.ts` - Node.js互換DNSモジュール実装
- E-02: `src/dns.zig` - DNS関連データ構造定義
- E-03: `src/bun.js/api/bun/dns.zig` - DNSリゾルバのZig実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bun.dnsからネイティブDNS APIを取得 | E-01 (2行目) | ○ |
| C-02 | errorCodesでDNSエラーコードを定義 | E-01 (13-38行目) | ○ |
| C-03 | DNS_プレフィックスを除去してNode互換に | E-01 (52-58行目) | ○ |
| C-04 | デフォルトのIPアドレス順序はipv4first | E-01 (244行目) | ○ |
| C-05 | IANAポート53がデフォルト | E-01 (40行目) | ○ |
| C-06 | familyは0,4,6,'IPv4','IPv6'を受け付ける | E-01 (163-177行目) | ○ |
| C-07 | orderはipv4first,ipv6first,verbatim | E-01 (192行目) | ○ |
| C-08 | isIP()でIPアドレス直接入力をチェック | E-01 (295-303行目) | ○ |
| C-09 | lookup結果をorderに基づいてソート | E-01 (310-314行目) | ○ |
| C-10 | InternalResolverクラスで各種resolve関数を実装 | E-01 (371-643行目) | ○ |
| C-11 | promisesでPromiseベースAPIを提供 | E-01 (719-948行目) | ○ |
| C-12 | util.promisifyに対応 | E-01 (950-970行目) | ○ |
| C-13 | GetAddrInfo構造体でクエリ情報を定義 | E-02 (5-16行目) | ○ |
| C-14 | Options構造体でfamily,socktype等を管理 | E-02 (42-118行目) | ○ |
| C-15 | LibInfoでmacOS固有の非同期DNS | E-03 (7-128行目) | ○ |
| C-16 | LibCでPOSIX標準getaddrinfo使用 | E-03 (130-165行目) | ○ |
| C-17 | LibUVBackendでWindows環境対応 | E-03 (167-243行目) | ○ |
| C-18 | normalizeDNSNameでc-aresの制約に対応 | E-03 (245-264行目) | ○ |
| C-19 | 空ホスト名でDEP0118警告 | E-01 (220-231行目) | ○ |
| C-20 | リトライ仕様のデフォルトはシステム依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- リトライ仕様のデフォルト動作について、ソースコード内で明示的な記載が見つからない
  - 候補：c-aresのドキュメント / システム設定ファイル / テストケース

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全体的にソースコードから直接確認できる主張が多い
- **1: 中リスク** - バックエンド（libinfo/libuv/libc）の使い分けロジックはプラットフォーム依存のため、実環境でのテストを推奨

## 6) レビュアーチェックリスト（最小）

- [ ] dns.tsの各関数（lookup, resolve等）が正しく説明されているか確認
- [ ] エラーコード一覧が網羅的か確認
- [ ] バックエンド選択ロジックが各プラットフォームで正しいか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] promisesとcallback版の両方が正しく説明されているか確認
