---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：104-node_async_hooks

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/js/node/async_hooks.ts` - async_hooksモジュールの実装
- E-02: `src/bun.js/bindings/AsyncContextFrame.cpp` - C++でのコンテキストフレーム管理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンテキスト配列は[key, value, key, value]形式 | E-01 (21-24行目) | ○ |
| C-02 | get()で$asyncContext内部フィールドを読み取り | E-01 (65-68行目) | ○ |
| C-03 | set()で$asyncContext内部フィールドに書き込み | E-01 (70-74行目) | ○ |
| C-04 | コンストラクタでsetAsyncHooksEnabled(true)を呼び出し | E-01 (80行目) | ○ |
| C-05 | snapshotで現在のコンテキストをキャプチャ | E-01 (98-109行目) | ○ |
| C-06 | enterWithでコンテキストにエントリを追加 | E-01 (111-134行目) | ○ |
| C-07 | runでコールバック実行後finallyで復元 | E-01 (142-205行目) | ○ |
| C-08 | disableでエントリを削除 | E-01 (207-223行目) | ○ |
| C-09 | disabled時はgetStoreがundefinedを返す | E-01 (227-228行目) | ○ |
| C-10 | AsyncResourceでスナップショットを保存 | E-01 (278行目) | ○ |
| C-11 | runInAsyncScopeでスナップショットを復元して実行 | E-01 (301-309行目) | ○ |
| C-12 | createHookはスタブで警告を出力 | E-01 (362-389行目) | ○ |
| C-13 | executionAsyncIdは常に0を返す | E-01 (394-397行目) | ○ |
| C-14 | executionAsyncResourceはprocess.stdinを返す | E-01 (406-409行目) | ○ |
| C-15 | asyncWrapProviders定数が定義されている | E-01 (411-470行目) | ○ |
| C-16 | withAsyncContextIfNeededでコンテキストがなければラッパーを作成しない | E-02 (41-44行目) | ○ |
| C-17 | AsyncContextFrame::callでコンテキストを復元しながら呼び出し | E-02 (120-131行目) | ○ |
| C-18 | コンテキスト配列は変更時にコピーする | E-01 (126, 156, 184行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全主張に根拠があり、実装が明確
- **注意点**: createHook等の未実装機能はNode.jsとの互換性に影響する可能性あり

## 6) レビュアーチェックリスト（最小）

- [ ] async_hooks.tsのAsyncLocalStorageクラスが正しく説明されているか確認
- [ ] AsyncResourceクラスの動作が正しく説明されているか確認
- [ ] スタブ実装（createHook等）の警告メッセージが適切か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] C++側のAsyncContextFrameの動作が正しく説明されているか確認
