---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-node_inspector

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/js/node/inspector.ts` - inspectorモジュールの実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ネイティブプロファイラー関数の読み込み | E-01 (7-10行目) | ○ |
| C-02 | open/close/waitForDebuggerはthrowNotImplemented | E-01 (12-28行目) | ○ |
| C-03 | url()は常にundefinedを返す | E-01 (20-24行目) | ○ |
| C-04 | Sessionはプライベートフィールドで状態管理 | E-01 (31-32行目) | ○ |
| C-05 | connect()で二重接続時はエラー | E-01 (35-37行目) | ○ |
| C-06 | disconnect()でプロファイラー停止 | E-01 (47行目) | ○ |
| C-07 | post()でコールバック有無を判定 | E-01 (74-89行目) | ○ |
| C-08 | Profiler.enableでフラグを立てる | E-01 (94-96行目) | ○ |
| C-09 | Profiler.startはenable後のみ実行可 | E-01 (106行目) | ○ |
| C-10 | Profiler.stopでJSON.parse | E-01 (113行目) | ○ |
| C-11 | setSamplingIntervalは実行中は変更不可 | E-01 (119行目) | ○ |
| C-12 | intervalは正の数値のみ | E-01 (121行目) | ○ |
| C-13 | Coverage APIはnot supported | E-01 (126-130行目) | ○ |
| C-14 | 未知のメソッドはnot supportedエラー | E-01 (133行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全主張に根拠があり、実装が明確
- **注意点**: open/close/waitForDebuggerは未実装のため、デバッガー連携を必要とする用途には使用不可

## 6) レビュアーチェックリスト（最小）

- [ ] inspector.tsのSessionクラスが正しく説明されているか確認
- [ ] Profiler.*メソッドの動作が正しく説明されているか確認
- [ ] 未実装機能（open/close等）の説明が正しいか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] エラーケース一覧が網羅的か確認
