---
generated_at: 2026-01-27 18:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-node_cluster

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/js/node/cluster.ts` - clusterモジュールのエントリーポイント
- E-02: `src/js/internal/cluster/primary.ts` - プライマリプロセスの実装
- E-03: `src/js/internal/cluster/child.ts` - ワーカープロセスの実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isPrimaryで分岐してprimary/childをロード | E-01 (3-5行目) | ○ |
| C-02 | initializeClusterIPCでワーカー初期化 | E-01 (10-20行目) | ○ |
| C-03 | クラスターオブジェクトの初期化（プライマリ） | E-02 (16-32行目) | ○ |
| C-04 | スケジューリングポリシーの決定 | E-02 (37-48行目) | ○ |
| C-05 | setupPrimaryで設定を初期化 | E-02 (50-70行目) | ○ |
| C-06 | createWorkerProcessでワーカー生成 | E-02 (79-102行目) | ○ |
| C-07 | forkでワーカー作成・イベント登録 | E-02 (122-150行目) | ○ |
| C-08 | isMasterはisPrimaryの非推奨エイリアス | E-02 (25行目) | ○ |
| C-09 | setupMasterはsetupPrimaryのエイリアス | E-02 (73行目) | ○ |
| C-10 | SCHED_RR=2, SCHED_NONE=1 | E-02 (18-19行目, 30-31行目) | ○ |
| C-11 | クラスターオブジェクトの初期化（ワーカー） | E-03 (20-27行目) | ○ |
| C-12 | _setupWorkerでワーカーを設定 | E-03 (28-58行目) | ○ |
| C-13 | _getServerでサーバーハンドルを取得 | E-03 (61-100行目) | ○ |
| C-14 | NODE_UNIQUE_IDでワーカー識別 | E-01 (11行目), E-02 (80行目) | ○ |
| C-15 | child_process.forkでワーカー生成 | E-02 (90-101行目) | ○ |
| C-16 | WindowsでもSCHED_RRを使用（TODOコメント） | E-02 (41-47行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全主張に根拠があり、実装が明確
- **注意点**: WindowsでのSCHED_RR使用はTODOコメントがあり、将来変更の可能性あり

## 6) レビュアーチェックリスト（最小）

- [ ] cluster.tsのエントリーポイントが正しく説明されているか確認
- [ ] primary.tsのフォーク処理が正しく説明されているか確認
- [ ] child.tsのワーカー初期化が正しく説明されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] スケジューリングポリシーの説明が正しいか確認
