---
generated_at: 2026-01-27 18:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-Bake

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bake.zig` - Bakeメインモジュール
- E-02: `src/bake/production.zig` - プロダクションビルド実装
- E-03: `src/bake/FrameworkRouter.zig` - ルーティング実装
- E-04: `src/bake/DevServer.zig` - 開発サーバー実装
- E-05: `src/bake/bake.d.ts` - TypeScript型定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BakeはBun.buildとBun.serveを組み合わせたツールキット | E-01 (1-4行目) | ○ |
| C-02 | フレームワークの役割ではなく基盤を提供 | E-01 (4行目) | ○ |
| C-03 | UserOptions.fromJSでJS設定をパース | E-01 (29-115行目) | ○ |
| C-04 | "react"文字列でReact組み込み設定を使用 | E-01 (46-65行目) | ○ |
| C-05 | Framework.react()でReact設定を生成 | E-01 (258-295行目) | ○ |
| C-06 | FileSystemRouterType最大256個 | E-01 (561-563行目) | ○ |
| C-07 | separateSSRGraphでSSR用別グラフ | E-01 (360-367行目), E-05 (138-162行目) | ○ |
| C-08 | OpaqueFileIdでファイルを一意に識別 | E-03 (10行目) | ○ |
| C-09 | Route構造体でルート情報を保持 | E-03 (67-98行目) | ○ |
| C-10 | nextjs-pages/nextjs-app-ui/nextjs-app-routesスタイル | E-03 (465-469行目) | ○ |
| C-11 | EncodedPatternでルートパターンをエンコード | E-03 (180-343行目) | ○ |
| C-12 | matchSlowでURLマッチング | E-03 (851-866行目) | ○ |
| C-13 | buildCommandでCLIからビルド実行 | E-02 (4-110行目) | ○ |
| C-14 | BundleV2.generateFromBakeProductionCLIでバンドル生成 | E-02 (313-324行目) | ○ |
| C-15 | BakeRenderRoutesForProdStaticでプリレンダリング | E-02 (685-712行目, 755-780行目) | ○ |
| C-16 | DevServerでインクリメンタルグラフを管理 | E-04 (68-69行目) | ○ |
| C-17 | bun_watcherでファイル監視 | E-04 (108行目) | ○ |
| C-18 | 内部URLプレフィックス /_bun | E-04 (248-260行目) | ○ |
| C-19 | import.meta.env.DEV/PROD/SSR/STATIC定義 | E-01 (892-933行目) | ○ |
| C-20 | Bakeは実験的でAPIは変更可能性あり | E-01 (985-996行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全主張に根拠があり、実装が明確
- **注意点**: Bakeは高度に実験的であり、APIは頻繁に変更される可能性がある（公式警告あり）

## 6) レビュアーチェックリスト（最小）

- [ ] bake.zigのUserOptions/Framework構造体が正しく説明されているか確認
- [ ] FrameworkRouter.zigのルーティングロジックが正しく説明されているか確認
- [ ] production.zigのビルドフローが正しく説明されているか確認
- [ ] DevServer.zigの開発サーバー機能が正しく説明されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] 型定義（bake.d.ts）との整合性を確認
