---
generated_at: 2026-01-27 18:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-DevServer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bake/DevServer.zig` - DevServerメイン実装
- E-02: `src/bake/DevServer/RouteBundle.zig` - ルートバンドル管理
- E-03: `src/bake/DevServer/IncrementalGraph.zig` - インクリメンタルグラフ
- E-04: `src/bake/DevServer/HmrSocket.zig` - HMR WebSocket
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DevServerは完全なインクリメンタル追跡を持つ | E-01 (1-9行目) | ○ |
| C-02 | 変更されていないファイルの再処理は禁止 | E-01 (5-6行目) | ○ |
| C-03 | Options構造体でアリーナ/ルート/VM等を設定 | E-01 (17-29行目) | ○ |
| C-04 | DevServer構造体のフィールド定義 | E-01 (37-156行目) | ○ |
| C-05 | client_graph/server_graphでインクリメンタルグラフ管理 | E-01 (68-69行目) | ○ |
| C-06 | bun_watcherでファイル監視 | E-01 (108行目) | ○ |
| C-07 | init関数で初期化処理を実行 | E-01 (287-558行目) | ○ |
| C-08 | configuration_hash_keyの計算方法 | E-01 (426-497行目) | ○ |
| C-09 | 内部URLプレフィックス /_bun | E-01 (248行目) | ○ |
| C-10 | RouteBundle.server_stateとdata | E-02 (5-12行目) | ○ |
| C-11 | Framework構造体でフルスタックルート | E-02 (27-43行目) | ○ |
| C-12 | HTML構造体でフロントエンドルート | E-02 (45-62行目) | ○ |
| C-13 | State列挙型でバンドル状態を定義 | E-02 (66-88行目) | ○ |
| C-14 | invalidateClientBundleでキャッシュ無効化 | E-02 (121-135行目) | ○ |
| C-15 | ServerFile構造体（is_rsc/is_ssr/is_client_component_boundary） | E-03 (7-44行目) | ○ |
| C-16 | Content共用体（js/css_root/css_child/asset） | E-03 (46-70行目) | ○ |
| C-17 | ClientFile構造体とPackedバージョン | E-03 (72-170行目) | ○ |
| C-18 | HmrSocketのフィールド定義 | E-04 (3-12行目) | ○ |
| C-19 | is_from_localhostでローカルホスト判定 | E-04 (17-23行目) | ○ |
| C-20 | onOpenでバージョン（configuration_hash_key）送信 | E-04 (30-41行目) | ○ |
| C-21 | onMessageでinit/subscribe/set_url処理 | E-04 (43-150行目) | ○ |
| C-22 | frontend_onlyモード（ルーターなし） | E-01 (322行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全主張に根拠があり、実装が明確
- **注意点**: DevServerは実験的機能であり、内部APIは頻繁に変更される可能性がある

## 6) レビュアーチェックリスト（最小）

- [ ] DevServer.zigの初期化フローが正しく説明されているか確認
- [ ] RouteBundle.zigの状態遷移が正しく説明されているか確認
- [ ] IncrementalGraph.zigのファイル追跡ロジックが正しく説明されているか確認
- [ ] HmrSocket.zigのメッセージプロトコルが正しく説明されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] セキュリティ考慮事項（is_from_localhost）の説明が正しいか確認
