---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-bun_build.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的なベンチマーク数値の根拠なし
  2. **増分ビルドサポート**：watchモードとの関連性の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/build_command.zig` - BuildCommand構造体、exec関数
- E-02: `src/bundler/bundle_v2.zig` - BundleV2構造体（ファイル参照）
- E-03: `src/options.zig` - OutputFile、SourceMapOption（インポート参照）
- E-04: `src/transpiler.zig` - Transpiler構造体（44行目でinit呼び出し）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.11の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.20との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun buildはJavaScript/TypeScriptバンドラー機能 | E-05 | ○ |
| C-02 | BuildCommand.exec関数がエントリーポイント | E-01 (1-2行目) | ○ |
| C-03 | Transpiler.initでバンドラー設定を構築 | E-01 (44行目) | ○ |
| C-04 | --compileで単一実行ファイル生成 | E-01 (6-9行目, 100-140行目) | ○ |
| C-05 | --outdirは--compileと同時指定不可 | E-01 (101-105行目) | ○ |
| C-06 | 外部ソースマップには--outdirが必要 | E-01 (56-60行目) | ○ |
| C-07 | 複数エントリーポイントには--outdirが必要 | E-01 (153-158行目) | ○ |
| C-08 | code splittingには--outdirが必要 | E-01 (159-163行目) | ○ |
| C-09 | 出力ファイル名にbun/bunxは使用不可 | E-01 (129-133行目) | ○ |
| C-10 | --no-bundleと--compileは同時指定不可 | E-01 (135-139行目) | ○ |
| C-11 | BundleV2.generateFromCLIでバンドル処理 | E-01 (312-330行目) | ○ |
| C-12 | --no-bundle時はtransform関数を使用 | E-01 (277-301行目) | ○ |
| C-13 | メタファイル出力機能あり | E-01 (332-355行目) | ○ |
| C-14 | StandaloneModuleGraph.toExecutableで実行ファイル生成 | E-01 (460-481行目) | ○ |
| C-15 | OutputFile.writeToDiskでファイル書き込み | E-01 (537行目) | ○ |
| C-16 | minify系オプションの設定 | E-01 (75-80行目) | ○ |
| C-17 | sourcemapオプションの設定 | E-01 (52行目) | ○ |
| C-18 | code_splittingオプションの設定 | E-01 (74行目) | ○ |
| C-19 | banner/footerオプションの設定 | E-01 (82-83行目) | ○ |
| C-20 | target指定でbun用ビルド | E-01 (6-9行目) | ○ |
| C-21 | printSummaryでビルドサマリー出力 | E-01 (609-677行目) | ○ |
| C-22 | exitOrWatchでwatch対応 | E-01 (601-607行目) | ○ |
| C-23 | NODE_ENVをproductionに設定可能 | E-01 (199-201行目) | ○ |
| C-24 | esbuild同等以上の速度を実現 | **根拠なし** | △ |
| C-25 | 増分ビルドのサポート | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス比較データ（esbuildとの比較ベンチマーク）
  - 候補：公式ドキュメント / ベンチマークレポート / 外部記事
- 増分ビルドの詳細実装
  - 候補：bundle_v2.zigの詳細解析 / watchモード実装の確認

## 5) リスクフラグ（レビュー観点）
- 0: エントリーポイント、オプション処理、出力処理の記述
- 0: エラーハンドリングの記述
- 1: パフォーマンス要件の具体性（ベンチマーク数値なし）

## 6) レビュアーチェックリスト（最小）
- [ ] build_command.zigの行番号が実際のコードと一致しているか確認
- [ ] --compileオプションの制約事項が網羅されているか確認
- [ ] パフォーマンス要件の記述が適切か（根拠なしのため慎重に）
- [ ] 関連ファイル一覧が最新のコード構造と一致しているか確認
