---
generated_at: 2026-01-27 18:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-HMR

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bake/hmr-runtime-client.ts` - クライアントHMRランタイム
- E-02: `src/bake/hmr-runtime-server.ts` - サーバーHMRランタイム
- E-03: `src/bake/hmr-module.ts` - HMRモジュールローダー
- E-04: `src/bake/client/websocket.ts` - WebSocket管理
- E-05: `src/bake/client/css-reloader.ts` - CSSリロード
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketでバンドラーと通信 | E-01 (1-2行目) | ○ |
| C-02 | bun buildの動作を模倣するモジュールローダー | E-03 (1-4行目) | ○ |
| C-03 | registryでロード済みモジュールを管理 | E-03 (22行目) | ○ |
| C-04 | serverManifest/ssrManifest定義 | E-03 (25-27行目) | ○ |
| C-05 | State列挙型（Pending/Stale/Loaded/Error） | E-03 (37-42行目) | ○ |
| C-06 | HMRModuleクラスの実装 | E-03 (72-270行目) | ○ |
| C-07 | accept()で自己受け入れ | E-03 (172-192行目) | ○ |
| C-08 | dispose()でクリーンアップ登録 | E-03 (213-215行目) | ○ |
| C-09 | invalidate()で完全リロード要求 | E-03 (222-226行目) | ○ |
| C-10 | Vite互換イベント変換（vite: -> bun:） | E-03 (228-232行目) | ○ |
| C-11 | performRouteReloadでサーバーサイドリロード | E-01 (37-63行目) | ○ |
| C-12 | bun:hmrシンボルでモジュール登録 | E-01 (68-87行目) | ○ |
| C-13 | handlersオブジェクトでメッセージハンドラー | E-01 (90-202行目) | ○ |
| C-14 | バージョン不一致で完全リロード | E-01 (91-96行目) | ○ |
| C-15 | hot_updateハンドラーでCSS/JS更新 | E-01 (118-196行目) | ○ |
| C-16 | History.pushState/replaceStateをインターセプト | E-01 (222-237行目) | ○ |
| C-17 | グローバルerror/unhandledrejectionハンドラー | E-01 (239-254行目) | ○ |
| C-18 | server_exports.handleRequestの実装 | E-02 (54-160行目) | ○ |
| C-19 | server_exports.registerUpdateの実装 | E-02 (161-197行目) | ○ |
| C-20 | AsyncLocalStorageでリクエストコンテキスト伝播 | E-02 (20-22行目) | ○ |
| C-21 | cssStoreでCSS情報を管理 | E-05 (18-19行目) | ○ |
| C-22 | MutationObserverでリンクタグ監視 | E-05 (59-100行目) | ○ |
| C-23 | WebSocketWrapperインターフェース | E-04 (41-54行目) | ○ |
| C-24 | normalizeWebSocketURLでプロトコル変換 | E-04 (62-72行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全主張に根拠があり、実装が明確
- **注意点**: Firefox 2025時点では`import(a, b)`構文が未サポートのため、lazyDynamicImportWithOptionsで回避している

## 6) レビュアーチェックリスト（最小）

- [ ] hmr-runtime-client.tsのWebSocket通信フローが正しく説明されているか確認
- [ ] hmr-module.tsのHMRModuleクラスが正しく説明されているか確認
- [ ] hmr-runtime-server.tsのserver_exportsが正しく説明されているか確認
- [ ] css-reloader.tsのCSSリロードロジックが正しく説明されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] import.meta.hot APIの説明がVite互換性を含めて正しいか確認
