---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：111-FrameworkRouter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Serializedフォーマットの実装状況**：コード上ではTODOコメントのみ
  2. **カスタムスタイル（javascript_defined）の実装状況**：panic("TODO")となっている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/FrameworkRouter.zig` 1-1400行目（メイン実装ファイル）
- E-02: `src/bake/FrameworkRouter.zig` 10-11行目（OpaqueFileId定義）
- E-03: `src/bake/FrameworkRouter.zig` 67-98行目（Route構造体）
- E-04: `src/bake/FrameworkRouter.zig` 101-121行目（Type構造体）
- E-05: `src/bake/FrameworkRouter.zig` 180-343行目（EncodedPattern）
- E-06: `src/bake/FrameworkRouter.zig` 380-441行目（Part union）
- E-07: `src/bake/FrameworkRouter.zig` 459-511行目（Style union）
- E-08: `src/bake/FrameworkRouter.zig` 515-533行目（parseNextJsPages）
- E-09: `src/bake/FrameworkRouter.zig` 537-583行目（parseNextJsApp）
- E-10: `src/bake/FrameworkRouter.zig` 585-686行目（parseNextJsLikeRouteSegment）
- E-11: `src/bake/FrameworkRouter.zig` 708-812行目（insert関数）
- E-12: `src/bake/FrameworkRouter.zig` 815-846行目（MatchedParams）
- E-13: `src/bake/FrameworkRouter.zig` 851-866行目（matchSlow）
- E-14: `src/bake/FrameworkRouter.zig` 1152-1383行目（JSFrameworkRouter）
- E-15: `src/bake/FrameworkRouter.zig` 59-61行目（Serialized TODO）
- E-16: `src/bake/FrameworkRouter.zig` 509行目（javascript_defined panic TODO）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FrameworkRouterはファイルシステムからルートを自動検出する | E-01, E-10 | ○ |
| C-02 | Next.js Pages Router形式をサポート | E-07, E-08 | ○ |
| C-03 | Next.js App Router形式をサポート | E-07, E-09 | ○ |
| C-04 | 動的ルートパラメータ[param]をサポート | E-06, E-10 | ○ |
| C-05 | キャッチオールルート[...params]をサポート | E-06, E-10 | ○ |
| C-06 | オプショナルキャッチオール[[...params]]をサポート | E-06, E-10 | ○ |
| C-07 | ルートグループ(group)をサポート | E-06, E-10 | ○ |
| C-08 | 静的ルートと動的ルートを分離管理 | E-03, E-11 | ○ |
| C-09 | 最大64パラメータまでサポート | E-12 | ○ |
| C-10 | Route構造体は親子・兄弟関係を持つ | E-03 | ○ |
| C-11 | Type構造体でスタイル・拡張子等を設定 | E-04 | ○ |
| C-12 | EncodedPatternはシリアライズ可能な形式 | E-05 | ○ |
| C-13 | Part unionは5種類のセグメントを表現 | E-06 | ○ |
| C-14 | initEmpty関数でルーターを初期化 | E-01 123-153行目 | ○ |
| C-15 | scan関数でディレクトリをスキャン | E-01 986-1001行目 | ○ |
| C-16 | insert関数でルートを登録 | E-11 | ○ |
| C-17 | matchSlow関数でURLマッチング | E-13 | ○ |
| C-18 | 衝突検出を実行する | E-11 784-790行目 | ○ |
| C-19 | TinyLogでパースエラーを記録 | E-01 897-946行目 | ○ |
| C-20 | JSFrameworkRouterでJavaScriptバインディング提供 | E-14 | ○ |
| C-21 | ignore_dirsでディレクトリを除外 | E-04 105行目 | ○ |
| C-22 | パラメータ名の不正文字をバリデーション | E-10 624-625行目 | ○ |
| C-23 | プロダクション向けSerializedフォーマット | E-15 | △ |
| C-24 | カスタムスタイル（javascript_defined）サポート | E-16 | △ |
| C-25 | DevServerとの連携 | E-03 83行目（bundle フィールド） | ○ |

## 4) 不足情報（Unknown / Missing）
- **Serializedフォーマット**: 59-61行目でTODO構造体のみ定義されており、実装が完了していない
  - 候補：実装予定 / 設計中 / 将来バージョンで対応
- **カスタムスタイル（javascript_defined）**: 509行目で`@panic("TODO: customizable Style")`となっており未実装
  - 候補：実装予定 / 優先度低 / 将来バージョンで対応

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なルーティング機能（静的・動的ルート、パターンマッチング）
- **0 (低リスク)**: Next.js Pages/App Router互換性
- **1 (中リスク)**: matchSlowの線形探索アルゴリズム（開発環境向け、大規模アプリでの性能懸念）
- **1 (中リスク)**: 未実装機能（Serialized、javascript_defined）のドキュメント記載

## 6) レビュアーチェックリスト（最小）
- [ ] Route構造体の親子・兄弟関係がコードと一致しているか確認
- [ ] parseNextJsPages/parseNextJsAppの処理内容がドキュメントと一致しているか確認
- [ ] insert関数の衝突検出ロジックが正しく記述されているか確認
- [ ] MatchedParamsの最大64パラメータ制限がコードと一致しているか確認
- [ ] 未実装機能（Serialized、javascript_defined）の記載が適切か確認
- [ ] JSFrameworkRouterバインディングの記述が実装と一致しているか確認
