---
generated_at: 2026-01-27 17:40:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：113-クラッシュレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **trace stringの詳細エンコード形式**：コード上ではTraceString構造体が確認できるが、詳細なフォーマット仕様はbun.reportリポジトリとの同期が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/crash_handler.zig` 1-500行目（メイン実装ファイル）
- E-02: `src/crash_handler.zig` 21-23行目（enable定数）
- E-03: `src/crash_handler.zig` 26-27行目（default_report_base_url）
- E-04: `src/crash_handler.zig` 30-58行目（グローバル状態変数）
- E-05: `src/crash_handler.zig` 66-103行目（CrashReason union）
- E-06: `src/crash_handler.zig` 106-164行目（Action union）
- E-07: `src/crash_handler.zig` 166-195行目（captureLibcBacktrace）
- E-08: `src/crash_handler.zig` 198-500行目（crashHandler関数）
- E-09: `src/crash_handler.zig` 44-45行目（inside_native_plugin、unsupported_uv_function）
- E-10: `src/crash_handler.zig` 63行目（suppress_reporting）
- E-11: `src/crash_handler.zig` 473-486行目（自動リスタート処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CrashReasonでクラッシュ理由を分類 | E-05 | ○ |
| C-02 | panic, unreachable, segfault等を含む | E-05 67-88行目 | ○ |
| C-03 | Actionで実行中アクションを記録 | E-06 | ○ |
| C-04 | parse, visit, print, bundle_generate_chunk等のアクション | E-06 107-128行目 | ○ |
| C-05 | panic_stageで二重パニック制御 | E-04 42行目、E-08 211-496行目 | ○ |
| C-06 | panickingカウンタでスレッド間同期 | E-04 34行目 | ○ |
| C-07 | before_crash_handlersでコールバック実行 | E-04 56行目、E-08 218-223行目 | ○ |
| C-08 | Linux glibcでbacktrace()使用 | E-07 | ○ |
| C-09 | 最大20フレームのスタックトレース | E-08 339行目（addr_buf: [20]usize） | ○ |
| C-10 | inside_native_pluginでプラグインクラッシュ識別 | E-09 44行目、E-08 263-272行目 | ○ |
| C-11 | unsupported_uv_functionでlibuv関数クラッシュ識別 | E-09 45行目、E-08 273-287行目 | ○ |
| C-12 | suppress_reportingでレポート抑制 | E-10 | ○ |
| C-13 | default_report_base_urlはhttps://bun.report | E-03 | ○ |
| C-14 | BUN_CRASH_REPORT_URL環境変数で変更可能 | E-03 25行目コメント | ○ |
| C-15 | 自動リスタート機能（bun.auto_reload_on_crash） | E-11 | ○ |
| C-16 | waitForOtherThreadToFinishPanickingで他スレッド待機 | E-08 460行目 | ○ |
| C-17 | resetSegfaultHandlerでハンドラーリセット | E-08 471行目 | ○ |
| C-18 | trace stringにBunバージョン・プラットフォーム情報含む | E-05 65行目コメント | ○ |
| C-19 | bun.reportはオープンソース | E-01 16行目コメント | ○ |
| C-20 | --debug-crash-handler-use-trace-stringでリリースビルド動作テスト | E-08 245-247行目 | ○ |
| C-21 | CrashReason.formatでフォーマット | E-05 90-103行目 | ○ |
| C-22 | Action.formatでフォーマット | E-06 130-162行目 | ○ |
| C-23 | trace stringの詳細エンコード形式 | E-05 65行目コメント参照 | △ |

## 4) 不足情報（Unknown / Missing）
- **trace stringの詳細エンコード形式**: ファイル内コメント（65行目）でbun.reportとの同期が必要と記載されているが、実際のエンコード仕様の詳細は外部リポジトリ参照が必要
  - 候補：bun.reportリポジトリのドキュメント参照 / TraceString構造体の詳細解析

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: CrashReason、Actionの分類
- **0 (低リスク)**: panic_stageによる二重パニック制御
- **0 (低リスク)**: before_crash_handlersの実行
- **0 (低リスク)**: スタックトレース収集処理
- **1 (中リスク)**: trace stringのエンコード形式（外部依存）
- **0 (低リスク)**: 自動リスタート処理

## 6) レビュアーチェックリスト（最小）
- [ ] CrashReasonのバリアントがコードと一致しているか確認
- [ ] Actionのバリアントがコードと一致しているか確認
- [ ] panic_stageの遷移（0→1→2→3）がコードと一致しているか確認
- [ ] スタックトレースの最大フレーム数（20）がコードと一致しているか確認
- [ ] inside_native_pluginの処理がコードと一致しているか確認
- [ ] 自動リスタート条件がコードと一致しているか確認
- [ ] trace stringのフォーマットについてbun.reportとの整合性確認
