---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：114-イベントループ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/event_loop/Task.zig` 全体
- E-02: `src/bun.js/event_loop/Task.zig` 4-99行目（Task TaggedPointerUnion）
- E-03: `src/bun.js/event_loop/Task.zig` 101-532行目（tickQueueWithCount）
- E-04: `src/bun.js/event_loop/ConcurrentTask.zig` 全体
- E-05: `src/bun.js/event_loop/ConcurrentTask.zig` 11-16行目（ConcurrentTask構造体）
- E-06: `src/bun.js/event_loop/ConcurrentTask.zig` 20-59行目（PackedNextPtr）
- E-07: `src/bun.js/event_loop/ConcurrentTask.zig` 61-70行目（サイズ検証）
- E-08: `src/bun.js/event_loop/AnyEventLoop.zig` 全体
- E-09: `src/bun.js/event_loop/MiniEventLoop.zig` 1-300行目
- E-10: `src/bun.js/event_loop/MiniEventLoop.zig` 1-21行目（コメント）
- E-11: `src/bun.js/event_loop/MiniEventLoop.zig` 129-151行目（tickConcurrentWithCount）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Task TaggedPointerUnionで90以上のタスク型をサポート | E-02（99行でunion終了、約95タスク型） | ○ |
| C-02 | ConcurrentTaskは16バイト固定サイズ | E-07（61-64行目のcomptime検証） | ○ |
| C-03 | PackedNextPtrでポインタとauto_deleteフラグをパック | E-06 | ○ |
| C-04 | AnyEventLoopはjs/miniの2種類 | E-08 3-6行目 | ○ |
| C-05 | MiniEventLoopはJavaScript不要な処理向け | E-10（1-19行目コメント） | ○ |
| C-06 | tickQueueWithCountでタスクキューを処理 | E-03 | ○ |
| C-07 | 各タスク実行後にdrainMicrotasks | E-03 528行目 | ○ |
| C-08 | HotReloadTaskはマイクロタスクドレインをスキップ | E-03 271-274行目 | ○ |
| C-09 | Task.Tag別のswitch文でディスパッチ | E-03 139-526行目 | ○ |
| C-10 | reportErrorOrTerminateでエラー処理 | E-01 534-542行目 | ○ |
| C-11 | ConcurrentTask.auto_deleteで自動解放 | E-04 76-79行目（AutoDeinit enum） | ○ |
| C-12 | tickConcurrentWithCountで並行タスク取り込み | E-11 | ○ |
| C-13 | MiniEventLoop.initでuSocketsループ取得 | E-09 114-122行目 | ○ |
| C-14 | MiniEventLoop.tickOnceで単一tick実行 | E-09 153-167行目 | ○ |
| C-15 | MiniEventLoop.tickでisDone条件付きループ | E-09 187-204行目 | ○ |
| C-16 | ConcurrentTask.Queue = UnboundedQueue | E-04 72行目 | ○ |
| C-17 | FetchTasklet.onProgressUpdateを呼び出し | E-03 217-219行目 | ○ |
| C-18 | AsyncFS.*.runFromJSThreadを呼び出し | E-03 306-469行目 | ○ |
| C-19 | ShellAsync.runFromMainThreadを呼び出し | E-03 156-216行目 | ○ |
| C-20 | AnyTask.runを呼び出し | E-03 285-288行目 | ○ |
| C-21 | CppTask.runを呼び出し | E-03 293-296行目 | ○ |
| C-22 | デバッグビルドでjs_call_count_outside_tick_queue検証 | E-03 105-134行目 | ○ |
| C-23 | ConcurrentTask.create関数 | E-04 81-86行目 | ○ |
| C-24 | MiniEventLoopのbuild/install時使用 | E-10 17-18行目コメント | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Task TaggedPointerUnion定義
- **0 (低リスク)**: ConcurrentTask構造体定義
- **0 (低リスク)**: tickQueueWithCountの処理フロー
- **0 (低リスク)**: MiniEventLoopの処理フロー
- **0 (低リスク)**: PackedNextPtrのビットパッキング

## 6) レビュアーチェックリスト（最小）
- [ ] Task TaggedPointerUnionのタスク型数が正しいか確認
- [ ] ConcurrentTaskのサイズ（16バイト）がコードと一致しているか確認
- [ ] tickQueueWithCountのswitch文がコードと一致しているか確認
- [ ] HotReloadTask特別処理がコードと一致しているか確認
- [ ] MiniEventLoopの用途説明がコメントと一致しているか確認
- [ ] デバッグビルドのjs_call_count_outside_tick_queue検証がコードと一致しているか確認
