---
generated_at: 2026-01-27 17:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：115-メモリアロケータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/allocators/mimalloc.zig` 全体
- E-02: `src/allocators/mimalloc.zig` 1-41行目（基本アロケーション関数）
- E-03: `src/allocators/mimalloc.zig` 42-66行目（Heap opaque型）
- E-04: `src/allocators/mimalloc.zig` 67-144行目（ヒープ関連extern関数）
- E-05: `src/allocators/mimalloc.zig` 145-189行目（Option列挙型）
- E-06: `src/allocators/mimalloc.zig` 232-234行目（mustUseAlignedAlloc）
- E-07: `src/allocators/MimallocArena.zig` 全体
- E-08: `src/allocators/MimallocArena.zig` 1-9行目（Self構造体）
- E-09: `src/allocators/MimallocArena.zig` 13-18行目（Default構造体）
- E-10: `src/allocators/MimallocArena.zig` 25-80行目（Borrowed構造体）
- E-11: `src/allocators/MimallocArena.zig` 124-127行目（deinit）
- E-12: `src/allocators/MimallocArena.zig` 129-134行目（init）
- E-13: `src/allocators/MimallocArena.zig` 144-154行目（assertThreadOwnership）
- E-14: `src/allocators/MimallocArena.zig` 199-204行目（c_allocator_vtable）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mimallocのZigバインディングを提供 | E-01, E-02 | ○ |
| C-02 | Heap opaque型を定義 | E-03 | ○ |
| C-03 | mi_malloc, mi_free, mi_realloc等のextern宣言 | E-02 | ○ |
| C-04 | mi_heap_new, mi_heap_deleteのextern宣言 | E-04 67-69行目 | ○ |
| C-05 | Option列挙型（mimalloc設定オプション） | E-05 | ○ |
| C-06 | mustUseAlignedAllocで16バイト閾値判定 | E-06 232-234行目 | ○ |
| C-07 | MimallocArena構造体で#heapとthread_idを管理 | E-08 | ○ |
| C-08 | Default構造体はゼロサイズ | E-09 | ○ |
| C-09 | Borrowed構造体で借用パターンを実装 | E-10 | ○ |
| C-10 | Borrowed.getDefaultでmi_heap_main()を使用 | E-10 32-34行目 | ○ |
| C-11 | Borrowed.alignedAllocでアライメント判定 | E-10 51-70行目 | ○ |
| C-12 | initでmi_heap_new()呼び出し | E-12 131行目 | ○ |
| C-13 | deinitでmi_heap_destroy()呼び出し | E-11 125行目 | ○ |
| C-14 | assertThreadOwnershipでスレッド所有権検証 | E-13 | ○ |
| C-15 | デバッグビルドでsafety_checks有効 | E-07 5行目 | ○ |
| C-16 | c_allocator_vtableでAllocator VTable定義 | E-14 | ○ |
| C-17 | vtable_allocでBorrowed.alignedAlloc呼び出し | E-07 160-163行目 | ○ |
| C-18 | vtable_freeでmi_free呼び出し | E-07 169-187行目 | ○ |
| C-19 | vtable_resizeでmi_expand呼び出し | E-07 165-167行目 | ○ |
| C-20 | vtable_remapでmi_heap_realloc_aligned呼び出し | E-07 189-193行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: mimallocのextern宣言
- **0 (低リスク)**: MimallocArena構造体定義
- **0 (低リスク)**: Borrowedパターン実装
- **0 (低リスク)**: スレッド所有権検証
- **0 (低リスク)**: Allocator VTable実装

## 6) レビュアーチェックリスト（最小）
- [ ] mustUseAlignedAllocの閾値（16バイト）がコードと一致しているか確認
- [ ] MimallocArena構造体のフィールドがコードと一致しているか確認
- [ ] Borrowed.getDefaultがmi_heap_main()を呼び出しているか確認
- [ ] assertThreadOwnershipの検証ロジックがコードと一致しているか確認
- [ ] c_allocator_vtableの関数ポインタがコードと一致しているか確認
- [ ] デバッグビルドでのsafety_checks条件がコードと一致しているか確認
