---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：116-JavaScriptCoreバインディング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. ***.classes.tsからの自動生成の詳細**：コード生成システムの詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/bindings/JSValue.zig` 1-300行目
- E-02: `src/bun.js/bindings/JSValue.zig` 1-23行目（JSValue enum定義）
- E-03: `src/bun.js/bindings/JSValue.zig` 32-34行目（cast関数）
- E-04: `src/bun.js/bindings/JSValue.zig` 70-74行目（isFalsey/isTruthy）
- E-05: `src/bun.js/bindings/JSValue.zig` 119-121行目（toNumber）
- E-06: `src/bun.js/bindings/JSValue.zig` 124-137行目（isInteger）
- E-07: `src/bun.js/bindings/JSValue.zig` 151-183行目（coerce）
- E-08: `src/bun.js/bindings/JSValue.zig` 187-209行目（to）
- E-09: `src/bun.js/bindings/JSValue.zig` 249-270行目（call）
- E-10: `src/bun.js/bindings/JSGlobalObject.zig` 1-500行目
- E-11: `src/bun.js/bindings/JSGlobalObject.zig` 6-14行目（throwStackOverflow/throwOutOfMemory）
- E-12: `src/bun.js/bindings/JSGlobalObject.zig` 261-282行目（createErrorInstance）
- E-13: `src/bun.js/bindings/JSGlobalObject.zig` 372-376行目（throw）
- E-14: `src/bun.js/bindings/JSGlobalObject.zig` 422-424行目（throwValue）
- E-15: `src/bun.js/bindings/JSGlobalObject.zig` 483-489行目（hasException/clearException）
- E-16: `src/bun.js/bindings/VM.zig` 全体
- E-17: `src/bun.js/bindings/VM.zig` 7-15行目（create/deinit）
- E-18: `src/bun.js/bindings/VM.zig` 79-92行目（runGC/collectAsync）
- E-19: `src/bun.js/bindings/VM.zig` 117-143行目（notifyNeed*）
- E-20: `src/bun.js/bindings/VM.zig` 158-167行目（throwError）
- E-21: `src/bun.js/bindings/VM.zig` 174-179行目（drainMicrotasks）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JSValueはenum(i64)でEncodedJSValueとABI互換 | E-02 1-3行目 | ○ |
| C-02 | js_undefined = 0xa, null = 0x2, true/false定義 | E-02 5-8行目 | ○ |
| C-03 | zero = 0は例外発生を示す | E-02 10-12行目コメント | ○ |
| C-04 | cast関数でポインタからJSValueへ変換 | E-03 | ○ |
| C-05 | isFalsey/isTruthyで真偽値判定 | E-04 | ○ |
| C-06 | toNumberでToNumber抽象操作を実行 | E-05 | ○ |
| C-07 | isIntegerでNumber.isInteger互換判定 | E-06 | ○ |
| C-08 | coerceで型強制変換（f64, i64, i32） | E-07 | ○ |
| C-09 | toでゼロコスト型変換（u32, bool等） | E-08 | ○ |
| C-10 | call関数でJavaScript関数呼び出し | E-09 | ○ |
| C-11 | fromJSHostCallで例外チェック付き呼び出し | E-09 263行目 | ○ |
| C-12 | JSGlobalObjectはopaque型 | E-10 1行目 | ○ |
| C-13 | throwStackOverflow/throwOutOfMemoryでエラースロー | E-11 | ○ |
| C-14 | createErrorInstanceでエラーインスタンス生成 | E-12 | ○ |
| C-15 | throwでフォーマット付きエラースロー | E-13 | ○ |
| C-16 | throwValueで値をエラーとしてスロー | E-14 | ○ |
| C-17 | hasException/clearExceptionで例外状態管理 | E-15 | ○ |
| C-18 | VMはopaque型でHeapType enumを持つ | E-16 1-5行目 | ○ |
| C-19 | VM.create/deinitでVM作成・破棄 | E-17 | ○ |
| C-20 | runGC/collectAsyncでGC制御 | E-18 | ○ |
| C-21 | notifyNeed*TrapでVMトラップ通知 | E-19 | ○ |
| C-22 | VM.throwErrorでエラースロー | E-20 | ○ |
| C-23 | drainMicrotasksでマイクロタスクドレイン | E-21 | ○ |
| C-24 | *.classes.tsからZig/C++バインディング自動生成 | - | △ |

## 4) 不足情報（Unknown / Missing）
- ***.classes.tsからの自動生成の詳細**: コード生成システム（generate-classes.ts）の詳細仕様は別ディレクトリ（src/codegen/）にあり、本機能設計書の範囲外
  - 候補：src/codegen/generate-classes.tsの解析 / コード生成ドキュメントの参照

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: JSValue enum定義とABI互換性
- **0 (低リスク)**: JSGlobalObjectのエラー処理関数
- **0 (低リスク)**: VMの制御関数
- **0 (低リスク)**: 型変換関数（to, coerce）
- **1 (中リスク)**: コード生成システムとの関連

## 6) レビュアーチェックリスト（最小）
- [ ] JSValue enumの定義値（0xa, 0x2等）がコードと一致しているか確認
- [ ] call関数のfromJSHostCall呼び出しがコードと一致しているか確認
- [ ] JSGlobalObjectのエラー処理関数がコードと一致しているか確認
- [ ] VMのGC制御関数がコードと一致しているか確認
- [ ] notifyNeed*Trap関数がコードと一致しているか確認
- [ ] drainMicrotasks関数がコードと一致しているか確認
