---
generated_at: 2026-01-27 18:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：17-bun_init.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **行番号の精度**：大規模ファイル（1270行）のため概算値

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/init_command.zig` - InitCommand構造体、exec関数（1-1270行目）
- E-02: `src/cli/init/gitignore.default` - .gitignoreテンプレート（@embedFile参照）
- E-03: `src/cli/init/tsconfig.default.json` - tsconfig.jsonテンプレート（@embedFile参照）
- E-04: `src/cli/init/README.default.md` - README.mdテンプレート（@embedFile参照）
- E-05: `src/init/rule.md` - Agent Ruleテンプレート（@embedFile参照）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.17の定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.11との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun initはプロジェクトを対話的に初期化 | E-06 | ○ |
| C-02 | InitCommand構造体定義 | E-01 (1行目) | ○ |
| C-03 | prompt関数で対話入力 | E-01 (2-40行目) | ○ |
| C-04 | processRadioButton関数で選択UI | E-01 (44-178行目) | ○ |
| C-05 | radio関数がラジオボタンのラッパー | E-01 (181-223行目) | ○ |
| C-06 | Assets構造体でテンプレートファイル定義 | E-01 (225-311行目) | ○ |
| C-07 | exec関数がメイン処理 | E-01 (349-867行目) | ○ |
| C-08 | Template列挙型定義 | E-01 (917-994行目) | ○ |
| C-09 | --minimal/-mオプションサポート | E-01 (364行目) | ○ |
| C-10 | --yes/-yオプションサポート | E-01 (367行目) | ○ |
| C-11 | --react/-rオプションサポート | E-01 (373行目) | ○ |
| C-12 | --react=tailwindオプション | E-01 (377行目) | ○ |
| C-13 | --react=shadcnオプション | E-01 (381行目) | ○ |
| C-14 | ディレクトリ作成処理 | E-01 (397-406行目) | ○ |
| C-15 | パッケージ名正規化 | E-01 (314-339行目) | ○ |
| C-16 | 既存package.json読み込み | E-01 (414-489行目) | ○ |
| C-17 | .gitignoreテンプレート埋め込み | E-01, E-02 (227行目) | ○ |
| C-18 | tsconfig.jsonテンプレート埋め込み | E-01, E-03 (228行目) | ○ |
| C-19 | README.mdテンプレート埋め込み | E-01, E-04 (229行目) | ○ |
| C-20 | createAgentRule関数 | E-01 (1017-1062行目) | ○ |
| C-21 | isCursorInstalled検出 | E-01 (1064-1096行目) | ○ |
| C-22 | isClaudeCodeInstalled検出 | E-01 (1000-1014行目) | ○ |
| C-23 | ReactBlankテンプレート定義 | E-01 (1105-1121行目) | ○ |
| C-24 | ReactTailwindテンプレート定義 | E-01 (1124-1141行目) | ○ |
| C-25 | 行番号の完全な精度 | **概算値** | △ |

## 4) 不足情報（Unknown / Missing）
- 行番号はファイルの構造から推定した概算値
  - 候補：ファイル全文の再解析

## 5) リスクフラグ（レビュー観点）
- 0: 基本構造と処理フローの記述
- 0: テンプレートファイルの参照
- 1: 具体的な行番号（概算のため要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] init_command.zigの行番号を実際のファイルと照合
- [ ] Reactテンプレートファイルの存在確認
- [ ] Agent Rule生成の条件確認（Claude Code / Cursor検出ロジック）
- [ ] テンプレートファイル（init/ディレクトリ）の構成確認
