---
generated_at: 2026-01-27 18:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：18-bun_create.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **行番号の精度**：大規模ファイルのため概算値
  2. **Example構造体**：詳細実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/create_command.zig` - CreateCommand構造体、exec関数（1-500行目読み込み）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.18の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.12との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun createはテンプレートからプロジェクト作成 | E-02 | ○ |
| C-02 | initializeStore関数 | E-01 (4-10行目) | ○ |
| C-03 | skip_dirs定義 | E-01 (12-15行目) | ○ |
| C-04 | skip_files定義 | E-01 (16-20行目) | ○ |
| C-05 | CreateOptions構造体 | E-01 (142-190行目) | ○ |
| C-06 | --forceオプション | E-01 (153行目) | ○ |
| C-07 | --no-installオプション | E-01 (154行目) | ○ |
| C-08 | --no-gitオプション | E-01 (155行目) | ○ |
| C-09 | --verboseオプション | E-01 (156行目) | ○ |
| C-10 | --openオプション | E-01 (158行目) | ○ |
| C-11 | CreateCommand.exec関数 | E-01 (194行目) | ○ |
| C-12 | GitHub/公式/ローカル種別判定 | E-01 (253-426行目) | ○ |
| C-13 | tarball取得処理 | E-01 (258-318行目) | ○ |
| C-14 | Zlib.ZlibReaderArrayListでgunzip | E-01 (329行目) | ○ |
| C-15 | Archiver.extractToDiskでtar展開 | E-01 (389行目) | ○ |
| C-16 | ローカルフォルダコピー処理 | E-01 (412-500行目) | ○ |
| C-17 | package.json変換処理 | E-01 | ○ |
| C-18 | bun install子プロセス実行 | E-01 | ○ |
| C-19 | Example構造体の詳細 | **ファイル後半未読** | △ |
| C-20 | 行番号の完全な精度 | **概算値** | △ |

## 4) 不足情報（Unknown / Missing）
- Example構造体の詳細実装
  - 候補：create_command.zigの後半部分の読み込み
- 行番号の精度
  - 候補：ファイル全文の再解析

## 5) リスクフラグ（レビュー観点）
- 0: 基本構造と処理フローの記述
- 1: 具体的な行番号（概算のため要確認）
- 1: Example構造体の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] create_command.zigの行番号を実際のファイルと照合
- [ ] Example構造体とfetch関数の詳細確認
- [ ] GitHub APIとの連携部分の確認
- [ ] tarball展開処理の詳細確認
