---
generated_at: 2026-01-27 18:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：19-bunx.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **行番号の精度**：大規模ファイルのため概算値含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/bunx_command.zig` - BunxCommand構造体、exec関数（1-882行目読み込み）
- E-02: `src/cli/run_command.zig` - Run.runBinary関数（インポート参照）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.19の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.13との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bunxはパッケージを一時的にインストールして実行 | E-03 | ○ |
| C-02 | BunxCommand構造体定義 | E-01 (3行目) | ○ |
| C-03 | Options構造体定義 | E-01 (7-136行目) | ○ |
| C-04 | Options.parse関数 | E-01 (32-130行目) | ○ |
| C-05 | --bun/-bオプション | E-01 (60-61行目) | ○ |
| C-06 | --silentオプション | E-01 (58-59行目) | ○ |
| C-07 | --verboseオプション | E-01 (56-57行目) | ○ |
| C-08 | --no-installオプション | E-01 (62-63行目) | ○ |
| C-09 | --package/-pオプション | E-01 (64-89行目) | ○ |
| C-10 | addCreatePrefix関数 | E-01 (140-176行目) | ○ |
| C-11 | キャッシュ有効期限1日（24時間） | E-01 (179-181行目) | ○ |
| C-12 | getBinNameFromSubpath関数 | E-01 (183-251行目) | ○ |
| C-13 | getBinNameFromProjectDirectory関数 | E-01 (253-257行目) | ○ |
| C-14 | getBinNameFromTempDirectory関数 | E-01 (259-306行目) | ○ |
| C-15 | getBinName関数 | E-01 (308-325行目) | ○ |
| C-16 | exec関数がメイン処理 | E-01 (332-863行目) | ○ |
| C-17 | tsc → typescript変換 | E-01 (361-363行目) | ○ |
| C-18 | キャッシュパス形式 /tmp/bunx-{uid}-{package@version}/ | E-01 (515-534行目) | ○ |
| C-19 | bun.which使用 | E-01 (556行目) | ○ |
| C-20 | stale判定処理 | E-01 (577-606行目) | ○ |
| C-21 | Run.runBinary呼び出し | E-01 (621-629行目) | ○ |
| C-22 | bun addサブプロセス実行 | E-01 (714-770行目) | ○ |
| C-23 | NoBinFoundエラー | E-01 (675-682行目) | ○ |
| C-24 | UpdateRequest.parse使用 | E-01 (339-352行目) | ○ |
| C-25 | 行番号の完全な精度 | **概算値含む** | △ |

## 4) 不足情報（Unknown / Missing）
- 行番号の精度
  - 候補：ファイル全文の詳細解析

## 5) リスクフラグ（レビュー観点）
- 0: 基本構造と処理フローの記述
- 0: オプション解析の記述
- 1: 具体的な行番号（概算のため要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] bunx_command.zigの行番号を実際のファイルと照合
- [ ] キャッシュ有効期限の実装確認
- [ ] Run.runBinaryの動作確認
- [ ] stale判定ロジックの確認
