---
generated_at: 2026-01-27 17:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-bun_publish.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/publish_command.zig` - publishコマンド実装
- E-02: `src/cli/pack_command.zig` - pack処理
- E-03: `src/install/PackageManager.zig` - パッケージマネージャー初期化
- E-04: `src/install/npm.zig` - npmレジストリ通信
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun publishはnpmパッケージをレジストリに公開する | E-01 (531-730行目) | ○ |
| C-02 | tarballをHTTP PUTでアップロード | E-01 (597-608行目) | ○ |
| C-03 | package.jsonからname/versionを取得 | E-01 (131-182行目) | ○ |
| C-04 | private: trueの場合はエラー | E-01 (142-148行目) | ○ |
| C-05 | SHA1/SHA512ハッシュを計算 | E-01 (184-196行目) | ○ |
| C-06 | OTP認証をサポート | E-01 (752-920行目) | ○ |
| C-07 | Web認証（authUrl）をサポート | E-01 (770-807行目) | ○ |
| C-08 | publishConfig設定を適用 | E-01 (150-167行目) | ○ |
| C-09 | --dry-runオプションをサポート | E-01 (570行目) | ○ |
| C-10 | --tagオプションをサポート | E-01 (151-155行目) | ○ |
| C-11 | --accessオプションをサポート | E-01 (157-165行目) | ○ |
| C-12 | --tolerate-republishオプションをサポート | E-01 (541-555行目) | ○ |
| C-13 | restrictedはスコープ付きパッケージのみ | E-01 (172-176行目) | ○ |
| C-14 | 認証情報がない場合はエラー | E-01 (537-539行目) | ○ |
| C-15 | publish/postpublishスクリプトを実行 | E-01 (400-447行目) | ○ |
| C-16 | tarball指定とworkspace指定の両方をサポート | E-01 (307-379行目) | ○ |
| C-17 | Context構造体でpublish情報を管理 | E-01 (2-31行目) | ○ |
| C-18 | constructPublishRequestBodyでリクエストボディ構築 | E-01 (1362-1425行目) | ○ |
| C-19 | constructPublishHeadersでヘッダー構築 | E-01 (1260-1360行目) | ○ |
| C-20 | normalizedPackageでパッケージ情報正規化 | E-01 (922-1043行目) | ○ |
| C-21 | checkPackageVersionExistsでバージョン確認 | E-01 (454-529行目) | ○ |
| C-22 | 関連画面No.14 publish | E-06 (51-52行目) | ○ |
| C-23 | 機能No.22 bun publish | E-05 (23行目) | ○ |
| C-24 | Base64エンコードでtarballを送信 | E-01 (1414-1417行目) | ○ |
| C-25 | 一般的なパッケージで数秒から数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: パフォーマンス要件の具体的数値
  - 候補：ベンチマーク結果 / 実測データ / npm公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は実装と一致
- 0: 低リスク - 認証処理の詳細は正確に記述
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] C-25: パフォーマンス要件の妥当性を実測で確認
- [ ] OTP認証フローの詳細が正確か確認
- [ ] プライベートレジストリ（Verdaccio等）での動作確認
- [ ] エラーハンドリングの網羅性を確認
