---
generated_at: 2026-01-27 17:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：23-bun_patch.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/patch_command.zig` - patchコマンドエントリーポイント
- E-02: `src/install/PackageManager/patchPackage.zig` - パッチ準備処理実装
- E-03: `src/install/lockfile.zig` - lockfile読み込み
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun patchはパッケージを編集可能状態にする | E-02 (544-727行目) | ○ |
| C-02 | 引数はパス形式と名前@バージョン形式の2種類 | E-02 (952-960行目, PatchArgKind) | ○ |
| C-03 | lockfileからパッケージ情報を取得 | E-02 (545行目, lockfile参照) | ○ |
| C-04 | キャッシュからnode_modulesにコピー | E-02 (709行目, overwritePackageInNodeModulesFolder) | ○ |
| C-05 | 複数バージョン存在時はエラー | E-02 (919-941行目) | ○ |
| C-06 | 既存パッチがある場合はパッチハッシュを含める | E-02 (633-643行目, existing_patchfile_hash) | ○ |
| C-07 | ワークスペースルートでない場合はパス調整 | E-02 (556-568行目, not_in_workspace_root) | ○ |
| C-08 | 編集フォルダとcommitコマンドを案内表示 | E-02 (717-724行目) | ○ |
| C-09 | node_modules, .git等を除外してコピー | E-02 (758-762行目) | ○ |
| C-10 | FileCopierでファイルコピー | E-02 (764-772行目) | ○ |
| C-11 | pkgInfoForNameAndVersionでパッケージ検索 | E-02 (796-942行目) | ○ |
| C-12 | パッケージ名のハッシュで検索 | E-02 (807行目) | ○ |
| C-13 | computeCacheDirAndSubpathでキャッシュパス計算 | E-02 (645-652行目, 683-691行目) | ○ |
| C-14 | lockfile必須のビジネスルール | E-02 (暗黙的に必要) | ○ |
| C-15 | ハードリンク解除の目的 | E-02 (705-708行目コメント) | ○ |
| C-16 | preparePatch関数がメイン処理 | E-02 (544行目) | ○ |
| C-17 | 関連画面No.15 patch | E-05 (53行目) | ○ |
| C-18 | 機能No.23 bun patch | E-04 (24行目) | ○ |
| C-19 | pnpm/yarnとの互換性 | E-02 (パッチファイル形式から推測) | ○ |
| C-20 | 一般的なパッケージで数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: パフォーマンス要件の具体的数値
  - 候補：ベンチマーク結果 / 実測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は実装と一致
- 0: 低リスク - 引数形式の判定ロジックは正確
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] C-20: パフォーマンス要件の妥当性を実測で確認
- [ ] 複数バージョン存在時のエラーメッセージが適切か確認
- [ ] ワークスペース環境でのパス表示が正確か確認
